import {resizeContainerAndCanvas} from "../../../modules/HTMLUtils.js";
import CtxUtils from "../../../modules/Context2DUtils.js";
import V2 from "../../../modules/V2.js"; 

/**
 * Construcción de curva de Bézier de grado 2.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);
function main(){
    
    var canvas = document.getElementById("canvas");
    resizeContainerAndCanvas(canvas);
    let controls = document.getElementById("ui-container");
    controls.className = "bottom-box";
     
    let {width, height} = canvas;
    
    const P0 = new V2(.14*width, .8*height);
    const P1 = new V2(.48*width, .1*height);
    const P2 = new V2(.84*width, .7*height);
    const textPos = new V2(.7*width, .92*height);
    const LINE_COLOR = "black";
    const QLERP_COLOR = "red";
    const LLERP_COLOR = "rgb(170, 224, 61)"; // rgb(70, 130, 180)
    const radius = 3;
    const line_thickness = 2.8;
    window.addEventListener('resize', draw);
    var time = 0; //Contador de tiempo para hacer la espera
    const wait_time = .5; //tiempo de espera
    var t = 0;
    var c = 0; //Contador auxiliar 
    
    requestAnimationFrame(draw);

    function draw(){
        resizeContainerAndCanvas(canvas);
        CtxUtils.clear();
        var Q0 = CtxUtils.lerp(P0, P1, t);
        var Q1 = CtxUtils.lerp(P1, P2, t);
        var R0 = CtxUtils.lerp(Q0, Q1, t);
        
        CtxUtils.drawLine(P0, P1, line_thickness, LINE_COLOR);
        CtxUtils.drawLine(P1, P2, line_thickness, LINE_COLOR);
        CtxUtils.drawLine(Q0, Q1, line_thickness + .5, LLERP_COLOR);

        CtxUtils.drawQuadBezierT(P0, P1, P2, t, 25, QLERP_COLOR, 3.5);

        CtxUtils.drawCircle(P0, radius, QLERP_COLOR, 2, QLERP_COLOR);
        let MIDDLE_DOT_COLOR = (t >= 1) ? LLERP_COLOR : LINE_COLOR;
        CtxUtils.drawCircle( P1, radius, MIDDLE_DOT_COLOR, 2, MIDDLE_DOT_COLOR);
        CtxUtils.drawCircle(Q0, radius, LLERP_COLOR, 2, LLERP_COLOR);
        if(t < 1){
            CtxUtils.drawCircle(P2, radius, LINE_COLOR, 2, LINE_COLOR);
            CtxUtils.drawCircle(Q1, radius, LLERP_COLOR, 2, LLERP_COLOR);
        }
        CtxUtils.drawCircle(R0, radius, QLERP_COLOR, 2.3, QLERP_COLOR);
    
        CtxUtils.putText("t = " + t.toFixed(2), 21, textPos.x, textPos.y, "black");
        
        if(t >= 1 && time <= wait_time){
            time += 0.01;
        }
        else{
            time = 0;
            //Actualizamos t 
            c = (c + 3) % 1003; // Cálculo con enteros para evitar problemas de precisión con decimales de js 
            t = c / 1000;
        }
        requestAnimationFrame(draw);
    }
}