"use strict";

import {resize, TextBox} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import {Plane} from "../../geometry/Figure.js";
import SolidColor from "../../materials/SolidColor.js";
import V3 from "../../modules/V3.js";

/**
 * Generación de un mipmap 1x1 con una textura de 2x2.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
   
    let planeFigure = new Plane(.5,.5);
    let material = new SolidColor(gl, WebGL, planeFigure);
    let scale = M4.scale(.5,.5,.5);

    let pixel = M4.translate(0,-.3,-1);
    let P00 = M4.multiply(M4.translate(-.75,.35,-1), scale);
    let P10 = M4.multiply(M4.translate(-.5,.35,-1), scale);
    let P11 = M4.multiply(M4.translate(-.5,.6,-1), scale);
    let P01 = M4.multiply(M4.translate(-.75,.6,-1), scale);

    let Q00 = M4.multiply(M4.translate(.65,.35,-1), scale);

    let C00 = randomColor();
    let C10 = randomColor();
    let C11 = randomColor();
    let C01 = randomColor();

    let finalColor = C00.v.add(C10.v.add(C11.v.add(C01.v)));
    let finalArrayColor = [finalColor.x/4, finalColor.y/4, finalColor.z/4, 1];

    //Label
    let container = document.getElementById("container");
    let pixelLabel = new TextBox(container, {bottom: 0, left: 45}, "Pixel");
    let twoDLabel = new TextBox(container, {top: 43, left:21}, "2x2");
    let oneDLabel = new TextBox(container, {top: 43, right:21}, "1x1");

    gl.enable(gl.DEPTH_TEST);
    
    gl.clearColor(0, 0, 0, 0);
    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);

    window.addEventListener('resize', draw);
    
    draw();

    function draw(){        
        resize(canvas);
        var {width, height} = gl.canvas;

        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
             
        let aspect = width/height;
        var projectionMatrix = M4.perspective(75, aspect, .1, 100);

        gl.useProgram(material.program);
        gl.bindVertexArray(material.vao);

        //P00 2X2
        material.uniforms.u_PVM_matrix = M4.multiply(projectionMatrix, P00); 
        material.uniforms.u_color = C00.arr;
        render();
        //P10
        material.uniforms.u_PVM_matrix = M4.multiply(projectionMatrix, P10); 
        material.uniforms.u_color = C01.arr;
        render();
        //P11
        material.uniforms.u_PVM_matrix = M4.multiply(projectionMatrix, P11); 
        material.uniforms.u_color = C11.arr;
        render();
        //P01
        material.uniforms.u_PVM_matrix = M4.multiply(projectionMatrix, P01); 
        material.uniforms.u_color = C10.arr;
        render();

        //Q00 1X1
        material.uniforms.u_PVM_matrix = M4.multiply(projectionMatrix, Q00); 
        material.uniforms.u_color = finalArrayColor;
        render();

        //Pixel
        material.uniforms.u_PVM_matrix = M4.multiply(projectionMatrix, pixel); 
        material.uniforms.u_color = finalArrayColor;
        
        render();
      
    }
    function render(){
        material.setUniforms(material.uniforms);
        
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, material.indexBuffer);
        gl.drawElements( gl.TRIANGLES, material.numIndices,  gl.UNSIGNED_SHORT, 0);

        gl.bindBuffer(gl.ARRAY_BUFFER, null);      
    }
    function randomColor() {
        let arr = [Math.random(), Math.random(), Math.random(), 1];
        return { arr: arr, v: new V3(arr[0], arr[1], arr[2])};
      }
} 