"use strict";

import {Checkbox, resize, resizeAndCenterX, Select, Slider} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import RandomTexture from "../../materials/RandomTexture.js";
import {Cube, Plane, Sphere} from "../../geometry/Figure.js";
import V3 from "../../modules/V3.js";
import {TrackballCamera, registerCameraEvents} from "../../modules/Trackballcamera.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";

/**
 * Ejemplos de texturas proceudrales aleatorias.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;

    let textureIds = { "ruido blanco": 0, "ruido Perlín": 1,"ruido Perlín 2": 2, "ruido Worley": 3, "ruido Worley 2x2": 4};
    let figuresIds = { "plano": 0, "esfera": 1, "cubo": 2}
    let figuresGeom = [new Plane(.9,.9), new Sphere(.5, 30, 30), new Cube(1)];
    let uniforms = {};
    const cubeTransform = M4.multiplyArray([M4.translate(0,0.07,-.8), M4.rotateX(10),M4.rotateY(30)]);
    let figures = [ new GeometryPainter(gl, new RandomTexture(gl, WebGL,figuresGeom[0]), M4.translate(0,.01,-.1)),
                    new GeometryPainter(gl, new RandomTexture(gl, WebGL,figuresGeom[1],1), M4.translate(0,0.02,-.3)),
                    new GeometryPainter(gl, new RandomTexture(gl, WebGL,figuresGeom[2]), cubeTransform),
                ];
                 
    let camera = new TrackballCamera(new V3(0,0,.6));
    camera.setZoomConfig(1.2, .3);
    let viewMatrix;

    let controls = document.getElementById("ui-container-up");
    let right_options = document.getElementById("ui-container-center");
    let scaleFactorSlider = new Slider(controls, "Escalar", 1, 30, updateScaleFactor, 20, 1, ["#4994D0"]);
    let checkAnimation = new Checkbox(controls, "animation", "Animar", draw, true);
    let selectTexture = new Select(right_options, "textures", setTextureId, textureIds, "ruido Perlín 2");
    let selectFigure= new Select(right_options, "textures", setFigure, figuresIds, "plano");
    var figureId = 0;
    uniforms.texture_id = 2;
    
    gl.enable(gl.DEPTH_TEST);
    gl.clearColor(0, 0, 0, 0);
    
    window.addEventListener('resize', draw);
    registerCameraEvents(camera, canvas, draw);
    requestAnimationFrame(draw);

    function draw(current){ 
        if(checkAnimation.checked()){
            scaleFactorSlider.slider.disabled = true;
        }else{
            scaleFactorSlider.slider.disabled = false;
        }

        resize(canvas);
        resizeAndCenterX(controls, 0);
        resizeAndCenterX(right_options, 0);
        var {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
        
        viewMatrix = camera.getMatrix();
        let aspect = width/height;
        var projectionMatrix = M4.perspective(85, aspect, .1, 100);
        if(!current){   
            current = 333333;
        }
        current = current * 0.0001;
        uniforms.u_time = current;
        uniforms.u_resolution = [width, height];
        figures[figureId].drawSimple(gl, viewMatrix, projectionMatrix, uniforms);
        if(checkAnimation.checked()){
            window.requestAnimationFrame(draw);
        }else{
            if (!window.cancelAnimationFrame)
                window.cancelAnimationFrame();
        }
    }
    function setTextureId(value){
        uniforms.texture_id = textureIds[value];
        draw();
    }
    function updateScaleFactor(value){
        uniforms.scale_factor = value;
        draw();
    }
    function setFigure(value){
        figureId =figuresIds[value];
    }
} 