"use strict";

import {resize} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import {Cube, Sphere} from "../../geometry/Figure.js";
import {TrackballCamera} from "../../modules/Trackballcamera.js";
import V3 from "../../modules/V3.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";
import Light from "../../geometry/Light.js";
import TextureMapping from "../../materials/TextureMapping.js";

/**
 * Ejemplo de texture mapping usando una textura de la tierra.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    let planeFigure = new Sphere(1, 60, 60);//new Cube(.5, false);
    let srcTextures = [ "../../../images/capitulo_07/textures/2k_earth_daymap.jpg",
                        "../../../images/capitulo_07/textures/2k_earth_specular_map.jpg"];
    
    let lightPosition = [0.8, 1.18, 2.8, 0];
    let uniforms = { mode: 4, 
                    u_material : {}, 
                     u_light: { position: lightPosition, la: [0.1,0.1,0.1], ld: [1, 1, 1],
                                ls: [0.5, 0.3, 0.1]}};

    let material =  new TextureMapping(gl, WebGL, planeFigure, srcTextures, setTextures, uniforms); 
   
    let sphere = new GeometryPainter(gl, material, M4.rotateX(20));
    var pos = new V3(0,0,1.5);
    let camera = new TrackballCamera(pos);
    
    let bulb = new Light(gl, WebGL, lightPosition);
    let textures;
    let angle = 0;
    
    /*let light_controls = document.getElementById("ui-container-up");
    addLabel(light_controls, "Posición de la luz");
    var light_pos_x = new Slider(light_controls, "x", -10, 10, upadeteLPos(0), lightPosition[0], 0.01, ["#4994D0"]);
    var light_pos_y = new Slider(light_controls, "y", -10, 10, upadeteLPos(1), lightPosition[1], 0.01, ["#4994D0"]);
    var light_pos_z = new Slider(light_controls, "z", -1, 6, upadeteLPos(2), lightPosition[2], 0.01, ["#4994D0"]);
    */
    gl.enable(gl.DEPTH_TEST);
    gl.enable(gl.CULL_FACE);
    
    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
    gl.clearColor(0, 0, 0, 0);

    window.addEventListener('resize', draw);
    //registerCameraEvents(camera, canvas, draw);
    requestAnimationFrame(draw);
    
    function draw(){        
        resize(canvas);
        //resizeAndCenterX(light_controls, {});
        
        var {width, height} = gl.canvas;
        
        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
        
        let aspect = width/height;
        var projectionMatrix = M4.perspective(85, aspect, .1, 100);
        var viewMatrix = camera.getMatrix();
        var lightPos = M4.multiplyVector(viewMatrix, lightPosition);
    
        uniforms.u_light.position = lightPos;
        if(textures){
            uniforms.u_material = { diffuse_map : { id: 0, texture: textures[0]},
                                    specular_map : { id: 1, texture: textures[1]},
                                    normal_map : { id: 2, texture: textures[2]},
                                    shininess: 0.3*128};

            angle = (angle + 0.1)% 360;
            sphere.draw(gl, M4.multiply(viewMatrix, M4.rotateY(-angle)), projectionMatrix, uniforms);   
        }
        //bulb.draw(gl, M4.multiply(viewMatrix, M4.scale(.5, .5, .5)), projectionMatrix, lightPosition);
        requestAnimationFrame(draw);

    }
    function setTextures(loadedTextures){
        textures = loadedTextures;
        draw();
    }
    function upadeteLPos(index){
        return function(value){
            lightPosition[index] = value;
            draw();
        }
    }
} 