/**
 * Clase auxiliar para la carga de modelos OBJ, 
 * permitiendo obtener un arreglo de sus vértices, caras y texeles.
 * @author Melissa Méndez Servín.
 */
export default class LoadOBJ {

    constructor(filename) {
        let file_content = openExternalFile(filename);
        let lines = file_content.split("\n");
        let initial_vertices = [];
        let initial_uvs = [];
        let initial_normals = [];
        let faces = [];
        let data;

        for (let i=0, l=lines.length; i<l; i++) {
            // vertices
            if (lines[i].startsWith("v ")) {
              data = lines[i].trim().split(" ");
              data.shift();
              initial_vertices.push(data);
            }
    
            // texture coordinates
            if (lines[i].startsWith("vt ")) {
              data = lines[i].trim().split(" ");
              data.shift();
              initial_uvs.push(data);
            }
    
            // normals
            if (lines[i].startsWith("vn ")) {
              data = lines[i].trim().split(" ");
              data.shift();
              initial_normals.push(data);
            }
    
            // faces
            if (lines[i].startsWith("f ")) {
              data = lines[i].trim().split(" ");
              data.shift();
              faces.push(data);
            }
        }
        //console.log(faces.length);
        this.vertices = [];
        this.uvs = [];
        this.normals = [];
        let tmp1, tmp2, tmp3;
        let v1, v2, v3;
        for(let i=0,f = faces.length; i<f; i++) {
            // triangle
            if (faces[i].length === 3) {
                tmp1 = faces[i][0].split("/");
                tmp2 = faces[i][1].split("/");
                tmp3 = faces[i][2].split("/");

                v1 = parseInt(tmp1[0])-1;
                v2 = parseInt(tmp2[0])-1;
                v3 = parseInt(tmp3[0])-1;
                
                this.vertices = this.vertices.concat(initial_vertices[v1]).concat(initial_vertices[v2]).concat(initial_vertices[v3]);
                if (tmp1[1]) {
                    v1 = parseInt(tmp1[1])-1;
                    v2 = parseInt(tmp2[1])-1;
                    v3 = parseInt(tmp3[1])-1;
                    this.uvs = this.uvs.concat(initial_uvs[v1]).concat(initial_uvs[v2]).concat(initial_uvs[v3]);
                }

                if (tmp1[2]) {
                    v1 = parseInt(tmp1[2])-1;
                    v2 = parseInt(tmp2[2])-1;
                    v3 = parseInt(tmp3[2])-1;
                    this.normals = this.normals.concat(initial_normals[v1]).concat(initial_normals[v2]).concat(initial_normals[v3]);
                }
            }
        }
      this.obj = true;
      this.numElements = this.vertices.length/3;
    }

    getVertices(){
        return this.vertices;
    }
    getNormals(){
        return this.normals;
    }
    getTexcoords(){
        return this.uvs;
    }
    parseData(){
        let array = this.vertices;
        let l = array.length-1;
        let str = "";
        for(var i = 0; i < l; i++){
            str += array[i] + ",";
            if(i % 8 == 0)
                str += "\n";
        }
        return str + array[l];
    }
}
function openExternalFile(filename) {
    let XHR = new XMLHttpRequest();

    XHR.open("GET", filename, false);
    try {
        XHR.send(null);

        // https://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html
        if (XHR.status === 200) {
        return XHR.responseText;
        }
        else {
        throw "Archivo no encontrado";
        }
    }
    catch(e) {
        throw e;
    }
}

