import * as Utils from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";

/**
 * Traspuesta de una matriz.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){

    var canvas = document.getElementById("canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    
    Utils.resizeContainerAndCanvas(canvas);
    
    let equations = document.getElementById("equations");
    
    const A = "\\kern{1.3em} \\mathbf{A}";

    const T = "\\kern{1.8em} \\mathbf{A^{T}}"; 
    
    //MathBoxes para escribir las matrices
    let nameA = new Utils.MathBox(equations, {top: 14, left: 12}, A);
    let namet = new Utils.MathBox(equations, {top: 14, left: 48}, T);
    let matrixA = new Utils.MathBox(equations, {top: 31, left: 12});
    let matrixTA = new Utils.MathBox(equations, {top: 31, left: 48});
    const color1 = "#FF4500";
    const color2 = "#FFA500";
    const color3 = "#808000";
    //#F3F4F5
    var mA = "";
    var mT = "";
    //Para la animación
    var time = 0; //Contador de tiempo para hacer la espera
    const wait_time = 1.21; //tiempo de espera
    var step = 0;
    window.addEventListener('resize', draw);
    draw();
    
    function draw(){
        Utils.resizeContainer2D();

        switch(step){
            case 0:
                mA = getMatrixColor("black", "black", "black");
                mT = getTransposeColor("white","white", "white");
                break;
            case 1:
                mA = getMatrixColor(color1, "black","black");
                mT = getTransposeColor(color1,"white", "white");
                break;
            case 2:
                mA = getMatrixColor("black", color2, "black");
                mT = getTransposeColor("black",color2, "white");
                break;
            case 3: 
                mA = getMatrixColor("black", "black", color3);
                mT = getTransposeColor("black","black", color3);
                break;
            case 4:
                mA = getMatrixColor("black", "black", "black");
                mT = getTransposeColor("black","black", "black");
                break;
        }

        matrixA.setText(mA);
        matrixTA.setText(mT);
        
        if(time <= wait_time){
            time += 0.01;
        }
        else{
            time = 0;
            step = (step + 1) % 5;
        }
        window.requestAnimationFrame(draw);
        
    } 
    function getMatrixColor(r1,r2,r3){
        return "\\begin{bmatrix}" +
        "\\color{" + r1 + "}1 &  \\color{" + r1 + "}2 \\\\" +
        "\\color{" + r2 + "}3 &  \\color{" + r2 + "}4 \\\\" +
        "\\color{" + r3 + "}5 &  \\color{" + r3 + "}6" + 
        "\\end{bmatrix}";
    }

    function getTransposeColor(c1,c2,c3){
        return  "\\begin{bmatrix}" + 
                "\\color{" + c1 + "}1 & \\color{" + c2 + "}3 & \\color{" + c3 + "}5 \\\\" + 
                "\\color{" + c1 + "}2 &  \\color{" + c2 + "}4 & \\color{" + c3 + "}6" +
                "\\end{bmatrix}";
    }
}
