"use strict";

import {resize, TextBox} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import Diffuse from "../../materials/Diffuse.js";
import SolidColor from "../../materials/SolidColor.js";
import Suzanne209 from "../../geometry/Suzanne209.js";
import Suzanne15744 from "../../geometry/Suzanne15744.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";
import {TrackballCamera, registerCameraEvents} from "../../modules/Trackballcamera.js";
import V3 from "../../modules/V3.js";

/**
 * Comparación de mallas triangulares con diferente número de caras y mismo modelo. Modelo Suzanne.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    
    let suzanne_290 = new Suzanne209();
    let suzanne_15744 = new Suzanne15744();
    let lightPosition = [2, 3, 3, 0];
    let diffuseUniforms = { u_light_position: lightPosition };
    let uniform = {u_color: [.85,.85,.85,1]};

    let leftFigure = new GeometryPainter(gl, new Diffuse(gl, WebGL, suzanne_290, uniform));
    let rightFigure = new GeometryPainter(gl, new Diffuse(gl, WebGL, suzanne_15744, uniform));
    //let leftWireframe = new GeometryPainter(gl, new SolidColor(gl, WebGL, suzanne_290, [.22,.22,.22,1]));
    //let rightWireframe = new GeometryPainter(gl, new SolidColor(gl, WebGL, suzanne_15744, [.22,.22,.22,1]));

    var fov = 65;
    if(window.innerWidth < window.innerHeight)
        fov = 90;

    
    let zNear = .1;
    let zFar = 2000;
    let leftCamera = new TrackballCamera(new V3(0,0,1.5));
    let rightCamera = new TrackballCamera(new V3(0,0,3));
    leftCamera.setZoomConfig(3,1,0.05);
    rightCamera.setZoomConfig(6,2);
    resize(canvas);
    
    let container = document.getElementById("container");
    let ccLabel = new TextBox(container, { right: 1, bottom: 0}, "Suzanne. Modelo obtenido de Blender.");
    ccLabel.setPosition({top: 1, left: 1});

    gl.enable(gl.CULL_FACE);
    gl.enable(gl.DEPTH_TEST);
    gl.enable(gl.SCISSOR_TEST);
    
    gl.clearColor(0, 0, 0, 0);

    window.addEventListener('resize', draw);
    registerCameraEvents(leftCamera, canvas, draw);
    registerCameraEvents(rightCamera, canvas, draw);
    
    draw();
    

    function draw(){        
        resize(canvas);
    
        const {width, height} = gl.canvas;
        const leftWidth = width / 2 | 0;
        const rightWidth = width - leftWidth;
        
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
        //dibuja vista izquierda
        gl.viewport(0, 0, leftWidth, height);
        gl.scissor(0, 0, leftWidth, height);
             
        var projectionMatrix = M4.perspective(fov, leftWidth/height, zNear, zFar);

        let viewMatrix = leftCamera.getMatrix();
        var lightPos = M4.multiplyVector(viewMatrix, lightPosition);
        diffuseUniforms.u_light_position = lightPos;
              
        leftFigure.draw(gl, viewMatrix, projectionMatrix, diffuseUniforms);    
        //leftWireframe.drawWireframe(gl, viewMatrix, projectionMatrix);  
            
        //dibuja vista derecha
        gl.viewport(leftWidth, 0, rightWidth, height);
        gl.scissor(leftWidth, 0, rightWidth, height);
        
        viewMatrix = rightCamera.getMatrix();
        lightPos = M4.multiplyVector(viewMatrix, lightPosition);
        diffuseUniforms.u_light_position = lightPos;
        
        rightFigure.draw(gl, viewMatrix, projectionMatrix, diffuseUniforms);    
        //rightWireframe.drawWireframe(gl, viewMatrix, projectionMatrix);  
    }
}