/**
 * Vectores 2D.
 * Definición de vectores 2D y sus operaciones.
 * @author Melissa Méndez Servín.
 */
export default class V2{
    constructor(x, y){
        this.x = x;
        this.y = y;
    }
    scale(s){
        return new V2(this.x * s, this.y * s);
    }

    movePoints(t1,t2){
        return new V2(this.x + t1, this.y + t2);
    }
    
    add(u){
        return new V2(this.x + u.x, this.y + u.y);
    }

    sub(u){
        return new V2(this.x - u.x, this.y - u.y);
    }
    unit(){
        var d = Math.sqrt(this.x*this.x + this.y*this.y);
        return this.scale(1/d);
    }
    distance(u){
        return Math.sqrt((u.x-this.x)**2 + (u.y-this.y)**2);
    }
    length(){
        return Math.sqrt(this.x * this.x + this.y*this.y);
    }
    squareModule(){
        return this.x * this.x + this.y*this.y;
    }
    normalize(){
        let module = 1/this.length();
        return this.scale(module);
    }
    dotProduct(v){
        return (this.x * v.x ) + (this.y * v.y);
    }
    multiply2DM(m){
        var x = m[0] * this.x +  m[2] * this.y;
        var y = m[1] * this.x +  m[3] * this.y;
        return new V2(x, y);
    }
    /**
     * Proyeccuón del vector u (this) sobre el vector v 
     * recibido.
     * @param {*} v vector sobre el cual se proyectará
     */
    projection(v){
        var dotProduct = this.dotProduct(v);
        var wLength = dotProduct/(v.squareModule());
        return v.scale(wLength);
    }
}