/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JPopupMenuRepaintWorkaround
extends JPopupMenu {
    private Component target;

    public JPopupMenuRepaintWorkaround(Component component) {
        this.target = component;
        this.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                JPopupMenuRepaintWorkaround.this.waitValidRepaint();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                JPopupMenuRepaintWorkaround.this.waitValidRepaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                JPopupMenuRepaintWorkaround.this.waitValidRepaint();
            }
        });
    }

    public void waitValidRepaint() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                Window window = SwingUtilities.getWindowAncestor(JPopupMenuRepaintWorkaround.this.target);
                if (window instanceof JFrame) {
                    JFrame jFrame = (JFrame)window;
                    Container container = jFrame.getContentPane();
                    container.invalidate();
                    container.validate();
                    container.repaint();
                }
            }
        });
        thread.setPriority(10);
        thread.start();
    }
}

