/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.Electron;
import edu.colorado.phet.circuitconstructionkit.model.ElectronSet;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;

public class ConstantDensityPropagator
implements ModelElement {
    public static double FIRE_CURRENT = 10.0;
    private ElectronSet particleSet;
    private Circuit circuit;
    private double speedScale = 0.33333333333333337;
    private double MIN_CURRENT = Math.pow(10.0, -10.0);
    private double MAX_STEP = CCKModel.ELECTRON_DX * 0.43;
    private int numEqualize = 2;
    private double scale;
    private SmoothData smoothData = new SmoothData(30);
    private double timeScalingPercentValue;
    private String percent = "100";
    private DecimalFormat decimalFormat = new DecimalFormat("##");
    private ArrayList listeners = new ArrayList();
    static double highestSoFar = 0.0;
    static int cap = 0;

    public ConstantDensityPropagator(ElectronSet electronSet, Circuit circuit) {
        this.particleSet = electronSet;
        this.circuit = circuit;
    }

    public double getTimeScalingPercentValue() {
        return this.timeScalingPercentValue;
    }

    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void stepInTime(double d) {
        int n;
        cap = 0;
        double d2 = this.getMaxCurrent();
        double d3 = d2 * this.speedScale;
        double d4 = d3 * d;
        this.scale = d4 >= this.MAX_STEP ? this.MAX_STEP / d4 : 1.0;
        this.smoothData.addData(this.scale * 100.0);
        this.timeScalingPercentValue = this.smoothData.getAverage();
        this.percent = this.decimalFormat.format(this.timeScalingPercentValue);
        if (this.percent.equals("0")) {
            this.percent = "1";
        }
        this.notifyListeners();
        if (this.timeScalingPercentValue < 1.0) {
            // empty if block
        }
        for (n = 0; n < this.particleSet.numParticles(); ++n) {
            Electron electron = this.particleSet.particleAt(n);
            this.propagate(electron, d);
        }
        for (n = 0; n < this.numEqualize; ++n) {
            this.equalize(d);
        }
        if (cap != 0) {
            System.out.println("cap = " + cap);
        }
    }

    public String getPercentString() {
        return this.percent;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.timeScaleChanged();
        }
    }

    private double getMaxCurrent() {
        double d = 0.0;
        for (int i = 0; i < this.circuit.numBranches(); ++i) {
            double d2 = this.circuit.branchAt(i).getCurrent();
            d = Math.max(d, Math.abs(d2));
        }
        return d;
    }

    private void equalize(double d) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n = 0; n < this.particleSet.numParticles(); ++n) {
            arrayList.add(n);
        }
        Collections.shuffle(arrayList);
        for (n = 0; n < this.particleSet.numParticles(); ++n) {
            this.equalize(this.particleSet.particleAt((Integer)arrayList.get(n)), d);
        }
    }

    private void equalize(Electron electron, double d) {
        double d2;
        Electron electron2 = this.particleSet.getUpperNeighborInBranch(electron);
        Electron electron3 = this.particleSet.getLowerNeighborInBranch(electron);
        if (electron2 == null || electron3 == null) {
            return;
        }
        double d3 = electron2.getDistAlongWire() - electron3.getDistAlongWire();
        double d4 = electron.getDistAlongWire();
        double d5 = d2 = electron3.getDistAlongWire() + d3 / 2.0;
        double d6 = Math.abs(d5 - d4);
        double d7 = d5 - d4;
        boolean bl = d7 > 0.0 && electron.getBranch().getCurrent() > 0.0;
        double d8 = 33.333333333333336;
        double d9 = 0.055 / (double)this.numEqualize * d8;
        if (!bl) {
            d9 = 0.01 / (double)this.numEqualize * d8;
        }
        double d10 = Math.abs(d9 * d);
        if (d6 > highestSoFar) {
            highestSoFar = d6;
        }
        if (d6 > d10) {
            if (d5 < d4) {
                d5 = d4 - d10;
            } else if (d5 > d4) {
                d5 = d4 + d10;
            }
        }
        if (d5 >= 0.0 && d5 <= electron.getBranch().getLength()) {
            electron.setDistAlongWire(d5);
        }
    }

    private void propagate(Electron electron, double d) {
        double d2 = electron.getDistAlongWire();
        if (Double.isNaN(d2)) {
            return;
        }
        double d3 = electron.getBranch().getCurrent();
        if (d3 == 0.0 || Math.abs(d3) < this.MIN_CURRENT) {
            return;
        }
        double d4 = d3 * this.speedScale;
        double d5 = d4 * d;
        double d6 = d2 + (d5 *= this.scale);
        Branch branch = electron.getBranch();
        if (branch.containsScalarLocation(d6)) {
            electron.setDistAlongWire(d6);
        } else {
            double d7 = 0.0;
            boolean bl = false;
            if (d6 < 0.0) {
                d7 = -d6;
                bl = true;
            } else {
                d7 = Math.abs(branch.getLength() - d6);
                bl = false;
            }
            if (Double.isNaN(d7)) {
                throw new RuntimeException("Overshoot is NaN");
            }
            if (d7 < 0.0) {
                throw new RuntimeException("Overshoot is <0");
            }
            CircuitLocation[] circuitLocationArray = this.getLocations(electron, d, d7, bl);
            if (circuitLocationArray.length == 0) {
                return;
            }
            CircuitLocation circuitLocation = this.chooseDestinationBranch(circuitLocationArray);
            electron.setLocation(circuitLocation.getBranch(), Math.abs(circuitLocation.getX()));
        }
    }

    private CircuitLocation chooseDestinationBranch(CircuitLocation[] circuitLocationArray) {
        ValueMap valueMap = new ValueMap();
        for (int i = 0; i < circuitLocationArray.length; ++i) {
            CircuitLocation circuitLocation = circuitLocationArray[i];
            valueMap.put(circuitLocation, this.getDensity(circuitLocation));
        }
        return (CircuitLocation)valueMap.argMin();
    }

    private double getDensity(CircuitLocation circuitLocation) {
        Branch branch = circuitLocation.getBranch();
        return this.particleSet.getDensity(branch);
    }

    private CircuitLocation[] getLocations(Electron electron, double d, double d2, boolean bl) {
        Branch branch = electron.getBranch();
        Junction junction = null;
        junction = bl ? branch.getStartJunction() : branch.getEndJunction();
        Branch[] branchArray = this.circuit.getAdjacentBranches(junction);
        ArrayList<CircuitLocation> arrayList = new ArrayList<CircuitLocation>();
        for (int i = 0; i < branchArray.length; ++i) {
            CircuitLocation circuitLocation;
            double d3;
            Branch branch2 = branchArray[i];
            double d4 = branch2.getCurrent();
            if (d4 > FIRE_CURRENT) {
                d4 = FIRE_CURRENT;
            } else if (d4 < -FIRE_CURRENT) {
                d4 = -FIRE_CURRENT;
            }
            if (d4 > 0.0 && branch2.getStartJunction() == junction) {
                d3 = d2;
                if (d3 > branch2.getLength()) {
                    d3 = branch2.getLength();
                } else if (d3 < 0.0) {
                    d3 = 0.0;
                }
                circuitLocation = new CircuitLocation(branch2, d3);
                arrayList.add(circuitLocation);
                continue;
            }
            if (!(d4 < 0.0) || branch2.getEndJunction() != junction) continue;
            d3 = branch2.getLength() - d2;
            if (d3 > branch2.getLength()) {
                d3 = branch2.getLength();
            } else if (d3 < 0.0) {
                d3 = 0.0;
            }
            circuitLocation = new CircuitLocation(branch2, d3);
            arrayList.add(circuitLocation);
        }
        return arrayList.toArray(new CircuitLocation[0]);
    }

    class CircuitLocation {
        Branch branch;
        double x;

        public CircuitLocation(Branch branch, double d) {
            if (!branch.containsScalarLocation(d)) {
                throw new RuntimeException("No such location in branch length=" + branch.getLength() + ", x=" + d);
            }
            this.branch = branch;
            this.x = d;
        }

        public Branch getBranch() {
            return this.branch;
        }

        public double getX() {
            return this.x;
        }
    }

    public static interface Listener {
        public void timeScaleChanged();
    }

    static class SmoothData {
        private ArrayList data;
        private int windowSize;

        public SmoothData(int n) {
            this.data = new ArrayList(n);
            this.windowSize = n;
        }

        public int numDataPoints() {
            return this.data.size();
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public void addData(double d) {
            this.data.add(new Double(d));
            while (this.numDataPoints() > this.getWindowSize()) {
                this.data.remove(0);
            }
        }

        public double getAverage() {
            double d = 0.0;
            for (int i = 0; i < this.data.size(); ++i) {
                Double d2 = (Double)this.data.get(i);
                d += d2.doubleValue();
            }
            return d / (double)this.data.size();
        }
    }

    class ValueMap {
        Hashtable hashtable = new Hashtable();

        public void put(Object object, double d) {
            this.hashtable.put(object, new Double(d));
        }

        public double get(Object object) {
            Double d = (Double)this.hashtable.get(object);
            return d;
        }

        public Object argMin() {
            ArrayList arrayList = new ArrayList(this.hashtable.keySet());
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    double d = ValueMap.this.get(object);
                    double d2 = ValueMap.this.get(object2);
                    return Double.compare(d, d2);
                }
            });
            return arrayList.get(0);
        }
    }
}

