/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.chart;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class StripChartJFCNode
extends PNode {
    private XYSeries series;
    private JFreeChart jFreeChart;
    private JFreeChartNode jFreeChartNode;
    private boolean enabled = true;
    private double timeRange = 5.0;

    public StripChartJFCNode(int n, int n2, String string, String string2) {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        this.series = new XYSeries((Comparable)((Object)"Time Series"));
        xYSeriesCollection.addSeries(this.series);
        this.jFreeChart = StripChartJFCNode.createChart(xYSeriesCollection, string, string2);
        this.jFreeChart.setBorderVisible(true);
        this.jFreeChart.setBorderStroke(new BasicStroke(5.0f));
        this.jFreeChartNode = new JFreeChartNode(this.jFreeChart);
        this.addChild(this.jFreeChartNode);
        this.jFreeChartNode.setBounds(0.0, 0.0, n, n2);
        this.jFreeChart.setBorderPaint(new GradientPaint(0.0f, 0.0f, new Color(200, 200, 200, 255), (float)this.jFreeChartNode.getFullBounds().getWidth(), (float)this.jFreeChartNode.getFullBounds().getHeight(), Color.darkGray));
        try {
            this.jFreeChart.setBackgroundImage(ImageLoader.loadBufferedImage("circuit-construction-kit/images/wood.jpg"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static JFreeChart createChart(XYDataset xYDataset, String string, String string2) {
        JFreeChart jFreeChart = ChartFactory.createScatterPlot("", string, string2, xYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.getRangeAxis().setAutoRange(false);
        xYPlot.getRangeAxis().setRange(-3.0, 3.0);
        xYPlot.getDomainAxis().setRange(0.0, 100.0);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer(true, false);
        xYLineAndShapeRenderer.setStroke(new BasicStroke(2.0f, 0, 0, 1.0f));
        xYLineAndShapeRenderer.setPaint(Color.blue);
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        return jFreeChart;
    }

    public Range getVerticalRange() {
        return this.jFreeChart.getXYPlot().getRangeAxis().getRange();
    }

    public void setVerticalRange(double d, double d2) {
        this.jFreeChart.getXYPlot().getRangeAxis().setRange(d, d2);
    }

    public void setDomainRange(double d, double d2) {
        this.jFreeChart.getXYPlot().getDomainAxis().setRange(d, d2);
    }

    public void addValue(double d, double d2) {
        if (Double.isNaN(d2)) {
            d2 = Double.NaN;
        }
        if (this.enabled) {
            this.series.add(d, d2);
            Range range = this.jFreeChart.getXYPlot().getDomainAxis().getRange();
            Range range2 = new Range(this.getHighestTime() - this.timeRange, this.getHighestTime());
            if (!range.equals(range2)) {
                this.jFreeChart.getXYPlot().getDomainAxis().setRange(range2);
            }
            while (this.shouldRemove1stPoint()) {
                this.series.remove(0);
            }
        }
    }

    private boolean shouldRemove1stPoint() {
        return this.getHighestTime() - this.getLowestTime() > this.timeRange;
    }

    private double getHighestTime() {
        return this.series.getX(this.series.getItemCount() - 1).doubleValue();
    }

    private double getLowestTime() {
        return this.series.getX(0).doubleValue();
    }

    public XYPlot getXYPlot() {
        return this.jFreeChart.getXYPlot();
    }
}

