/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.BranchNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKPopupMenuFactory;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CircuitInteractionModel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.DynamicPopupMenuHandler;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public abstract class ComponentNode
extends BranchNode {
    private CCKModel model;
    private CircuitComponent circuitComponent;
    private CCKModule module;
    private CircuitInteractionModel circuitInteractionModel;
    private PPath highlightNode;
    private JComponent parent;
    private SimpleObserver componentObserver = new SimpleObserver(){

        public void update() {
            ComponentNode.this.update();
        }
    };

    public ComponentNode(final CCKModel cCKModel, final CircuitComponent circuitComponent, JComponent jComponent, CCKModule cCKModule) {
        this.model = cCKModel;
        this.circuitComponent = circuitComponent;
        this.module = cCKModule;
        this.circuitInteractionModel = new CircuitInteractionModel(cCKModel);
        this.highlightNode = new PPath();
        this.highlightNode.setStrokePaint(Color.yellow);
        this.highlightNode.setStroke(new BasicStroke(3.0f));
        this.addChild(this.highlightNode);
        circuitComponent.addObserver(this.componentObserver);
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new PBasicInputEventHandler(){
            public boolean dragging = false;

            public void mouseDragged(PInputEvent pInputEvent) {
                if (pInputEvent.isLeftMouseButton()) {
                    this.dragging = true;
                    ComponentNode.this.circuitInteractionModel.translate(circuitComponent, pInputEvent.getPositionRelativeTo(ComponentNode.this.getParent()));
                }
            }

            public void mouseReleased(PInputEvent pInputEvent) {
                if (pInputEvent.isLeftMouseButton() && this.dragging) {
                    ComponentNode.this.circuitInteractionModel.dropBranch(circuitComponent);
                    this.dragging = false;
                }
            }

            public void mousePressed(PInputEvent pInputEvent) {
                if (pInputEvent.isControlDown()) {
                    circuitComponent.setSelected(!circuitComponent.isSelected());
                } else {
                    cCKModel.getCircuit().setSelection(circuitComponent);
                }
            }
        });
        this.addInputEventListener(new DynamicPopupMenuHandler(jComponent, new DynamicPopupMenuHandler.JPopupMenuFactory(){

            public JPopupMenu createPopupMenu() {
                return ComponentNode.this.createPopupMenu();
            }
        }));
        this.parent = jComponent;
    }

    public void delete() {
        this.circuitComponent.removeObserver(this.componentObserver);
    }

    protected JPopupMenu createPopupMenu() {
        return new CCKPopupMenuFactory(this.module).createPopupMenu(this.circuitComponent);
    }

    protected void update() {
        this.highlightNode.setVisible(this.circuitComponent.isSelected());
    }

    public Branch getBranch() {
        return this.circuitComponent;
    }

    public PPath getHighlightNode() {
        return this.highlightNode;
    }

    public CircuitComponent getCircuitComponent() {
        return this.circuitComponent;
    }

    public CCKModel getCCKModel() {
        return this.model;
    }
}

