/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Capacitor;
import edu.colorado.phet.circuitconstructionkit.model.components.Inductor;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowHTMLNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public class ReadoutNode
extends PhetPNode {
    private ShadowHTMLNode htmlNode;
    protected CCKModule module;
    protected Branch branch;
    private JComponent panel;
    protected DecimalFormat formatter;
    private PPath linePNode;
    static Font font = new PhetFont(1, 16);

    public ReadoutNode(CCKModule cCKModule, Branch branch, JComponent jComponent, DecimalFormat decimalFormat) {
        this.module = cCKModule;
        this.branch = branch;
        this.panel = jComponent;
        this.formatter = decimalFormat;
        this.htmlNode = new ShadowHTMLNode("");
        this.htmlNode.setFont(font);
        Color color = Color.black;
        Color color2 = Color.yellow;
        this.htmlNode.setPaint(color);
        this.htmlNode.setShadowColor(color2);
        this.htmlNode.setShadowOffset(1.0, 1.0);
        this.htmlNode.setScale(0.0125);
        branch.addObserver(new SimpleObserver(){

            public void update() {
                ReadoutNode.this.recompute();
            }
        });
        this.addChild(this.htmlNode);
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.linePNode = new PhetPPath(new BasicStroke(0.016666668f, 1, 1, 0.0125f, new float[]{0.083333336f, 0.083333336f}, 0.0f), (Paint)Color.blue);
        this.addChild(this.linePNode);
        this.recompute();
    }

    public void recompute() {
        this.htmlNode.setHtml(this.toHTML(this.getText()));
        Shape shape = this.branch.getShape();
        Point2D.Double double_ = new Point2D.Double(shape.getBounds2D().getCenterX() - this.htmlNode.getFullBounds().getWidth() / 2.0, shape.getBounds2D().getY() - this.htmlNode.getFullBounds().getHeight());
        if (this.isVertical()) {
            double_ = new Point2D.Double(shape.getBounds2D().getMaxX(), shape.getBounds2D().getCenterY() - this.htmlNode.getFullBounds().getHeight() / 2.0);
        }
        this.htmlNode.setOffset(double_);
        Point2D.Double double_2 = new Point2D.Double(shape.getBounds2D().getCenterX(), shape.getBounds2D().getCenterY());
        double d = double_.distance(double_2);
        this.linePNode.setVisible(d > 1.0);
        Point2D.Double double_3 = new Point2D.Double(this.htmlNode.getFullBounds().getCenterX(), this.htmlNode.getFullBounds().getMaxY());
        if (this.isVertical()) {
            double_3 = new Point2D.Double(this.htmlNode.getFullBounds().getX(), this.htmlNode.getFullBounds().getCenterY());
        }
        this.linePNode.setPathTo(new Line2D.Double(double_3, double_2));
    }

    private boolean isVertical() {
        double d;
        for (d = this.branch.getAngle(); d < 0.0; d += Math.PI * 2) {
        }
        while (d > Math.PI * 2) {
            d -= Math.PI * 2;
        }
        boolean bl = d > 0.7853981633974483 && d < 2.356194490192345;
        boolean bl2 = d > 3.9269908169872414 && d < 5.497787143782138;
        return bl || bl2;
    }

    private String toHTML(String[] stringArray) {
        String string = "<html>";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i >= stringArray.length - 1) continue;
            string = string + "<br>";
        }
        return string + "</html>";
    }

    protected String[] getText() {
        Object object;
        if (this.branch instanceof Battery) {
            return this.getBatteryText();
        }
        if (this.branch instanceof Capacitor) {
            return this.getCapacitorText((Capacitor)this.branch);
        }
        if (this.branch instanceof Inductor) {
            return this.getInductorText((Inductor)this.branch);
        }
        double d = this.branch.getResistance();
        if (this.branch instanceof Switch && !((Switch)(object = (Switch)this.branch)).isClosed()) {
            d = Double.POSITIVE_INFINITY;
        }
        object = this.formatter.format(d);
        String string = this.formatter.format(Math.abs(this.branch.getCurrent()));
        String string2 = this.formatter.format(Math.abs(this.branch.getVoltageDrop()));
        object = this.abs((String)object);
        string = this.abs(string);
        string2 = this.abs(string2);
        String string3 = (String)object + " " + CCKResources.getString("ReadoutGraphic.Ohms");
        return new String[]{string3};
    }

    private String[] getInductorText(Inductor inductor) {
        return new String[]{this.formatter.format(inductor.getInductance()) + " " + CCKResources.getString("ReadoutGraphic.Henries")};
    }

    private String[] getCapacitorText(Capacitor capacitor) {
        return new String[]{this.formatter.format(capacitor.getCapacitance()) + " " + CCKResources.getString("ReadoutGraphic.Farads")};
    }

    private String[] getBatteryText() {
        boolean bl = true;
        double d = Math.abs(this.branch.getVoltageDrop());
        String string = this.formatter.format(d);
        String string2 = "" + string + " " + CCKResources.getString("ReadoutGraphic.Volts");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        if (bl) {
            String string3 = this.formatter.format(this.branch.getResistance()) + " " + CCKResources.getString("ReadoutGraphic.Ohms");
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[0]);
    }

    protected String abs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".0");
        if (stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("-")) {
            return string.substring(1);
        }
        return string;
    }

    public Branch getBranch() {
        return this.branch;
    }

    public void update() {
        this.setVisible(this.branch.isEditing());
    }
}

