/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import java.awt.Color;

public class SolderNode
extends PhetPNode {
    private Circuit circuit;
    private Junction junction;
    private Color color;
    private PhetPPath path;

    public SolderNode(Circuit circuit, Junction junction, Color color) {
        this.circuit = circuit;
        this.junction = junction;
        this.color = color;
        this.path = new PhetPPath(color);
        this.addChild(this.path);
        this.update();
        junction.addObserver(new SimpleObserver(){

            public void update() {
                SolderNode.this.update();
            }
        });
        circuit.addCircuitListener(new CircuitListenerAdapter(){

            public void junctionsConnected(Junction junction, Junction junction2, Junction junction3) {
                SolderNode.this.update();
            }

            public void branchRemoved(Branch branch) {
                SolderNode.this.update();
            }

            public void junctionsSplit(Junction junction, Junction[] junctionArray) {
                SolderNode.this.update();
            }

            public void junctionRemoved(Junction junction) {
                SolderNode.this.update();
            }
        });
    }

    private void update() {
        this.setVisible(this.circuit.getNeighbors(this.junction).length > 1);
        this.path.setPathTo(this.junction.createCircle(0.25920000000000004));
    }
}

