/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.Connection;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.analysis.CircuitSolutionListener;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class VoltmeterModel {
    private boolean visible = false;
    private UnitModel unitModel;
    private ArrayList listeners = new ArrayList();
    private LeadModel redLead;
    private LeadModel blackLead;
    private double voltage = Double.NaN;
    private CCKModel model;
    private Circuit circuit;

    public VoltmeterModel(CCKModel cCKModel, Circuit circuit) {
        this.model = cCKModel;
        this.circuit = circuit;
        this.redLead = new LeadModel(circuit, new Point2D.Double(-0.2, 0.0), 0.39269908169872414);
        this.blackLead = new LeadModel(circuit, new Point2D.Double(1.224, 0.0), -0.39269908169872414);
        LeadModel.Listener listener = new LeadModel.Listener(){

            public void leadModelChanged() {
                VoltmeterModel.this.updateVoltage();
            }
        };
        this.redLead.addListener(listener);
        this.blackLead.addListener(listener);
        this.unitModel = new UnitModel();
        this.bodyDragged(3.0, 3.0);
        circuit.addCircuitListener(new CircuitListenerAdapter(){

            public void branchesMoved(Branch[] branchArray) {
                VoltmeterModel.this.testUpdate();
            }

            public void junctionsMoved() {
                VoltmeterModel.this.testUpdate();
            }

            public void junctionsConnected(Junction junction, Junction junction2, Junction junction3) {
                VoltmeterModel.this.testUpdate();
            }
        });
        cCKModel.getCircuitSolver().addSolutionListener(new CircuitSolutionListener(){

            public void circuitSolverFinished() {
                VoltmeterModel.this.testUpdate();
            }
        });
    }

    private void testUpdate() {
        if (this.visible) {
            this.updateVoltage();
        }
    }

    private void updateVoltage() {
        double d = this.circuit.getVoltage(this.redLead.getTipShape(), this.blackLead.getTipShape());
        if (d != this.voltage) {
            this.voltage = d;
            this.notifyListeners();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
        this.updateVoltage();
        this.notifyListeners();
    }

    public LeadModel getBlackLeadModel() {
        return this.blackLead;
    }

    public LeadModel getRedLeadModel() {
        return this.redLead;
    }

    public UnitModel getUnitModel() {
        return this.unitModel;
    }

    public void bodyDragged(double d, double d2) {
        this.unitModel.bodyDragged(d, d2);
        if (this.getLeadsShouldTranslateWithBody()) {
            this.redLead.translate(d, d2);
            this.blackLead.translate(d, d2);
        }
    }

    private boolean getLeadsShouldTranslateWithBody() {
        Connection connection = this.redLead.getConnection();
        Connection connection2 = this.blackLead.getConnection();
        return connection == null && connection2 == null;
    }

    public double getVoltage() {
        return this.voltage;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.voltmeterChanged();
        }
    }

    public static class LeadModel {
        private Point2D.Double tipLocation;
        private ArrayList listeners = new ArrayList();
        private double angle;
        private double tipWidth = 0.034999999999999996;
        private double tipHeight = 0.28125;
        private Circuit circuit;

        public LeadModel(Circuit circuit, Point2D.Double double_, double d) {
            this.tipLocation = new Point2D.Double(double_.getX(), double_.getY());
            this.angle = d;
            this.circuit = circuit;
        }

        public void translate(double d, double d2) {
            this.tipLocation.x += d;
            this.tipLocation.y += d2;
            this.notifyListeners();
        }

        public Point2D getTipLocation() {
            return new Point2D.Double(this.tipLocation.x, this.tipLocation.y);
        }

        public Shape getTipShape() {
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.tipLocation.x - this.tipWidth / 2.0, this.tipLocation.y, this.tipWidth, this.tipHeight);
            return AffineTransform.getRotateInstance(this.angle, this.tipLocation.x, this.tipLocation.y).createTransformedShape(double_);
        }

        public double getAngle() {
            return this.angle;
        }

        public Connection getConnection() {
            return this.circuit.getConnection(this.getTipShape());
        }

        public void addListener(Listener listener) {
            this.listeners.add(listener);
        }

        public void notifyListeners() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.leadModelChanged();
            }
        }

        static interface Listener {
            public void leadModelChanged();
        }
    }

    public static interface Listener {
        public void voltmeterChanged();
    }

    public static class UnitModel {
        private Point2D.Double location = new Point2D.Double();
        private ArrayList listeners = new ArrayList();

        public Point2D getLocation() {
            return new Point2D.Double(this.location.x, this.location.y);
        }

        public void bodyDragged(double d, double d2) {
            this.location.x += d;
            this.location.y += d2;
            this.notifyListeners();
        }

        public void addListener(Listener listener) {
            this.listeners.add(listener);
        }

        public void notifyListeners() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.unitModelChanged();
            }
        }

        static interface Listener {
            public void unitModelChanged();
        }
    }
}

