/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKStrings;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;

public class WarningMessageNode
extends PNode {
    private ShadowPText shadowPText;
    private Circuit circuit;

    public WarningMessageNode(Circuit circuit) {
        this.circuit = circuit;
        this.shadowPText = new ShadowPText(CCKStrings.getString("WarningMessages.PossibleError"));
        this.shadowPText.setFont(new PhetFont(1, 16));
        this.shadowPText.setTextPaint(Color.yellow);
        this.shadowPText.setShadowColor(Color.black);
        this.shadowPText.setShadowOffset(1.0, 1.0);
        this.addChild(this.shadowPText);
        circuit.addCircuitListener(new CircuitListenerAdapter(){

            public void editingChanged() {
                WarningMessageNode.this.updateVisibility();
            }

            public void junctionsConnected(Junction junction, Junction junction2, Junction junction3) {
                WarningMessageNode.this.updateVisibility();
            }

            public void branchRemoved(Branch branch) {
                WarningMessageNode.this.updateVisibility();
            }
        });
        this.updateVisibility();
    }

    private void updateVisibility() {
        this.setVisible(this.circuit.hasProblematicConfiguration());
    }
}

