/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.LineSegment;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class SchematicResistorNode
extends ComponentNode {
    private CircuitComponent component;
    private double wireThickness;
    private ImmutableVector2D eastDir;
    private ImmutableVector2D northDir;
    private Point2D anoPoint;
    private Point2D catPoint;
    private Area mouseArea;
    private SimpleObserver simpleObserver;
    private PhetPPath resistorPPath = new PhetPPath(Color.black);

    public SchematicResistorNode(CCKModel cCKModel, Resistor resistor, JComponent jComponent, CCKModule cCKModule) {
        super(cCKModel, resistor, jComponent, cCKModule);
        this.component = resistor;
        this.wireThickness = 0.12;
        this.simpleObserver = new SimpleObserver(){

            public void update() {
                SchematicResistorNode.this.changed();
            }
        };
        resistor.addObserver(this.simpleObserver);
        this.changed();
        this.addChild(this.resistorPPath);
        this.setVisible(true);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    private ImmutableVector2D getVector(double d, double d2) {
        ImmutableVector2D immutableVector2D = this.eastDir.getScaledInstance(d);
        ImmutableVector2D immutableVector2D2 = this.northDir.getScaledInstance(d2);
        return immutableVector2D.getAddedInstance(immutableVector2D2);
    }

    protected void changed() {
        super.update();
        Point2D.Double double_ = this.component.getStartJunction().getPosition();
        Point2D.Double double_2 = this.component.getEndJunction().getPosition();
        ImmutableVector2D immutableVector2D = new ImmutableVector2D(double_, double_2);
        double d = 0.1;
        double d2 = 1.0 - d;
        this.catPoint = immutableVector2D.getScaledInstance(d).getDestination(double_);
        this.anoPoint = immutableVector2D.getScaledInstance(d2).getDestination(double_);
        this.eastDir = immutableVector2D.getInstanceOfMagnitude(1.0);
        this.northDir = this.eastDir.getNormalVector();
        double d3 = this.wireThickness;
        double d4 = d3 / 2.5;
        double d5 = this.catPoint.distance(this.anoPoint);
        int n = 3;
        double d6 = d3 * 1.2;
        int n2 = (n - 1) * 4 + 2;
        double d7 = (double)n2 / 4.0;
        double d8 = d5 / d7;
        double d9 = d8 / 4.0;
        double d10 = d8 / 2.0;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(this.catPoint);
        doubleGeneralPath.lineToRelative(this.getVector(d9, d6));
        for (int i = 0; i < n - 1; ++i) {
            doubleGeneralPath.lineToRelative(this.getVector(d10, -2.0 * d6));
            doubleGeneralPath.lineToRelative(this.getVector(d10, 2.0 * d6));
        }
        doubleGeneralPath.lineToRelative(this.getVector(d9, -d6));
        GeneralPath generalPath = doubleGeneralPath.getGeneralPath();
        BasicStroke basicStroke = new BasicStroke((float)d4);
        Shape shape = basicStroke.createStrokedShape(generalPath);
        Area area = new Area(shape);
        area.add(new Area(LineSegment.getSegment(double_, this.catPoint, d3)));
        area.add(new Area(LineSegment.getSegment(this.anoPoint, double_2, d3)));
        this.mouseArea = new Area(area);
        this.mouseArea.add(new Area(LineSegment.getSegment(double_, double_2, d3)));
        this.resistorPPath.setPathTo(area);
        BasicStroke basicStroke2 = new BasicStroke(0.1f);
        this.getHighlightNode().setStroke(basicStroke2);
        this.getHighlightNode().setPathTo(area);
    }

    public void delete() {
        super.delete();
        this.component.removeObserver(this.simpleObserver);
    }

    public Branch getBranch() {
        return this.component;
    }
}

