/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.TimeControlListener;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TimeControlPanel
extends JPanel {
    public static final NumberFormat DEFAULT_TIME_FORMAT = new DecimalFormat("0");
    private JButton playPauseButton;
    private JButton stepButton;
    private JButton restartButton;
    private ImageIcon playIcon;
    private ImageIcon pauseIcon;
    private String playString;
    private String pauseString;
    private JTextField timeTextField;
    private JLabel unitsLabel;
    private JPanel buttonPanel;
    private JPanel timeDisplayPanel;
    private NumberFormat timeFormat;
    private double time = 0.0;
    private boolean paused = false;
    private JPanel userPanel;
    private ArrayList listeners = new ArrayList();

    public TimeControlPanel() {
        this.timeFormat = DEFAULT_TIME_FORMAT;
        this.playString = PhetCommonResources.getInstance().getLocalizedString("Common.ClockControlPanel.Play");
        this.pauseString = PhetCommonResources.getInstance().getLocalizedString("Common.ClockControlPanel.Pause");
        BufferedImage bufferedImage = PhetCommonResources.getInstance().getImage("clock/Play24.gif");
        BufferedImage bufferedImage2 = PhetCommonResources.getInstance().getImage("clock/Pause24.gif");
        this.playIcon = new ImageIcon(bufferedImage);
        this.pauseIcon = new ImageIcon(bufferedImage2);
        this.playPauseButton = new JButton();
        Dimension dimension = SwingUtils.getMaxDimension(this.playPauseButton, this.playString, this.playIcon, this.pauseString, this.pauseIcon);
        this.playPauseButton.setPreferredSize(dimension);
        String string = PhetCommonResources.getInstance().getLocalizedString("Common.ClockControlPanel.Step");
        BufferedImage bufferedImage3 = PhetCommonResources.getInstance().getImage("clock/StepForward24.gif");
        ImageIcon imageIcon = new ImageIcon(bufferedImage3);
        this.stepButton = new JButton(string, imageIcon);
        String string2 = PhetCommonResources.getInstance().getLocalizedString("Common.ClockControlPanel.Restart");
        BufferedImage bufferedImage4 = PhetCommonResources.getInstance().getImage("clock/Rewind24.gif");
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage4);
        this.restartButton = new JButton(string2, imageIcon2);
        this.buttonPanel = new JPanel(new FlowLayout(1));
        this.buttonPanel.add(this.restartButton);
        this.buttonPanel.add(this.playPauseButton);
        this.buttonPanel.add(this.stepButton);
        this.timeTextField = new JTextField();
        this.timeTextField.setColumns(8);
        this.timeTextField.setEditable(false);
        this.timeTextField.setHorizontalAlignment(4);
        this.unitsLabel = new JLabel();
        this.timeDisplayPanel = new JPanel(new FlowLayout(1));
        this.timeDisplayPanel.add(this.timeTextField);
        this.timeDisplayPanel.add(this.unitsLabel);
        this.userPanel = new JPanel(new FlowLayout(1));
        this.restartButton.setVisible(false);
        this.timeTextField.setVisible(false);
        this.unitsLabel.setVisible(false);
        SwingUtils.fixButtonOpacity(this.playPauseButton);
        SwingUtils.fixButtonOpacity(this.stepButton);
        this.setLayout(new FlowLayout(1));
        this.add(this.timeDisplayPanel);
        this.add(this.userPanel);
        this.add(this.buttonPanel);
        this.playPauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeControlPanel.this.paused = !TimeControlPanel.this.paused;
                TimeControlPanel.this.updateButtons();
                if (TimeControlPanel.this.paused) {
                    TimeControlPanel.this.notifyPausePressed();
                } else {
                    TimeControlPanel.this.notifyPlayPressed();
                }
            }
        });
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeControlPanel.this.notifyStepPressed();
            }
        });
        this.restartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TimeControlPanel.this.notifyRestartPressed();
            }
        });
        this.updateButtons();
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
        this.updateButtons();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateButtons();
    }

    public void setTimeDisplay(double d) {
        if (d != this.time) {
            this.time = d;
            this.updateTimeDisplay();
        }
    }

    private void updateTimeDisplay() {
        if (this.timeTextField.isVisible()) {
            String string = this.timeFormat.format(this.time);
            this.timeTextField.setText(string);
        }
    }

    private void updateButtons() {
        this.playPauseButton.setText(this.paused ? this.playString : this.pauseString);
        this.playPauseButton.setIcon(this.paused ? this.playIcon : this.pauseIcon);
        this.playPauseButton.setEnabled(this.isEnabled());
        this.stepButton.setEnabled(this.isEnabled() && this.paused);
        this.restartButton.setEnabled(this.isEnabled());
    }

    public void addTimeControlListener(TimeControlListener timeControlListener) {
        this.listeners.add(timeControlListener);
    }

    private void notifyStepPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).stepPressed();
        }
    }

    private void notifyPlayPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).playPressed();
        }
    }

    private void notifyPausePressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).pausePressed();
        }
    }

    private void notifyRestartPressed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TimeControlListener)this.listeners.get(i)).restartPressed();
        }
    }
}

