/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.help;

import edu.colorado.phet.common.piccolophet.help.HelpBalloon;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class MotionHelpBalloon
extends HelpBalloon {
    private PCanvas canvas;
    private boolean started;

    public MotionHelpBalloon(PCanvas pCanvas, String string) {
        super(pCanvas, string, HelpBalloon.TOP_LEFT, 100.0, 0.0);
        this.setBalloonVisible(false);
        this.setArrowVisible(false);
        this.setEnabled(true);
        this.canvas = pCanvas;
        this.started = false;
    }

    public PActivity animateTo(PNode pNode) {
        return this.animateTo(pNode, 3000L);
    }

    public PActivity animateTo(final PNode pNode, long l) {
        if (!this.started) {
            if (this.getRoot() == null) {
                throw new IllegalStateException("node has no root");
            }
            Point2D point2D = this.mapLocation(pNode, this.canvas);
            final PTransformActivity pTransformActivity = this.animateToPositionScaleRotation(point2D.getX(), point2D.getY(), 1.0, 0.0, l);
            pNode.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    PAffineTransform pAffineTransform = MotionHelpBalloon.this.getTransform();
                    Point2D point2D = MotionHelpBalloon.this.mapLocation(pNode, MotionHelpBalloon.this.canvas);
                    pAffineTransform.setOffset(point2D.getX(), point2D.getY());
                    pAffineTransform.setScale(1.0);
                    pAffineTransform.setRotation(0.0);
                    double[] dArray = new double[6];
                    pAffineTransform.getMatrix(dArray);
                    pTransformActivity.setDestinationTransform(dArray);
                }
            });
            return pTransformActivity;
        }
        return null;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.setPickable(bl);
        this.setChildrenPickable(bl);
    }
}

