/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.io.Serializable;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class ChartEntity
implements Serializable,
Cloneable,
PublicCloneable {
    private transient Shape area;
    private String toolTipText;
    private String urlText;

    public ChartEntity(Shape area) {
        this(area, null);
    }

    public ChartEntity(Shape area, String toolTipText) {
        this(area, toolTipText, null);
    }

    public ChartEntity(Shape area, String toolTipText, String urlText) {
        if (area == null) {
            throw new IllegalArgumentException("Null 'area' argument.");
        }
        this.area = area;
        this.toolTipText = toolTipText;
        this.urlText = urlText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public void setURLText(String text) {
        this.urlText = text;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ChartEntity: ");
        buf.append("tooltip = ");
        buf.append(this.toolTipText);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ChartEntity) {
            ChartEntity that = (ChartEntity)obj;
            if (!this.area.equals(that.area)) {
                return false;
            }
            if (!ObjectUtilities.equal(this.toolTipText, that.toolTipText)) {
                return false;
            }
            return ObjectUtilities.equal(this.urlText, that.urlText);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

