/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike;

import edu.colorado.phet.circuitconstructionkit.model.CurrentVoltListener;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Filament;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.TotalBulbComponentNode;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;

public class FilamentNode
extends PhetPNode {
    private Filament filament;
    private TotalBulbComponentNode totalBulbComponentNode;
    private Stroke stroke = new BasicStroke(0.1f);
    private CurrentVoltListener currentListener = new CurrentVoltListener(){

        public void currentOrVoltageChanged(Branch branch) {
            FilamentNode.this.update();
        }
    };
    private SimpleObserver filamentObserver = new SimpleObserver(){

        public void update() {
            FilamentNode.this.update();
        }
    };

    public FilamentNode(Filament filament, TotalBulbComponentNode totalBulbComponentNode) {
        this.filament = filament;
        this.totalBulbComponentNode = totalBulbComponentNode;
        totalBulbComponentNode.getBulb().addCurrentVoltListener(this.currentListener);
        filament.addObserver(this.filamentObserver);
        this.update();
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    protected void paint(PPaintContext pPaintContext) {
        Shape shape = pPaintContext.getGraphics().getClip();
        Area area = new Area(shape);
        area.subtract(new Area(this.totalBulbComponentNode.getClipShape(this)));
        pPaintContext.pushClip(area);
    }

    protected void paintAfterChildren(PPaintContext pPaintContext) {
        pPaintContext.popClip(null);
    }

    private void update() {
        double d = this.totalBulbComponentNode.getBulb().getIntensity();
        PhetPPath phetPPath = new PhetPPath(this.filament.getPath(), this.stroke, (Paint)new Color((float)d, (float)(d * 0.4), (float)(d * 0.5)));
        this.removeAllChildren();
        this.addChild(phetPPath);
    }

    public void delete() {
        this.totalBulbComponentNode.getBulb().removeCurrentVoltListener(this.currentListener);
        this.filament.removeObserver(this.filamentObserver);
    }
}

