/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.preferences;

import edu.colorado.phet.common.phetcommon.preferences.PhetPreferences;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.updates.ManualUpdatesManager;
import edu.colorado.phet.common.phetcommon.util.DeploymentScenario;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class UpdatesPreferencesPanel
extends JPanel {
    private static final String UPDATES_ENABLED = PhetCommonResources.getString("Common.updates.automaticallyCheck");
    private static final String CHECK_FOR_SIM_UPDATES = PhetCommonResources.getString("Common.updates.checkForSimUpdate");
    private static final String CHECK_FOR_INSTALLER_UPDATE = PhetCommonResources.getString("Common.updates.checkForInstallerUpdate");
    private final PhetPreferences preferences;
    private final JCheckBox updatesEnabledCheckBox;

    public UpdatesPreferencesPanel(PhetPreferences phetPreferences) {
        this.preferences = phetPreferences;
        this.updatesEnabledCheckBox = new JCheckBox(UPDATES_ENABLED, phetPreferences.isUpdatesEnabled());
        JButton jButton = new JButton(CHECK_FOR_SIM_UPDATES);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualUpdatesManager.getInstance().checkForSimUpdates();
            }
        });
        JButton jButton2 = new JButton(CHECK_FOR_INSTALLER_UPDATE);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualUpdatesManager.getInstance().checkForInstallerUpdates();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.add(Box.createRigidArea(new Dimension(50, 20)), gridBagConstraints);
        this.add((Component)this.updatesEnabledCheckBox, gridBagConstraints);
        this.add(Box.createRigidArea(new Dimension(50, 10)), gridBagConstraints);
        this.add((Component)jButton, gridBagConstraints);
        if (DeploymentScenario.getInstance() == DeploymentScenario.PHET_INSTALLATION) {
            this.add((Component)jButton2, gridBagConstraints);
        }
    }

    public void save() {
        this.preferences.setUpdatesEnabled(this.updatesEnabledCheckBox.isSelected());
    }
}

