/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.components;

import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.DynamicBranch;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;

public class ACVoltageSource
extends Battery
implements DynamicBranch {
    private double time = 0.0;
    private double amplitude = 10.0;
    private double frequency = 0.5;

    public ACVoltageSource(CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2, double d, double d2, double d3, boolean bl) {
        super(circuitChangeListener, junction, junction2, d, d2, d3, bl);
    }

    public double getVoltageDrop() {
        double d = Math.sin(this.time * this.frequency * Math.PI * 2.0);
        return this.amplitude * d;
    }

    public void stepInTime(double d) {
        this.time += d;
    }

    public void resetDynamics() {
        this.time = 0.0;
    }

    public void setAmplitude(double d) {
        this.amplitude = d;
    }

    public void setFrequency(double d) {
        this.frequency = d;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public double getFrequency() {
        return this.frequency;
    }
}

