/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.chart;

import edu.colorado.phet.circuitconstructionkit.view.chart.AbstractFloatingChart;
import edu.colorado.phet.circuitconstructionkit.view.chart.CrosshairConnection;
import edu.colorado.phet.circuitconstructionkit.view.chart.CrosshairNode;
import edu.colorado.phet.circuitconstructionkit.view.chart.StripChartJFCNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;

public abstract class SingleTerminalFloatingChart
extends AbstractFloatingChart {
    private AbstractFloatingChart.ValueReader valueReader;
    private CrosshairNode crosshairNode;
    private PhetPCanvas pSwingCanvas;

    public SingleTerminalFloatingChart(PhetPCanvas phetPCanvas, String string, AbstractFloatingChart.ValueReader valueReader, IClock iClock) {
        super(string, iClock);
        this.pSwingCanvas = phetPCanvas;
        this.valueReader = valueReader;
        this.crosshairNode = new CrosshairNode(this, 10, 15);
        CrosshairConnection crosshairConnection = new CrosshairConnection(this, this.crosshairNode);
        this.addChild(crosshairConnection);
        this.addChild(this.crosshairNode);
        StripChartJFCNode stripChartJFCNode = super.getStripChartJFCNode();
        stripChartJFCNode.setOffset(-stripChartJFCNode.getFullBounds().getWidth() - this.crosshairNode.getFullBounds().getWidth() / 2.0, -stripChartJFCNode.getFullBounds().getHeight() / 2.0);
        double d = this.crosshairNode.getFullBounds().getWidth() * 1.25;
        this.crosshairNode.translate(d, 0.0);
        stripChartJFCNode.addInputEventListener(new PairDragHandler());
    }

    public void setValueReader(AbstractFloatingChart.ValueReader valueReader) {
        this.valueReader = valueReader;
    }

    public void update() {
        super.update();
        if (this.crosshairNode != null && this.valueReader != null) {
            Point2D point2D = this.getLocation();
            double d = this.valueReader.getValue(point2D.getX(), point2D.getY());
            double d2 = super.getClock().getSimulationTime();
            this.getStripChartJFCNode().addValue(d2, d);
        }
    }

    protected abstract Point2D getLocation();

    public CrosshairNode getCrosshairGraphic() {
        return this.crosshairNode;
    }

    class PairDragHandler
    extends PDragEventHandler {
        PairDragHandler() {
        }

        protected void drag(PInputEvent pInputEvent) {
            super.drag(pInputEvent);
            if (SingleTerminalFloatingChart.this.crosshairNode.isAttached()) {
                SingleTerminalFloatingChart.this.crosshairNode.translate(pInputEvent.getCanvasDelta().getWidth(), pInputEvent.getCanvasDelta().getHeight());
            }
        }
    }

    public static class Piccolo
    extends SingleTerminalFloatingChart {
        private CCKSimulationPanel cckSimulationPanel;

        public Piccolo(PhetPCanvas phetPCanvas, String string, AbstractFloatingChart.ValueReader valueReader, IClock iClock, CCKSimulationPanel cCKSimulationPanel) {
            super(phetPCanvas, string, valueReader, iClock);
            this.cckSimulationPanel = cCKSimulationPanel;
        }

        protected Point2D getLocation() {
            Point2D point2D = this.getCrosshairGraphic().getGlobalTranslation();
            this.cckSimulationPanel.getCircuitNode().globalToLocal(point2D);
            return point2D;
        }
    }
}

