/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.model.BranchSet;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;

public class CircuitInteractionModel {
    private CCKModel model;
    private Circuit circuit;
    private JunctionInteractionModel junctionInteractionModel;
    private BranchInteractionModel branchInteractionModel;

    public CircuitInteractionModel(CCKModel cCKModel) {
        this.circuit = cCKModel.getCircuit();
        this.model = cCKModel;
        this.junctionInteractionModel = new JunctionInteractionModel();
        this.branchInteractionModel = new BranchInteractionModel();
    }

    public void dragJunction(Junction junction, Point2D point2D) {
        this.junctionInteractionModel.dragJunction(junction, point2D);
    }

    public void dropJunction(Junction junction) {
        this.junctionInteractionModel.dropJunction(junction);
    }

    public void translate(Wire wire, Point2D point2D) {
        this.branchInteractionModel.translate(wire, point2D);
    }

    public void dropBranch(Wire wire) {
        this.branchInteractionModel.dropBranch(wire);
    }

    public void translate(Branch branch, Point2D point2D) {
        this.branchInteractionModel.translate(branch, point2D);
    }

    public void dropBranch(Branch branch) {
        this.branchInteractionModel.dropBranch(branch);
    }

    private Circuit getCircuit() {
        return this.circuit;
    }

    class BranchInteractionModel {
        private ImmutableVector2D toStart;
        private ImmutableVector2D toEnd;
        private boolean draggingBranch = false;
        private Circuit.DragMatch branchDragMatch;
        private Circuit.DragMatch startMatch;
        private Circuit.DragMatch endMatch;

        BranchInteractionModel() {
        }

        public void translate(Branch branch, Point2D point2D) {
            if (!this.draggingBranch) {
                this.draggingBranch = true;
                this.toStart = new ImmutableVector2D(point2D, branch.getStartJunction().getPosition());
                this.toEnd = new ImmutableVector2D(point2D, branch.getEndJunction().getPosition());
            } else if (branch instanceof CircuitComponent) {
                this.translateCircuitComponent((CircuitComponent)branch, point2D);
            } else if (branch instanceof Wire) {
                this.translateWire((Wire)branch, point2D);
            } else {
                throw new RuntimeException("Unknown wire type: " + branch.getClass());
            }
        }

        private void translateWire(Wire wire, Point2D point2D) {
            Point2D.Double double_ = this.toStart.getDestination(point2D);
            Point2D.Double double_2 = this.toEnd.getDestination(point2D);
            Branch[] branchArray = CircuitInteractionModel.this.circuit.getStrongConnections(wire.getStartJunction());
            Branch[] branchArray2 = CircuitInteractionModel.this.circuit.getStrongConnections(wire.getEndJunction());
            Vector2D vector2D = new Vector2D(wire.getStartJunction().getPosition(), double_);
            Vector2D vector2D2 = new Vector2D(wire.getEndJunction().getPosition(), double_2);
            Junction[] junctionArray = this.getSources(branchArray, wire.getStartJunction());
            Junction[] junctionArray2 = this.getSources(branchArray2, wire.getEndJunction());
            this.startMatch = CircuitInteractionModel.this.getCircuit().getBestDragMatch(junctionArray, vector2D);
            this.endMatch = CircuitInteractionModel.this.getCircuit().getBestDragMatch(junctionArray2, vector2D2);
            if (this.endMatch != null && this.startMatch != null && this.endMatch.getTarget() == this.startMatch.getTarget()) {
                this.endMatch = null;
            }
            if (this.endMatch != null && this.startMatch != null && this.wouldCauseOverlap(wire, this.startMatch, this.endMatch)) {
                this.endMatch = null;
            }
            if (this.startMatch != null && this.endMatch != null) {
                for (int i = 0; i < CircuitInteractionModel.this.circuit.numBranches(); ++i) {
                    Branch branch = CircuitInteractionModel.this.circuit.branchAt(i);
                    if (!branch.hasJunction(this.startMatch.getTarget()) || !wire.hasJunction(this.endMatch.getTarget())) continue;
                    this.startMatch = null;
                    this.endMatch = null;
                    break;
                }
            }
            this.apply(branchArray, vector2D, wire.getStartJunction(), this.startMatch);
            this.apply(branchArray2, vector2D2, wire.getEndJunction(), this.endMatch);
        }

        private boolean wouldCauseOverlap(Wire wire, Circuit.DragMatch dragMatch, Circuit.DragMatch dragMatch2) {
            Junction[] junctionArray = CircuitInteractionModel.this.circuit.getNeighbors(dragMatch.getTarget());
            ArrayList<Junction> arrayList = new ArrayList<Junction>();
            arrayList.addAll(Arrays.asList(junctionArray));
            arrayList.remove(wire.getStartJunction());
            arrayList.remove(wire.getEndJunction());
            return arrayList.contains(dragMatch2.getTarget());
        }

        private void translateCircuitComponent(CircuitComponent circuitComponent, Point2D point2D) {
            Point2D.Double double_;
            if (!this.draggingBranch) {
                this.draggingBranch = true;
                double_ = circuitComponent.getStartJunction().getPosition();
                this.toStart = new ImmutableVector2D(point2D, double_);
            }
            double_ = this.toStart.getDestination(point2D);
            Vector2D vector2D = new Vector2D(circuitComponent.getStartJunction().getPosition(), double_);
            Branch[] branchArray = CircuitInteractionModel.this.circuit.getStrongConnections(circuitComponent.getStartJunction());
            this.branchDragMatch = CircuitInteractionModel.this.getCircuit().getBestDragMatch(branchArray, vector2D);
            BranchSet branchSet = new BranchSet(CircuitInteractionModel.this.circuit, branchArray);
            branchSet.translate(this.branchDragMatch == null ? vector2D : this.branchDragMatch.getVector());
        }

        public void dropBranch(Branch branch) {
            if (branch instanceof CircuitComponent) {
                if (this.branchDragMatch != null) {
                    CircuitInteractionModel.this.getCircuit().collapseJunctions(this.branchDragMatch.getSource(), this.branchDragMatch.getTarget());
                }
                this.branchDragMatch = null;
                this.draggingBranch = false;
            } else {
                this.draggingBranch = false;
                if (this.startMatch != null) {
                    CircuitInteractionModel.this.getCircuit().collapseJunctions(this.startMatch.getSource(), this.startMatch.getTarget());
                }
                if (this.endMatch != null) {
                    CircuitInteractionModel.this.getCircuit().collapseJunctions(this.endMatch.getSource(), this.endMatch.getTarget());
                }
            }
            if (branch != null) {
                CircuitInteractionModel.this.circuit.bumpAway(branch.getStartJunction());
                CircuitInteractionModel.this.circuit.bumpAway(branch.getEndJunction());
            }
        }

        private Junction[] getSources(Branch[] branchArray, Junction junction) {
            ArrayList<Junction> arrayList = new ArrayList<Junction>(Arrays.asList(Circuit.getJunctions(branchArray)));
            if (!arrayList.contains(junction)) {
                arrayList.add(junction);
            }
            return arrayList.toArray(new Junction[0]);
        }

        private void apply(Branch[] branchArray, Vector2D vector2D, Junction junction, Circuit.DragMatch dragMatch) {
            if (dragMatch == null) {
                BranchSet branchSet = new BranchSet(CircuitInteractionModel.this.circuit, branchArray);
                branchSet.addJunction(junction);
                branchSet.translate(vector2D);
            } else {
                BranchSet branchSet = new BranchSet(CircuitInteractionModel.this.circuit, branchArray);
                Vector2D vector2D2 = dragMatch.getVector();
                branchSet.addJunction(junction);
                branchSet.translate(vector2D2);
            }
        }
    }

    class JunctionInteractionModel {
        private Circuit.DragMatch junctionDragMatch;

        JunctionInteractionModel() {
        }

        private CircuitComponent getSoleComponent(Junction junction) {
            if (CircuitInteractionModel.this.circuit.getAdjacentBranches(junction).length == 1 && CircuitInteractionModel.this.circuit.getAdjacentBranches(junction)[0] instanceof CircuitComponent) {
                return (CircuitComponent)CircuitInteractionModel.this.circuit.getAdjacentBranches(junction)[0];
            }
            return null;
        }

        public void dragJunction(Junction junction, Point2D point2D) {
            this.drag(junction, point2D);
        }

        private void drag(Junction junction, Point2D point2D) {
            if (this.getSoleComponent(junction) != null) {
                this.rotateComponent(junction, point2D);
            } else {
                this.translateJunction(junction, point2D);
            }
        }

        private void translateJunction(Junction junction, Point2D point2D) {
            Branch[] branchArray = CircuitInteractionModel.this.circuit.getStrongConnections(junction);
            Junction[] junctionArray = Circuit.getJunctions(branchArray);
            ArrayList<Junction> arrayList = new ArrayList<Junction>(Arrays.asList(junctionArray));
            if (!arrayList.contains(junction)) {
                arrayList.add(junction);
            }
            Junction[] junctionArray2 = arrayList.toArray(new Junction[0]);
            Vector2D vector2D = new Vector2D(junction.getPosition(), point2D);
            this.junctionDragMatch = CircuitInteractionModel.this.getCircuit().getBestDragMatch(junctionArray2, vector2D);
            if (this.junctionDragMatch != null) {
                vector2D = this.junctionDragMatch.getVector();
            }
            BranchSet branchSet = new BranchSet(CircuitInteractionModel.this.circuit, branchArray);
            branchSet.addJunction(junction);
            branchSet.translate(vector2D);
            Branch[] branchArray2 = CircuitInteractionModel.this.circuit.getConnectedSubgraph(junction);
            CircuitInteractionModel.this.model.layoutElectrons(branchArray2);
        }

        private void rotateComponent(Junction junction, Point2D point2D) {
            CircuitComponent circuitComponent = this.getSoleComponent(junction);
            Junction junction2 = circuitComponent.opposite(junction);
            ImmutableVector2D immutableVector2D = new ImmutableVector2D(junction2.getPosition(), point2D);
            immutableVector2D = immutableVector2D.getInstanceOfMagnitude(circuitComponent.getComponentLength());
            Point2D.Double double_ = immutableVector2D.getDestination(junction2.getPosition());
            junction.setPosition(((Point2D)double_).getX(), ((Point2D)double_).getY());
        }

        public void dropJunction(Junction junction) {
            if (this.junctionDragMatch != null) {
                CircuitInteractionModel.this.getCircuit().collapseJunctions(junction, this.junctionDragMatch.getTarget());
            }
            this.junctionDragMatch = null;
            CircuitInteractionModel.this.circuit.bumpAway(junction);
        }
    }
}

