/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.schematic;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.LineSegment;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public class SchematicOscillateNode
extends ComponentNode {
    private CircuitComponent component;
    private double wireThickness;
    private ImmutableVector2D eastDir;
    private ImmutableVector2D northDir;
    private Point2D anoPoint;
    private Point2D catPoint;
    private SimpleObserver simpleObserver;
    private PhetPPath path;

    public SchematicOscillateNode(CCKModel cCKModel, CircuitComponent circuitComponent, JComponent jComponent, CCKModule cCKModule, double d) {
        super(cCKModel, circuitComponent, jComponent, cCKModule);
        this.component = circuitComponent;
        this.wireThickness = d;
        this.simpleObserver = new SimpleObserver(){

            public void update() {
                SchematicOscillateNode.this.changed();
            }
        };
        this.path = new PhetPPath(Color.black);
        this.addChild(this.path);
        this.component.addObserver(this.simpleObserver);
        this.changed();
        this.setVisible(true);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    private ImmutableVector2D getVector(double d, double d2) {
        ImmutableVector2D immutableVector2D = this.eastDir.getScaledInstance(d);
        ImmutableVector2D immutableVector2D2 = this.northDir.getScaledInstance(d2);
        return immutableVector2D.getAddedInstance(immutableVector2D2);
    }

    protected void changed() {
        super.update();
        Point2D.Double double_ = this.component.getStartJunction().getPosition();
        Point2D.Double double_2 = this.component.getEndJunction().getPosition();
        ImmutableVector2D immutableVector2D = new ImmutableVector2D(double_, double_2);
        double d = 0.1;
        double d2 = 1.0 - d;
        this.catPoint = immutableVector2D.getScaledInstance(d).getDestination(double_);
        this.anoPoint = immutableVector2D.getScaledInstance(d2).getDestination(double_);
        this.eastDir = immutableVector2D.getInstanceOfMagnitude(1.0);
        this.northDir = this.eastDir.getNormalVector();
        double d3 = this.getViewThickness();
        double d4 = d3 / 2.5;
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        doubleGeneralPath.moveTo(this.catPoint);
        double d5 = this.catPoint.distance(this.anoPoint);
        double d6 = 0.016666666666666666;
        double d7 = this.getFracDistToStartSine();
        double d8 = d5 - 2.0 * d5 * d7;
        double d9 = Math.PI * 2 / d8;
        for (double d10 = 0.0; d10 < d5; d10 += d6) {
            double d11 = this.getY(d10, d5, d7, d9);
            ImmutableVector2D immutableVector2D2 = this.getVector(d10, d11);
            Point2D.Double double_3 = immutableVector2D2.getDestination(this.catPoint);
            if (d10 > d5 * d7 && d10 < d5 - d5 * d7) {
                doubleGeneralPath.lineTo(double_3);
                continue;
            }
            doubleGeneralPath.moveTo(double_3);
        }
        GeneralPath generalPath = doubleGeneralPath.getGeneralPath();
        BasicStroke basicStroke = new BasicStroke((float)d4, 0, 0, 1.0f);
        Shape shape = basicStroke.createStrokedShape(generalPath);
        Area area = new Area(shape);
        area.add(new Area(LineSegment.getSegment(double_, this.catPoint, d3)));
        area.add(new Area(LineSegment.getSegment(this.anoPoint, double_2, d3)));
        this.path.setPathTo(area);
        this.getHighlightNode().setStroke(new BasicStroke(0.1f, 0, 0, 1.0f));
        this.getHighlightNode().setPathTo(area);
    }

    protected double getFracDistToStartSine() {
        return 0.15;
    }

    protected double getViewThickness() {
        return this.wireThickness;
    }

    protected double getY(double d, double d2, double d3, double d4) {
        return -10.0 * Math.sin((d - d2 * d3) * d4) * 0.016666666666666666;
    }

    public CircuitComponent getCircuitComponent() {
        return this.component;
    }

    public void delete() {
        super.delete();
        this.component.removeObserver(this.simpleObserver);
    }

    protected Point2D getAnoPoint() {
        return this.anoPoint;
    }

    protected Point2D getCatPoint() {
        return this.catPoint;
    }
}

