# natan-js - Maths Game for Kids

<img src="images/screenshot.png" alt="Screenshot of the game" title="Screenshot" align="right">
A web based app I made for my nephew. Intended to teach young kids basic arithmetic (addition and subtraction) with positive numbers.
  
## Features
* Addition :heavy_plus_sign:
* Subtraction :heavy_minus_sign:
* No negative numbers
* Input using touchscreen/mouse :computer_mouse:
* Tablet support (especially ipad) using custom CSS
* HTML 5
* 100% vanilla Javascript (ES6)

## How It Works
* The game generates 10 random maths problems one-by-one.
* It randomizes the numbers with a a number range of 1-11 for the **first number** and 1-30 for the **second number**

Children do not know the validity of basic mathematical proofs that adults take for granted. Also, negative-numbers can be quite tricky (too abstract) for young kids. Considering this the game is consciously designed to never generate problems where the answer is less than 0.


```
a + b == b + a

```
*(This proof is self-evident for adults. But not for young children)*


## Usage
1. Click Start-button to Start the game
1. Enter digits by clicking on the buttons
1. Submit your answer using the 'DONE'-button
1. Game ends after 10 rounds

## Development
The code is written using OOP (Object Oriented Programming) and uses the MVC-pattern (Model View Controller).


## :penguin: Attribution
The image of birthday Tux is courtesy of [Pixabay](https://pixabay.com/images/id-161107/)

## Licence
Made in 2019. MIT Licence
