/*
 * Decompiled with CFR 0.152.
 */
package com.mja.poly;

import com.mja.math3D.LinearTransformation;
import com.mja.math3D.R3;
import com.mja.parser.Node;
import com.mja.poly.Face;
import com.mja.poly.viewModel;
import com.mja.poly.viewR3;
import com.mja.text.MathText;
import com.mja.util.BasicStr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import java.util.Vector;

public class Surface {
    private Face[] face;
    private Face[] ordface;
    private Face[] drawface;
    private R3[] vertex;
    private R3[] vertex0;
    private viewR3 view;

    public Surface(Face[] faceArray) {
        int n;
        Vector<R3> vector = new Vector<R3>();
        for (int i = 0; i < faceArray.length; ++i) {
            for (n = 0; n < faceArray[i].P.length; ++n) {
                if (vector.contains(faceArray[i].P[n])) continue;
                boolean bl = true;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    R3 r3 = (R3)enumeration.nextElement();
                    if (!(r3.Subtract(faceArray[i].P[n]).Norm() <= 1.0E-8)) continue;
                    bl = false;
                    faceArray[i].P[n] = r3;
                    break;
                }
                if (!bl) continue;
                vector.addElement(faceArray[i].P[n]);
            }
        }
        this.vertex = new R3[vector.size()];
        this.vertex0 = new R3[this.vertex.length];
        Enumeration enumeration = vector.elements();
        for (n = 0; n < this.vertex.length; ++n) {
            this.vertex[n] = (R3)enumeration.nextElement();
            this.vertex0[n] = this.vertex[n].cloneR3();
        }
        this.face = faceArray;
        this.ordface = new Face[this.face.length];
        for (n = 0; n < this.face.length; ++n) {
            this.ordface[n] = this.face[n];
        }
    }

    private Surface() {
    }

    public Surface cloneSurface() {
        Face[] faceArray = new Face[this.face.length];
        for (int i = 0; i < faceArray.length; ++i) {
            faceArray[i] = this.face[i].cloneFace();
        }
        Surface surface = new Surface(faceArray);
        return surface;
    }

    public void setSValue(double d) {
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].setSValue(d);
        }
    }

    public void setSNode(Node node) {
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].setSNode(node);
        }
    }

    void setMathText(MathText mathText) {
        if (mathText != null) {
            for (int i = 0; i < this.face.length; ++i) {
                this.face[i].setMathText(mathText);
            }
        }
    }

    public int countFaces() {
        return this.face.length;
    }

    public int countVertices() {
        return this.vertex.length;
    }

    public void fixAsInitialPosition() {
        for (int i = 0; i < this.vertex.length; ++i) {
            this.vertex0[i].x = this.vertex[i].x;
            this.vertex0[i].y = this.vertex[i].y;
            this.vertex0[i].z = this.vertex[i].z;
        }
    }

    public void resetInitialPosition() {
        for (int i = 0; i < this.vertex0.length; ++i) {
            this.vertex[i].x = this.vertex0[i].x;
            this.vertex[i].y = this.vertex0[i].y;
            this.vertex[i].z = this.vertex0[i].z;
        }
    }

    public void apply(LinearTransformation linearTransformation) {
        int n;
        for (n = 0; n < this.vertex.length; ++n) {
            linearTransformation.Apply(this.vertex[n]);
        }
        for (n = 0; n < this.face.length; ++n) {
            this.face[n].calculateUnitNormal();
        }
    }

    public void updateView(viewR3 viewR32) {
        this.view = viewR32;
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].updateView(viewR32);
        }
    }

    public void setViewModel(int n) {
        viewModel viewModel2 = new viewModel();
        viewModel2.setModel(n);
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].setViewModel(viewModel2);
        }
    }

    public void setUserLightPos(int n, int n2, int n3) {
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].getViewModel().setUserLightPos(n, n2, n3);
        }
    }

    public void setUserIllumination(double d, double d2) {
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].getViewModel().setUserIllumination(d, d2);
        }
    }

    void setEdgeColor(Color color) {
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].setEdgeColor(color);
        }
    }

    void setFrontColor(Color color) {
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].setFrontColor(color);
        }
    }

    void setBackColor(Color color) {
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].setBackColor(color);
        }
    }

    public void setDrawEdges(boolean bl) {
        for (int i = 0; i < this.face.length; ++i) {
            this.face[i].setDrawEdges(bl);
        }
    }

    public static Surface add(Surface surface, Surface surface2) {
        if (surface == null) {
            return surface2;
        }
        if (surface2 == null) {
            return surface;
        }
        return Surface.add(surface, surface2.face);
    }

    public static Surface add(Surface surface, Face[] faceArray) {
        if (surface == null) {
            return new Surface(faceArray);
        }
        if (faceArray == null) {
            return surface;
        }
        Face[] faceArray2 = new Face[surface.face.length + faceArray.length];
        int n = 0;
        while (n < surface.face.length) {
            faceArray2[n] = surface.face[n++];
        }
        int n2 = 0;
        while (n2 < faceArray.length) {
            faceArray2[n++] = faceArray[n2++];
        }
        return new Surface(faceArray2);
    }

    public Surface split(Surface surface) {
        for (int i = 0; i < this.face.length; ++i) {
            int n;
            Face[] faceArray;
            Vector<Face> vector = new Vector<Face>();
            for (int j = 0; j < surface.face.length; ++j) {
                faceArray = this.face[i].split(surface.face[j]);
                for (n = 0; n < faceArray.length; ++n) {
                    vector.addElement(faceArray[n]);
                }
            }
            Face[] faceArray2 = new Face[vector.size()];
            faceArray = vector.elements();
            for (n = 0; n < faceArray2.length; ++n) {
                faceArray2[n] = (Face)faceArray.nextElement();
            }
            surface = new Surface(faceArray2);
        }
        return surface;
    }

    public String toTeX(Component component, boolean bl, double d, int n, int n2, double d2, double d3, String string) {
        String string2 = BasicStr.getTeX_Header(n, n2);
        string2 = string2 + BasicStr.getTeX_BeginDoc(d, n, n2, d2, d3);
        for (int i = 0; i < this.drawface.length; ++i) {
            string2 = string2 + this.drawface[i].toTeX(component, i, 2 * n2 - 10, bl);
        }
        string2 = string2 + string;
        string2 = string2 + "\r\n}\r\n\r\n\\end{pspicture}\r\n\r\n}\r\n\r\n\\end{document}\r\n";
        return string2;
    }

    private void QuickSort() {
        this.QS(0, this.face.length - 1);
    }

    private void QS(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        double d = this.ordface[n].aveDistanceToEye + (this.ordface[n2].aveDistanceToEye - this.ordface[n].aveDistanceToEye) / 2.0;
        boolean bl = false;
        while (!bl) {
            boolean bl2;
            boolean bl3 = d > this.ordface[n3].aveDistanceToEye;
            boolean bl4 = bl3 & (bl2 = this.ordface[n4].aveDistanceToEye > d);
            if (bl4) {
                Face face = this.ordface[n3];
                this.ordface[n3] = this.ordface[n4];
                this.ordface[n4] = face;
            }
            if (bl4 || !bl3) {
                ++n3;
            }
            if (bl4 || !bl2) {
                --n4;
            }
            boolean bl5 = bl = n4 <= n3;
            if (bl && n < n4 && n4 != n2) {
                this.QS(n, n4);
            }
            if (!bl || n3 >= n2 || n3 == n) continue;
            this.QS(n3, n2);
        }
    }

    public void sortAndPaint(Container container, Graphics2D graphics2D) {
        this.QuickSort();
        for (int i = 0; i < this.face.length; ++i) {
            this.ordface[i].draw(container, graphics2D);
        }
    }

    public void painterAlgorithm(Container container, Graphics2D graphics2D) {
        this.setDrawingOrder();
        for (int i = 0; i < this.face.length; ++i) {
            this.drawface[i].draw(container, graphics2D);
        }
    }

    private void setDrawingOrder() {
        double d;
        int n;
        this.QuickSort();
        Vector vector = new Vector();
        for (n = 0; n < this.ordface.length; ++n) {
            this.ordface[n].drawn = false;
        }
        this.drawface = new Face[this.ordface.length];
        n = 0;
        int n2 = this.ordface.length;
        double d2 = d = 0.001;
        while (true) {
            int n3;
            int n4 = n2;
            boolean bl = false;
            for (n3 = 0; n3 < this.ordface.length; ++n3) {
                if (this.ordface[n3].drawn) continue;
                boolean bl2 = true;
                for (int i = 0; i < this.ordface.length; ++i) {
                    if (i == n3 || this.ordface[i].drawn || !this.ordface[n3].inFrontOf(vector, this.ordface[i], d2)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                --n2;
                this.drawface[n++] = this.ordface[n3];
                this.ordface[n3].drawn = true;
                bl = true;
            }
            if (n2 == 0) break;
            if (n2 == n4) {
                if (!((d2 *= 10.0) > 0.1)) continue;
                System.out.println("Error in Painter Algorithm");
                for (n3 = 0; n3 < this.ordface.length; ++n3) {
                    if (this.ordface[n3].drawn) continue;
                    this.drawface[n++] = this.ordface[n3];
                    this.ordface[n3].drawn = true;
                }
                break;
            }
            d2 = d;
        }
    }

    public void rayTrace(Container container, Graphics2D graphics2D, int n, int n2) {
        this.QuickSort();
        this.refine(graphics2D, 0, 0, n, n2, 64);
        for (int i = 0; i < this.ordface.length; ++i) {
            this.ordface[i].drawText(container, graphics2D);
        }
    }

    private void refine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n5 < 4) {
            n5 = 1;
        }
        for (int i = n2; i < n2 + n4; i += n5) {
            for (int j = n; j < n + n3; j += n5) {
                if (!this.touches(j, i, n5) || this.atomPainted(graphics, j, i, n5)) continue;
                this.refine(graphics, j, i, n5, n5, n5 / 2);
            }
        }
    }

    private boolean touches(int n, int n2, int n3) {
        for (int i = this.ordface.length - 1; i >= 0; --i) {
            if (!this.ordface[i].touches(n, n2, n3)) continue;
            return true;
        }
        return false;
    }

    private boolean atomPainted(Graphics graphics, int n, int n2, int n3) {
        double d = Double.MAX_VALUE;
        int n4 = -1;
        if (n3 == 1) {
            for (int i = this.ordface.length - 1; i >= 0; --i) {
                double d2;
                if (!this.ordface[i].contains(n, n2, n3) || !((d2 = this.ordface[i].intersectionToEye(n, n2)) < d)) continue;
                d = d2;
                n4 = i;
            }
        } else {
            double[] dArray = new double[this.ordface.length];
            double[] dArray2 = new double[this.ordface.length];
            boolean[] blArray = new boolean[this.ordface.length];
            for (int i = this.ordface.length - 1; i >= 0; --i) {
                blArray[i] = this.ordface[i].contains(n, n2, n3);
                if (blArray[i]) {
                    if (this.ordface[i].getDrawEdges() && (this.ordface[i].isOnEdge(n, n2) || this.ordface[i].isOnEdge(n + n3 - 1, n2) || this.ordface[i].isOnEdge(n, n2 + n3 - 1) || this.ordface[i].isOnEdge(n + n3 - 1, n2 + n3 - 1))) {
                        return false;
                    }
                    double d3 = this.ordface[i].intersectionToEye(n, n2);
                    double d4 = this.ordface[i].intersectionToEye(n + n3 - 1, n2);
                    double d5 = this.ordface[i].intersectionToEye(n, n2 + n3 - 1);
                    double d6 = this.ordface[i].intersectionToEye(n + n3 - 1, n2 + n3 - 1);
                    dArray[i] = Math.min(d3, Math.min(d4, Math.min(d5, d6)));
                    dArray2[i] = Math.max(d3, Math.max(d4, Math.max(d5, d6)));
                    for (int j = i + 1; j < this.ordface.length; ++j) {
                        if (!blArray[j] || !(dArray[i] <= dArray[j] && dArray[j] <= dArray2[i] || dArray[i] <= dArray2[j] && dArray2[j] <= dArray2[i] || dArray[j] <= dArray[i] && dArray[i] <= dArray2[j]) && (!(dArray[j] <= dArray2[i]) || !(dArray2[i] <= dArray2[j]))) continue;
                        return false;
                    }
                    if (!this.ordface[i].contains(n, n2, n3) || !(d3 < d)) continue;
                    d = d3;
                    n4 = i;
                    continue;
                }
                if (!this.ordface[i].touches(n, n2, n3)) continue;
                return false;
            }
        }
        if (n4 >= 0) {
            graphics.setColor(this.ordface[n4].getColorAt(n, n2, n3 == 1));
            graphics.fillRect(n, n2, n3, n3);
        }
        return true;
    }
}

