/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.descartes.Descartes;
import com.mja.descartes.Space;
import com.mja.lang.translator;
import com.mja.parser.Parser;
import com.mja.text.Formula;
import com.mja.text.RTF;
import com.mja.text.TColors;
import com.mja.text.TNode;
import com.mja.text.Text;
import com.mja.util.TFont;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.URL;

public class TextCanvas
extends Panel
implements MouseListener,
MouseMotionListener {
    public static final String UpdateSelectors = "UpdateSelectors";
    public static final String ActivateFormulaButtons = "ActivateFormulaButtons";
    public static final String ActivateTextButtons = "ActivateTextButtons";
    protected boolean editing;
    protected boolean learnerMode;
    protected boolean inVerticalMotion;
    protected boolean onlyFormula;
    protected boolean hasFocus;
    protected boolean fixed = false;
    protected volatile boolean updating;
    protected volatile Formula mainF;
    protected volatile Formula F;
    protected Text T;
    protected int dec = 2;
    protected int aL = 0;
    protected volatile int mainFIndex;
    protected Applet A;
    protected Frame parent;
    protected translator Tr;
    protected Parser parser;
    protected volatile BufferedImage buffer;
    private Graphics bG;
    private int minH;
    private boolean variableSize;
    private boolean started = false;
    private boolean showholes;
    private volatile boolean updatingScreen = false;
    private int n = 1;
    private boolean painting = false;
    private int mouse_x;
    private int mouse_y;
    public Scrollbar jsb;
    public int containerSize = 480;
    private volatile boolean dragging = false;

    public TextCanvas(Applet applet, Frame frame, translator translator2, Parser parser, TFont tFont, Color color, boolean bl, boolean bl2) {
        this.A = applet;
        this.parent = frame;
        this.Tr = translator2;
        this.parser = parser;
        this.variableSize = bl;
        this.onlyFormula = bl2;
        this.setLayout(null);
        this.setText(new Text(this.parser, tFont, Color.white, color));
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setText(String string, Font font, Color color, Color color2) {
        TFont tFont = new TFont(font);
        this.minH = tFont.getAscent() + tFont.getDescent();
        this.setText(new Text(this.parser, tFont, color, color2));
    }

    public boolean updateTextComponent(Component component, String string) {
        return this.T.updateNodes(component, string);
    }

    public boolean start() {
        if (!this.started) {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.setCursorPos(0);
            if (this.updateSize(true)) {
                this.updateScreen();
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.started = this.buffer != null;
        }
        return this.started;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.T.setTFont(new TFont(font));
    }

    public void setForeground(Color color) {
        this.T.setColors(this.T.getColors().getBackColor(), color);
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        this.T.setColors(color, this.T.getColors().getTextColor());
        super.setBackground(color);
    }

    public void setCursorPos(int n) {
        if (this.F != null) {
            this.F.setCursorPos(Math.min(Math.max(n, this.F.begin()), this.F.end()));
        } else {
            this.T.setCursorPos(Math.min(Math.max(n, this.T.begin()), this.T.end()));
        }
    }

    public void addActionListener(ActionListener actionListener) {
    }

    public boolean onlyFormula() {
        return this.onlyFormula;
    }

    public BufferedImage getBufferedImage() {
        return this.buffer;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setExprDefaults(int n, boolean bl, int n2) {
        this.dec = n;
        this.fixed = bl;
        this.aL = n2;
    }

    public String toRTF(boolean bl) {
        RTF rTF = new RTF(this.T);
        String string = rTF.toRTF(bl);
        return string;
    }

    public Formula getMainFormula() {
        return this.mainF;
    }

    public Formula getFormula() {
        return this.F;
    }

    public void setMainFormula(Formula formula) {
        this.T.TNode(this.mainFIndex).getFI().setFormula(0, formula);
        this.mainF = formula;
        this.F = formula;
    }

    public String getCharAtCursor() {
        String string;
        TNode tNode = null;
        tNode = this.F != null ? this.F.TNode(this.F.firstChar(this.F.getCursorPos())) : this.T.TNode(this.T.firstChar(this.T.getCursorPos()));
        if (tNode.isPureChar() && (string = tNode.getChar()) != null && string.length() >= 1 && string.charAt(0) != '\n' && string.charAt(0) != '\u001a') {
            char c = string.charAt(0);
            return "0x" + Integer.toHexString(c);
        }
        return "";
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public void setMinimumHeight(int n) {
        this.minH = n;
    }

    public int getMinimumHeight() {
        return this.minH;
    }

    public int getCanvasHeight() {
        return 2 + Math.max(this.getTextHeight(), this.getMinimumHeight());
    }

    public int getTextHeight() {
        return this.T.getHeight(this);
    }

    public int getTextWidth() {
        return this.T.getWidth(this);
    }

    public void setText(Text text) {
        this.T = text;
        if (this.onlyFormula) {
            int n = text.firstFormula(text.begin());
            if (n < 0) {
                text.setCursorPos(text.firstChar(text.begin()));
                text.insertFormula(new Formula(this.parser, text.getTFont()));
                n = text.firstFormula(text.begin());
            }
            this.mainFIndex = n;
            text.setCursorPos(this.mainFIndex);
            this.F = this.mainF = text.TNode(this.mainFIndex).getFI().getFormula(0);
        } else {
            this.mainFIndex = -1;
            this.mainF = null;
            this.F = null;
        }
        if (this.getFont() != null) {
            text.setTFont(new TFont(this.getFont()));
        }
        text.setParser(text.parser);
    }

    public Text getText() {
        return this.T;
    }

    public TFont getFirstFont() {
        return this.T.getTFontAtTNode(this.T.firstChar(this.T.begin()));
    }

    public TColors getCursorColors() {
        if (this.F != null) {
            if (this.F.segMarked()) {
                return this.F.getColorsAtTNode(this.F.segMin());
            }
            return this.F.getColorsAtTNode(this.F.getCursorPos());
        }
        if (this.T.segMarked()) {
            return this.T.getColorsAtTNode(this.T.segMin());
        }
        return this.T.getColorsAtTNode(this.T.getCursorPos());
    }

    public TFont getCursorTFont() {
        if (this.F != null) {
            return this.T.getTFontAtTNode(this.mainFIndex);
        }
        if (this.T.segMarked()) {
            return this.T.getTFontAtTNode(this.T.segMin());
        }
        TFont tFont = this.T.getTFontAtTNode(this.T.getCursorPos());
        return tFont;
    }

    public void insertColors(TColors tColors) {
        if (this.F != null) {
            this.F.insertColors(tColors, true);
            this.updateScreenFromTNode(this.mainFIndex);
        } else {
            this.T.insertColors(tColors, true);
            if (this.T.segMarked()) {
                this.T.clean();
                this.updateScreenSegment(this.T.segMin(), this.T.segMax());
            } else {
                this.updateScreenLineAtTNode(this.T.getCursorPos());
            }
        }
        if (this.updateSize()) {
            this.updateScreen();
        }
    }

    public void insertTFont(TFont tFont) {
        if (this.F != null) {
            this.T.markSegment(this.T.getCursorPos(), this.T.getCursorPos() + 1);
            this.T.insertTFont(tFont, true);
            this.T.unmarkSegment();
            this.T.clean();
            this.mainFIndex = this.T.getCursorPos();
            this.updateScreenFromTNode(this.mainFIndex);
        } else {
            this.T.insertTFont(tFont, true);
            if (this.T.segMarked()) {
                this.updateScreenFromTNode(this.T.segMin());
            } else {
                this.updateScreenFromTNode(this.T.getCursorPos());
            }
        }
        if (this.updateSize()) {
            this.updateScreen();
        }
    }

    public void insertFormula(String string) {
        TFont tFont = this.getCursorTFont();
        int n = tFont.getSize();
        TFont tFont2 = new TFont(new Font("Serif", 2, n + 2));
        this.T.insertTFont(tFont2, false);
        Formula formula = new Formula(this.parser, tFont2, this.getCursorColors().getBackColor(), this.getCursorColors().getTextColor());
        formula.insertString(string);
        this.insertFormula(formula);
        this.T.insertTFont(tFont, false);
        if (this.updateSize()) {
            this.updateScreen();
        } else {
            this.updateScreenFromTNode(this.mainFIndex);
        }
    }

    private void insertFormula(Formula formula) {
        if (this.T.segMarked()) {
            this.removeMarkedSegment();
        }
        this.mainFIndex = this.T.getCursorPos();
        this.T.insertFormula(formula);
        formula.setActive(true);
        this.setMainFormula(formula);
    }

    public void insertSpace(int n) {
        Descartes descartes = (Descartes)this.A;
        String string = descartes.scene.getNewSpaceName();
        String string2 = Long.toString(System.currentTimeMillis(), 16);
        String string3 = "id='" + string + "' cID='" + string2 + "'";
        Space space = null;
        switch (n) {
            case 0: {
                string3 = string3 + "tipo='R2' x='0' y='0' ancho='360' alto='240' despl_imagen='arr-izq' fondo='f0f8fa' red='b8c4c8' red10='889498' ejes='405860' texto='no'";
                break;
            }
            case 1: {
                string3 = string3 + "tipo='R3' x='0' y='0' ancho='360' alto='240' escala='64' despl_imagen='arr-izq' fondo='e0ecef' R3='si'";
                break;
            }
            case 2: {
                string3 = string3 + "tipo='TA' x='0' y='0' ancho='360' alto='240' fuente puntos='17' s\u00edmbolo de multiplicaci\u00f3n='punto' ecuaci\u00f3n='4x-8=2x+6'";
                break;
            }
            case 3: {
                string3 = string3 + "tipo='AP' x='0' y='0' ancho='360' alto='240' fuente puntos='17' despl_imagen='arr-izq' fondo='f0f8fa' red='b8c4c8' red10='889498' ejes='405860' ";
            }
        }
        descartes.cfg.addSpace(string3);
        space = descartes.cfg.sc[descartes.cfg.sc.length - 1].makeSpace(descartes);
        if (space != null) {
            space.TextBound = true;
            space.preSize();
            int n2 = this.T.getLineHeightAtTNode(this, this.getCursorPos());
            this.T.insertComponent(space, "Space", string2);
            if (descartes.getEditor() != null) {
                descartes.getEditor().setInfo();
            }
            if (this.updateSize(false)) {
                this.updateScreen();
            } else {
                this.updateScreenLineAtTNode(this.getCursorPos());
                this.updateScreenLineAtTNode(this.getCursorPos());
                int n3 = this.T.getLineHeightAtTNode(this, this.getCursorPos());
                if (n3 > n2) {
                    this.scrollFromTNode(this.getCursorPos(), n2 - n3);
                    int n4 = this.T.nextLine(this.getCursorPos());
                    this.updateScreenLineAtTNode(n4);
                }
            }
            space.updateSpace(true, true);
        }
        this.requestFocus();
    }

    public void insertChar(char c) {
        this.insertText(new Character(c).toString());
    }

    public void insertText(String string) {
        if (this.F != null) {
            if (this.editing) {
                if (this.F.segMarked()) {
                    this.removeMarkedSegment();
                }
                int n = this.T.getLineHeightAtTNode(this, this.mainFIndex);
                this.F.insertText(string);
                if (n != this.T.getLineHeightAtTNode(this, this.mainFIndex)) {
                    this.updateScreenFromTNode(this.mainFIndex);
                } else {
                    this.updateScreenLineAtTNode(this.mainFIndex);
                }
            }
        } else {
            int n;
            if (this.T.segMarked()) {
                this.removeMarkedSegment();
            }
            TNode tNode = this.T.TNode(this.T.getCursorPos());
            int n2 = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
            if (string.length() == 1 && string.charAt(0) > '\u00ff') {
                TFont tFont = this.getCursorTFont();
                n = tFont.getSize();
                TFont tFont2 = new TFont(new Font("Serif", 2, n + 2));
                this.T.insertTFont(tFont2, false);
                this.T.insertText(string);
                this.T.insertTFont(tFont, true);
            } else {
                this.T.insertText(string);
            }
            if (this.updateSize()) {
                this.updateScreen();
            } else {
                int n3 = this.T.getLineHeightAtTNode(this, this.T.getCursorPos() - 1);
                n = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
                if (string.equals("\n")) {
                    this.updateScreenLineAtTNode(this.T.getCursorPos() - 1);
                    this.scrollFromTNode(this.T.getCursorPos(), -Math.min(n3, n));
                } else if (n2 != n3) {
                    this.scrollFromTNode(this.T.getCursorPos(), n2 - n);
                }
                this.updateScreenLineAtTNode(this.T.getCursorPos());
            }
        }
        if (this.updateSize(false)) {
            this.updateScreen();
        }
    }

    protected void delete() {
        if (this.F != null) {
            if (this.editing) {
                int n = this.T.getLineHeightAtTNode(this, this.mainFIndex);
                this.F.delete();
                this.updateScreenLineAtTNode(this.mainFIndex);
                int n2 = this.T.getLineHeightAtTNode(this, this.mainFIndex);
                if (n > n2) {
                    this.scrollFromTNode(this.mainFIndex, n - n2);
                }
            }
        } else {
            TNode tNode = this.T.TNode(this.T.getCursorPos());
            int n = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
            int n3 = this.T.getLineHeightAtTNode(this, this.T.getCursorPos() + 1);
            boolean bl = "\n".equals(tNode.getChar());
            if (this.T.delete()) {
                this.updateScreenLineAtTNode(this.T.getCursorPos());
                int n4 = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
                if (bl) {
                    this.scrollFromTNode(this.T.getCursorPos(), n + n3 - n4);
                } else if (n > n4) {
                    this.scrollFromTNode(this.T.getCursorPos(), n - n4);
                }
            }
        }
    }

    protected void backSpace() {
        if (this.F != null) {
            if (this.editing) {
                int n = this.T.getLineHeightAtTNode(this, this.mainFIndex);
                if (this.F.backSpace()) {
                    this.updateScreenLineAtTNode(this.mainFIndex);
                    int n2 = this.T.getLineHeightAtTNode(this, this.mainFIndex);
                    if (n > n2) {
                        this.scrollFromTNode(this.mainFIndex, n - n2);
                    }
                }
            }
        } else {
            int n;
            TNode tNode = this.T.TNode(this.T.prevChar(this.T.getCursorPos()));
            int n3 = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
            int n4 = n = this.T.getCursorPos() > 0 ? this.T.getLineHeightAtTNode(this, this.T.getCursorPos() - 1) : 0;
            if (this.T.backSpace()) {
                if ("\n".equals(tNode.getChar())) {
                    this.updateScreenLineAtTNode(this.T.getCursorPos());
                    int n5 = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
                    this.scrollFromTNode(this.T.getCursorPos(), n + n3 - n5);
                } else {
                    this.updateScreenLineAtTNode(this.T.getCursorPos());
                    int n6 = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
                    if (n3 > n6) {
                        this.scrollFromTNode(this.T.getCursorPos(), n3 - n6);
                    }
                }
            }
        }
    }

    protected void removeMarkedSegment() {
        if (this.F != null) {
            if (this.editing && this.F.segMarked()) {
                int n = this.T.getLineHeightAtTNode(this, this.mainFIndex);
                this.F.removeMarkedSegment();
                this.updateScreenLineAtTNode(this.mainFIndex);
                int n2 = this.T.getLineHeightAtTNode(this, this.mainFIndex);
                if (n > n2) {
                    this.scrollFromTNode(this.mainFIndex, n - n2);
                }
            }
        } else if (this.T.segMarked()) {
            int n = this.T.getLineHeightAtTNode(this, this.T.segMin());
            int n3 = this.T.getY(this, this.T.segMin()) - this.T.getLineAscentAtTNode(this, this.T.segMin()) + n;
            int n4 = this.T.getLineHeightAtTNode(this, this.T.segMax());
            int n5 = this.T.getY(this, this.T.segMax()) - this.T.getLineAscentAtTNode(this, this.T.segMax()) + n4;
            this.T.removeMarkedSegment();
            this.updateScreenLineAtTNode(this.T.getCursorPos());
            int n6 = this.T.getLineHeightAtTNode(this, this.T.getCursorPos());
            if (n + n5 - n3 - n6 > 0) {
                this.scrollFromTNode(this.T.getCursorPos(), n + n5 - n3 - n6);
            }
        }
    }

    protected void scrollFromTNode(int n, int n2) {
        int n3 = this.T.getLineHeightAtTNode(this, n);
        int n4 = this.T.getY(this, n) - this.T.getLineAscentAtTNode(this, n) + n3;
        this.bG.clipRect(0, n4, this.getSize().width, this.getSize().height);
        this.bG.drawImage(this.buffer, 0, -n2, this);
        this.bG.setClip(null);
        this.bG.setColor(this.getBackground());
        this.bG.fillRect(0, this.getTextHeight() - this.T.getBottomMargin(), this.getSize().width, this.getSize().height);
        this.T.updateComponentLocations(this, this.bG);
        Graphics graphics = this.getGraphics();
        graphics.clipRect(0, n4, this.getSize().width, this.getSize().height);
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    protected int getCursorPos() {
        if (this.F != null) {
            return this.F.getCursorPos();
        }
        return this.T.getCursorPos();
    }

    protected void updateScreenSegment(int n, int n2) {
        if (this.bG != null) {
            this.T.drawSegment(this.bG, this, this.editing, n, n2, this.showholes);
        }
    }

    protected void updateScreenLineAtTNode(int n) {
        this.updateScreenSegment(n, n);
    }

    protected void updateScreenFromTNode(int n) {
        if (n <= this.T.end()) {
            this.updateScreenSegment(n, this.T.end());
        }
        if (this.bG != null) {
            int n2 = this.T.getY(this, this.T.end()) + this.T.getLineDescentAtTNode(this, this.T.end());
            this.bG.setColor(this.getBackground());
            this.bG.fillRect(0, n2, this.getSize().width, this.getSize().height - n2);
            Graphics graphics = this.getGraphics();
            if (graphics != null) {
                graphics.clipRect(0, n2, this.getSize().width, this.getSize().height - n2);
                graphics.drawImage(this.buffer, 0, 0, this);
            }
        }
    }

    public void updateScreen() {
        this.updateScreen(this.showholes);
    }

    public void updateScreen(boolean bl) {
        if (!this.updatingScreen) {
            this.updatingScreen = true;
            this.showholes = bl;
            if (this.T != null) {
                this.T.calcValues(this.dec, this.fixed, this.aL, this.isEditing(), this.learnerMode);
                this.updateSize(false);
                if (this.bG != null) {
                    this.bG = this.buffer.getGraphics();
                    this.bG.setColor(Color.white);
                    this.bG.setColor(this.getBackground());
                    this.bG.fillRect(0, 0, this.getSize().width, this.getSize().height);
                    this.updateScreenFromTNode(this.T.begin());
                }
            }
            this.updatingScreen = false;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private boolean isPainting() {
        return this.painting;
    }

    public void paint(Graphics graphics) {
        if (this.isPainting()) {
            return;
        }
        this.painting = true;
        super.paint(graphics);
        if (this.buffer != null) {
            if (this.getSize().height < this.getCanvasHeight()) {
                this.setSize(this.getSize().width, this.buffer.getHeight());
            }
            graphics.setClip(0, -this.getLocation().y, this.getSize().width, 2000);
            graphics.drawImage(this.buffer, 0, 0, this);
        }
        this.painting = false;
    }

    public void stop() {
        this.flush();
    }

    protected void flush() {
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
            System.gc();
        }
    }

    public Dimension bufferSize() {
        if (this.buffer != null) {
            return new Dimension(this.buffer.getWidth(this), this.buffer.getHeight(this));
        }
        return null;
    }

    public void compactCanvas(boolean bl) {
        this.setSize(this.getSize().width, this.getCanvasHeight());
        if (bl) {
            this.updateSize(false);
            this.updateScreen();
        }
    }

    private boolean updateGraphics(int n, int n2) {
        if (n > 0 & n2 > 0 && (this.buffer == null || this.buffer.getWidth(this) != n || this.buffer.getHeight(this) < n2)) {
            this.flush();
            this.buffer = new BufferedImage(n, n2, 6);
            this.bG = this.buffer.getGraphics();
            return true;
        }
        return false;
    }

    public boolean updateSize() {
        return this.updateSize(false);
    }

    public boolean updateSize(boolean bl) {
        if (bl || this.buffer == null || this.getSize().height < this.getCanvasHeight() || this.buffer.getHeight(this) < this.getCanvasHeight()) {
            int n = 20;
            Container container = this.getParent();
            if (container != null && container.getSize() != null) {
                n = Math.max(n, container.getSize().height);
            }
            int n2 = Math.max(n, this.getCanvasHeight() + (this.editing ? 200 : 0));
            this.setSize(this.getSize().width, n2);
            boolean bl2 = this.updateGraphics(this.getSize().width, n2);
            return bl2;
        }
        return false;
    }

    public int getCursorY() {
        return this.T.getY(this, this.getCursorPos());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        TNode tNode = this.T.getTNodeAtPixel(this, mouseEvent.getX(), mouseEvent.getY());
        if (tNode != null && tNode.isHyperlink()) {
            if (this.A != null) {
                this.A.getAppletContext().showStatus(tNode.getUri());
            }
            if (this.getCursor() != Cursor.getPredefinedCursor(12)) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        } else {
            if (this.A != null) {
                this.A.getAppletContext().showStatus("");
            }
            if (this.isEditing()) {
                if (this.getCursor() != Cursor.getPredefinedCursor(2)) {
                    this.setCursor(Cursor.getPredefinedCursor(2));
                }
            } else {
                this.setCursor(null);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.dragging) {
            this.dragging = true;
            int n = mouseEvent.getY() - this.mouse_y;
            if (this.jsb != null && n != 0) {
                int n2 = -Math.max(this.getCanvasHeight() - this.containerSize + 0, 0);
                int n3 = Math.max(Math.min(this.getLocation().y + n, 0), n2);
                if (this.getLocation().y != n3) {
                    n = n3 - this.getLocation().y;
                    this.mouse_y = mouseEvent.getY() - n;
                    this.setLocation(0, n3);
                    this.invalidate();
                    this.repaint();
                    this.jsb.setMaximum(-n2);
                    this.jsb.setVisibleAmount(250);
                    this.jsb.setValue(-n3);
                }
            }
            this.dragging = false;
        }
        this.mouse_x = mouseEvent.getX();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse_x = mouseEvent.getX();
        this.mouse_y = mouseEvent.getY();
        this.setCursor(new Cursor(13));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCursor(null);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TNode tNode;
        if (this.A != null && (tNode = this.T.getTNodeAtPixel(this, mouseEvent.getX(), mouseEvent.getY())) != null && tNode.isHyperlink() && tNode.getUri() != null) {
            try {
                if (tNode.getUri().toLowerCase().startsWith("http://")) {
                    this.A.getAppletContext().showDocument(new URL(tNode.getUri()), "_blank");
                } else if (tNode.getUri().toLowerCase().startsWith("/resources")) {
                    this.A.getAppletContext().showDocument(this.A.getClass().getResource(tNode.getUri()), "_blank");
                } else {
                    this.A.getAppletContext().showDocument(new URL(this.A.getDocumentBase(), tNode.getUri()), "_self");
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                System.out.println("in EditorCanvas.mouseClicked");
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

