/*
 * Decompiled with CFR 0.152.
 */
package com.mja.textedit;

import com.mja.cmp.mjaButton;
import com.mja.file.mjaFont;
import com.mja.gui.Explainer;
import com.mja.gui.MouseCursorHandler;
import com.mja.gui.editDialog;
import com.mja.gui.editFrame;
import com.mja.gui.mjaColor;
import com.mja.gui.mjaText;
import com.mja.guiedit.ColorButton;
import com.mja.guiedit.editColorDialog;
import com.mja.lang.Expl;
import com.mja.lang.translator;
import com.mja.text.RTF;
import com.mja.text.TColors;
import com.mja.textedit.EditorCanvas;
import com.mja.textedit.UnicodeSelector;
import com.mja.util.BasicStr;
import com.mja.util.TFont;
import java.applet.Applet;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.unam.matem.Attribute;

public class EditorButtons
extends Panel
implements ActionListener,
ItemListener,
MouseListener,
MouseMotionListener,
Explainer {
    public static int Latin = 0;
    public static int Symbols = 1;
    public static int Greek = 2;
    public static int GREEK = 3;
    public static final Color borderColor = new Color(7905432);
    public static final int FUENTES = 0;
    public static final int COLORES = 1;
    public static final int fract = 2;
    public static final int power = 3;
    public static final int radical = 4;
    public static final int sum = 5;
    public static final int integral = 6;
    public static final int limit = 7;
    public static final int matrix = 8;
    public static final int defparts = 9;
    public static final int expr = 10;
    public static final int FORMULAS = 11;
    public static final int CARACTERES = 12;
    public static final int UNICODE = 13;
    public static final int TO_RTF = 14;
    public static final int IMAGES = 15;
    public static final int HYPERLINK = 16;
    public static final int CONTROL = 17;
    public static final int TEXT_ = 18;
    public static final int TEXT__ = 19;
    public static final int TEXT___ = 20;
    public static final int MENU = 21;
    public static final int BARRA = 22;
    public static final int BUTTON = 23;
    public static final int SPACER2 = 24;
    public static final int SPACER3 = 25;
    public static final int SPACETA = 26;
    public static final int SPACEGL = 27;
    public static final int HELP = 28;
    public static final String[] attrName = new String[]{"fuentes", "colores", "fracciones", "potencias", "radicales", "series", "integrales", "l\u00edmites", "matrices", "defparts", "expresiones", "formulas", "caracteres", "unicode", "rtf", "im\u00e1genes", "hiperv\u00ednculos", "controles", "texto_", "texto__", "texto___", "men\u00fa", "barra", "bot\u00f3n", "espaciosR2", "espaciosR3", "espaciosTA", "espaciosGL", "ayuda"};
    public static final String[] attrSymbol = new String[]{"fuentes", "colores", "\u00be", "x\u00b2", "\u221a\u00af", "\u2211", "\u222b", "lim", "(::)", "{:", "ex", "[F]", "caracteres", "tabla", "rtf", "im\u00e1genes", "Hv", "Cn", "Txt_", "Txt__", "Txt___", "Mnu", "Scr", "Btn", "R2", "R3", "TA", "AP", "?"};
    public static final String ItemsAttributes = "fuentes=no colores=no formulas=si fracciones=si potencias=si radicales=si series=si integrales=si limites=si matrices=si defparts=si expresiones=no caracteres=no unicode=si rtf=no im\u00e1genes=no ayuda=no";
    public static final String DefaultAttributes = "fuentes=si colores=si formulas=no fracciones=si potencias=si radicales=si series=no integrales=no limites=no matrices=si defparts=si expresiones=no caracteres=si unicode=no rtf=no im\u00e1genes=no ayuda=si";
    public static final String DescartesAttributes = "fuentes=si colores=si formulas=si fracciones=si potencias=si radicales=si series=si integrales=si limites=si matrices=si defparts=si expresiones=si caracteres=no unicode=si rtf=no im\u00e1genes=no ayuda=si";
    public static final String ArquimedesAttributes = "fuentes=si colores=si formulas=si fracciones=si potencias=si radicales=si series=si integrales=si l\u00edmites=si matrices=si defparts=si expresiones=si caracteres=si unicode=si rtf=no im\u00e1genes=no hiperv\u00ednculos=si ayuda=si controles=si espaciosR2=si espaciosR3=si espaciosTA=si espaciosGL=si";
    public boolean[] boolAttr = new boolean[attrName.length];
    private JComboBox ch_type;
    private JComboBox ch_size;
    private JComboBox ch_symb;
    private JCheckBox chb_bold;
    private JCheckBox chb_italic;
    private JCheckBox chb_underline;
    private JCheckBox chb_overline;
    private ColorButton colorButton;
    private mjaButton b_uc;
    private mjaButton b_for;
    private mjaButton b_rtf;
    private mjaButton b_hl;
    private mjaButton b_ctrl;
    private mjaButton b_text_;
    private mjaButton b_text__;
    private mjaButton b_text___;
    private mjaButton b_menu;
    private mjaButton b_barra;
    private mjaButton b_button;
    private mjaButton b_spR2;
    private mjaButton b_spR3;
    private mjaButton b_spTA;
    private mjaButton b_spGL;
    private mjaButton b_help;
    private static final String[] bFTit = new String[]{"Fracci\u00f3n", "Potencia", "Radical", "Suma", "Integral", "L\u00edmite", "Matriz", "Definici\u00f3n por partes", "Expresi\u00f3n"};
    private mjaButton[] bFEC = new mjaButton[9];
    private Panel NP1;
    private Panel NP2;
    private Panel spsymb;
    private String[] lbSymb = new String[]{"Latino", "S\u00edmbolos", "Griegas", "GRIEGAS"};
    private int[] charbase = new int[]{97, 8704, 945, 913};
    private int base = 0;
    private mjaButton[] bSymb = new mjaButton[32];
    private editFrame ef_rtf;
    private editFrame ef_symbol;
    private editFrame ef_special;
    private TextArea t_rtf;
    private editColorDialog ecd;
    private Frame pf;
    private translator Tr;
    private MouseCursorHandler mch;
    private MouseCursorHandler extra_mch;
    private boolean editable;
    private boolean symbTbl;
    private boolean images;
    private boolean toRTF;
    private boolean inFormula;
    private EditorCanvas EC;
    private int ixOther = -1;
    private TextField tf;
    private boolean fill;
    private boolean useKB;
    private boolean useListeners = false;
    private boolean empty = true;
    private Applet A;
    private mjaFont mf;
    private int isymb = -1;
    private int ifec = -1;
    private int as_in = -1;
    private boolean dragged = false;

    public EditorButtons(Applet applet, Frame frame, translator translator2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        this.A = applet;
        this.pf = frame;
        this.Tr = translator2;
        this.editable = bl;
        this.images = bl2;
        this.fill = bl3;
        this.useKB = bl4;
        this.mch = new MouseCursorHandler(this, this);
        this.setFont(mjaFont.makeFont("SansSerif", 0, 12));
        this.ch_type = new JComboBox();
        for (n = 0; n < RTF.Java2FontNames.length; ++n) {
            this.ch_type.addItem(RTF.Java2FontNames[n]);
        }
        this.ch_type.setSelectedIndex(1);
        this.ch_size = new JComboBox();
        for (n = 8; n < 80; ++n) {
            if (n > 30) {
                ++n;
            }
            if (n > 40) {
                n += 2;
            }
            this.ch_size.addItem(Integer.toString(n));
        }
        this.chb_bold = new JCheckBox("n");
        this.chb_bold.setFont(mjaFont.makeFont("SansSerif", 1, 12));
        this.chb_italic = new JCheckBox("it");
        this.chb_italic.setFont(mjaFont.makeFont("SansSerif", 2, 12));
        this.chb_underline = new JCheckBox("_");
        this.chb_overline = new JCheckBox(new Character('\u00af').toString());
        this.ch_symb = new JComboBox();
        this.setCharsList(this.lbSymb, this.charbase);
        this.ch_symb.addItemListener(this);
        this.ch_symb.addMouseListener(this.mch);
        this.b_hl = new mjaButton(attrSymbol[16]);
        this.b_ctrl = new mjaButton(attrSymbol[17]);
        this.b_text_ = new mjaButton(attrSymbol[18]);
        this.b_text__ = new mjaButton(attrSymbol[19]);
        this.b_text___ = new mjaButton(attrSymbol[20]);
        this.b_menu = new mjaButton(attrSymbol[21]);
        this.b_barra = new mjaButton(attrSymbol[22]);
        this.b_button = new mjaButton(attrSymbol[23]);
        this.b_spR2 = new mjaButton(attrSymbol[24]);
        this.b_spR3 = new mjaButton(attrSymbol[25]);
        this.b_spTA = new mjaButton(attrSymbol[26]);
        this.b_spGL = new mjaButton(attrSymbol[27]);
        this.b_uc = new mjaButton(attrSymbol[13]);
        this.b_rtf = new mjaButton(attrSymbol[14]);
        this.b_help = new mjaButton(attrSymbol[28]);
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.b_for = new mjaButton(attrSymbol[11]);
        this.mf = new mjaFont("SansSerif", 0, 16);
        this.spsymb = new Panel();
        for (int i = 0; i < this.bSymb.length; ++i) {
            this.bSymb[i] = new mjaButton(6);
            this.bSymb[i].setSize(24, 25);
            this.bSymb[i].addActionListener(this);
            this.bSymb[i].addMouseListener(this);
            this.bSymb[i].addMouseListener(this.mch);
            this.bSymb[i].addMouseMotionListener(this);
            this.bSymb[i].setFont(this.mf.getMathFont());
        }
        this.tf = new TextField(4);
        this.tf.setBackground(Color.white);
        this.tf.addActionListener(this);
        this.tf.addMouseListener(this.mch);
        this.b_uc.addMouseListener(this);
        this.b_for.addMouseListener(this);
        this.b_rtf.addActionListener(this);
        this.b_help.addActionListener(this);
        this.b_hl.addMouseListener(this);
        this.b_ctrl.addMouseListener(this);
        this.b_text_.addMouseListener(this);
        this.b_text__.addMouseListener(this);
        this.b_text___.addMouseListener(this);
        this.b_menu.addMouseListener(this);
        this.b_barra.addMouseListener(this);
        this.b_button.addMouseListener(this);
        this.b_spR2.addMouseListener(this);
        this.b_spR3.addMouseListener(this);
        this.b_spTA.addMouseListener(this);
        this.b_spGL.addMouseListener(this);
        this.addItemListeners(true);
        this.ch_type.addMouseListener(this.mch);
        this.ch_size.addMouseListener(this.mch);
        this.chb_bold.addMouseListener(this.mch);
        this.chb_italic.addMouseListener(this.mch);
        this.chb_underline.addMouseListener(this.mch);
        this.chb_overline.addMouseListener(this.mch);
        this.colorButton = new ColorButton("C");
        this.colorButton.setTextColor(new mjaColor(Color.black));
        this.colorButton.setBackColor(new mjaColor(Color.white));
        this.colorButton.addMouseListener(this);
        this.b_uc.addMouseListener(this.mch);
        this.b_for.addMouseListener(this.mch);
        this.b_rtf.addMouseListener(this.mch);
        this.b_help.addMouseListener(this.mch);
        this.b_hl.addMouseListener(this.mch);
        this.b_ctrl.addMouseListener(this.mch);
        this.b_text_.addMouseListener(this.mch);
        this.b_text__.addMouseListener(this.mch);
        this.b_text___.addMouseListener(this.mch);
        this.b_menu.addMouseListener(this.mch);
        this.b_barra.addMouseListener(this.mch);
        this.b_button.addMouseListener(this.mch);
        this.b_spR2.addMouseListener(this.mch);
        this.b_spR3.addMouseListener(this.mch);
        this.b_spTA.addMouseListener(this.mch);
        this.b_spGL.addMouseListener(this.mch);
        this.colorButton.addMouseListener(this.mch);
        String string = "";
        if (applet != null) {
            string = applet.getParameter("EditorConfig");
        }
        if (BasicStr.hasContent(string)) {
            this.setAttributes(string);
        } else {
            this.setAttributes(DefaultAttributes);
        }
    }

    public void selectChars(int n) {
        if (0 <= n && n < this.lbSymb.length) {
            this.ch_symb.setSelectedIndex(n);
        }
    }

    public void setCharsList(String[] stringArray, int[] nArray) {
        this.lbSymb = stringArray;
        this.charbase = nArray;
        this.ch_symb.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            this.ch_symb.addItem(stringArray[i]);
        }
        if (stringArray.length > 0) {
            this.ch_symb.setSelectedIndex(0);
        }
    }

    public void setAttributes(String string) {
        Attribute[] attributeArray = Attribute.parse(string);
        this.empty = true;
        for (int i = 0; i < this.boolAttr.length; ++i) {
            String string2 = Attribute.getValue(attributeArray, attrName[i]);
            boolean bl = this.boolAttr[i] = BasicStr.hasContent(string2) && !string2.equalsIgnoreCase("no") && !string2.equalsIgnoreCase("0");
            if (!this.boolAttr[i]) continue;
            this.empty = false;
        }
        this.rebuild();
        this.updateChars();
    }

    public void setEditorCanvas(EditorCanvas editorCanvas, boolean bl) {
        if (this.EC != null) {
            this.EC.removeMouseListener(this);
            this.EC.removeMouseMotionListener(this);
        }
        this.EC = editorCanvas;
        this.EC.addMouseListener(this);
        this.EC.addMouseMotionListener(this);
        if (bl) {
            this.setEditing(this.EC.isEditing());
            this.updateSelectors();
            this.EC.activateButtons();
        }
    }

    public void addExtraMH(MouseCursorHandler mouseCursorHandler) {
        this.extra_mch = mouseCursorHandler;
    }

    public void removeExtraMH() {
        this.extra_mch = null;
    }

    private void rebuild() {
        int n;
        this.removeAll();
        this.NP1 = new Panel();
        this.NP1.setBackground(borderColor);
        this.NP1.setLayout(new FlowLayout(0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        if (this.fill) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
        } else {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (this.boolAttr[28]) {
            this.NP1.add((Component)this.b_help, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[0]) {
            this.NP1.add((Component)this.ch_type, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.NP1.add((Component)this.ch_size, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.NP1.add((Component)this.chb_bold, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.chb_bold.setFont(mjaFont.makeFont("SansSerif", 1, 12));
            this.NP1.add((Component)this.chb_italic, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.chb_italic.setFont(mjaFont.makeFont("SansSerif", 2, 12));
            this.NP1.add((Component)this.chb_underline, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.NP1.add((Component)this.chb_overline, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[1]) {
            this.NP1.add((Component)this.colorButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[11]) {
            this.NP1.add((Component)this.b_for, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        for (n = 0; n < this.bFEC.length; ++n) {
            this.bFEC[n] = new mjaButton(attrSymbol[2 + n]);
            if (this.boolAttr[2 + n]) {
                this.NP1.add((Component)this.bFEC[n], gridBagConstraints);
                ++gridBagConstraints.gridx;
            }
            this.bFEC[n].addActionListener(this);
            this.bFEC[n].addMouseListener(this);
            this.bFEC[n].addMouseListener(this.mch);
            this.bFEC[n].addMouseMotionListener(this);
        }
        if (this.boolAttr[16]) {
            this.NP1.add((Component)this.b_hl, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[13]) {
            this.NP1.add((Component)this.b_uc, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.NP1.add(this.tf);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[14]) {
            this.NP1.add((Component)this.b_rtf, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        if (this.boolAttr[28]) {
            this.NP1.add((Component)this.b_help, gridBagConstraints);
            ++gridBagConstraints.gridx;
        }
        this.NP2 = new Panel();
        this.NP2.setBackground(borderColor);
        this.NP2.setLayout(new GridBagLayout());
        n = 0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.anchor = 17;
        if (this.fill) {
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 1;
        } else {
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.fill = 0;
        }
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        if (this.boolAttr[17]) {
            this.NP2.add((Component)this.b_ctrl, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            this.NP2.add((Component)this.b_text_, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            this.NP2.add((Component)this.b_text__, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            this.NP2.add((Component)this.b_text___, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            this.NP2.add((Component)this.b_menu, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            this.NP2.add((Component)this.b_barra, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            this.NP2.add((Component)this.b_button, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            n = 1;
        }
        if (this.boolAttr[24]) {
            this.NP2.add((Component)this.b_spR2, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            n = 1;
        }
        if (this.boolAttr[25]) {
            this.NP2.add((Component)this.b_spR3, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            n = 1;
        }
        if (this.boolAttr[26]) {
            this.NP2.add((Component)this.b_spTA, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            n = 1;
        }
        if (this.boolAttr[27]) {
            this.NP2.add((Component)this.b_spGL, gridBagConstraints2);
            ++gridBagConstraints2.gridx;
            n = 1;
        }
        if (n != 0) {
            this.NP2.add((Component)new Label("               "), gridBagConstraints2);
            ++gridBagConstraints2.gridx;
        }
        if (this.boolAttr[12] && n != 0) {
            this.setLayout(new GridLayout(3, 1));
            this.add(this.NP1);
            this.add(this.NP2);
            this.add(this.spsymb);
        } else if (n != 0) {
            this.setLayout(new GridLayout(2, 1));
            this.add(this.NP1);
            this.add(this.NP2);
        } else if (this.boolAttr[12]) {
            this.setLayout(new GridLayout(2, 1));
            this.add(this.NP1);
            this.add(this.spsymb);
        } else {
            this.setLayout(new GridLayout(1, 1));
            this.add(this.NP1);
        }
        this.ch_size.setSelectedItem("17");
        this.ch_symb.setSelectedIndex(1);
    }

    public void updateChars() {
        int n;
        this.spsymb.removeAll();
        this.spsymb.repaint();
        this.spsymb.setBackground(borderColor);
        this.spsymb.setLayout(new FlowLayout(0, 0, 0));
        this.spsymb.add(this.ch_symb);
        this.ixOther = -1;
        int n2 = 26;
        this.base = this.charbase[this.ch_symb.getSelectedIndex()];
        if (this.ch_symb.getSelectedIndex() == Symbols) {
            n = 0;
            this.bSymb[n++].setLabel("+");
            this.bSymb[n++].setLabel(new Character((char)(this.base + 18)).toString());
            this.bSymb[n++].setLabel(new Character('\u00b7').toString());
            this.bSymb[n++].setLabel(new Character('\u00d7').toString());
            this.bSymb[n++].setLabel(new Character('\u00f7').toString());
            this.bSymb[n++].setLabel(new Character('\u00b1').toString());
            this.bSymb[n++].setLabel("=");
            this.bSymb[n++].setLabel(new Character((char)(this.base + 96)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 100)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 101)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 72)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 97)).toString());
            this.bSymb[n++].setLabel(new Character('\u0192').toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 30)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 0)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 3)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 4)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 8)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 9)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 52)).toString());
            this.bSymb[n++].setLabel(new Character('\u21d2').toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 5)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 41)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 42)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 2)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 6)).toString());
            this.bSymb[n++].setLabel(new Character((char)(this.base + 7)).toString());
            this.bSymb[n++].setLabel(new Character('\u03c0').toString());
            n2 = n;
            for (int i = 0; i < n2; ++i) {
                this.spsymb.add(this.bSymb[i]);
            }
        } else {
            if (this.base == 945 || this.base == 913) {
                n2 = 25;
            }
            for (n = 0; n < n2; ++n) {
                this.bSymb[n].setLabel(new Character((char)(this.base + n)).toString());
                this.spsymb.add(this.bSymb[n]);
            }
        }
        for (n = 0; n < n2 + 1; ++n) {
            int n3;
            String string = this.bSymb[n].getLabel();
            int n4 = n3 = string != null && string.length() == 1 ? (int)string.charAt(0) : 0;
            if (n3 > 8448) {
                this.bSymb[n].setFont(this.mf.getMathFont());
                continue;
            }
            this.bSymb[n].setFont(this.mf.getAwtFont());
        }
        if (this.EC != null && this.useKB) {
            this.EC.setUnicodeBase(this.base);
        }
        this.ch_symb.invalidate();
        this.ch_symb.repaint();
        for (n = 0; n < n2 + 1; ++n) {
            this.bSymb[n].invalidate();
            this.bSymb[n].repaint();
        }
    }

    private void updateEnabling() {
        int n;
        this.colorButton.setEnabled(this.editable);
        this.ch_type.setEnabled(this.editable);
        this.ch_size.setEnabled(this.editable);
        this.chb_bold.setEnabled(this.editable);
        this.chb_italic.setEnabled(this.editable);
        this.chb_underline.setEnabled(this.editable);
        this.chb_overline.setEnabled(this.editable);
        this.b_uc.setEnabled(this.editable);
        this.b_for.setEnabled(this.editable);
        this.b_rtf.setEnabled(this.editable);
        this.b_hl.setEnabled(this.editable);
        this.b_ctrl.setEnabled(this.editable);
        this.b_text_.setEnabled(this.editable);
        this.b_text__.setEnabled(this.editable);
        this.b_text___.setEnabled(this.editable);
        this.b_menu.setEnabled(this.editable);
        this.b_barra.setEnabled(this.editable);
        this.b_button.setEnabled(this.editable);
        this.b_spR2.setEnabled(this.editable);
        this.b_spR3.setEnabled(this.editable);
        this.b_spTA.setEnabled(this.editable);
        this.b_spGL.setEnabled(this.editable);
        for (n = 0; n < this.bFEC.length; ++n) {
            this.bFEC[n].setEnabled(this.editable);
        }
        for (n = 0; n < this.bSymb.length; ++n) {
            this.bSymb[n].setEnabled(this.editable);
        }
        if (this.editable) {
            for (n = 0; n < this.bFEC.length; ++n) {
                this.bFEC[n].setEnabled(true);
            }
            this.b_for.setEnabled(!this.inFormula);
            this.b_hl.setEnabled(!this.inFormula);
            this.b_spR2.setEnabled(!this.inFormula);
            this.b_spR3.setEnabled(!this.inFormula);
            this.b_spTA.setEnabled(!this.inFormula);
            this.b_spGL.setEnabled(!this.inFormula);
        }
    }

    public void updateTranslation() {
        this.chb_bold.setLabel(this.Tr.getTr(235));
        this.chb_italic.setLabel(this.Tr.getTr(236));
        this.chb_underline.setLabel(this.Tr.getTr(237));
        this.chb_overline.setLabel(this.Tr.getTr(238));
        this.colorButton.setLabel(this.Tr.getTr(26));
        this.b_uc.setLabel(this.Tr.getTr(228));
        this.b_for.setLabel(this.Tr.getTr(239));
    }

    public void addItemListeners(boolean bl) {
        this.useListeners = bl;
        this.addItemListeners();
    }

    public void removeItemListeners(boolean bl) {
        this.removeItemListeners();
        this.useListeners = !bl;
    }

    private void addItemListeners() {
        if (this.useListeners) {
            this.ch_type.addItemListener(this);
            this.ch_size.addItemListener(this);
            this.chb_bold.addItemListener(this);
            this.chb_italic.addItemListener(this);
            this.chb_underline.addItemListener(this);
            this.chb_overline.addItemListener(this);
        }
    }

    private void removeItemListeners() {
        if (this.useListeners) {
            this.ch_type.removeItemListener(this);
            this.ch_size.removeItemListener(this);
            this.chb_bold.removeItemListener(this);
            this.chb_italic.removeItemListener(this);
            this.chb_underline.removeItemListener(this);
            this.chb_overline.removeItemListener(this);
        }
    }

    public void updateSelectors() {
        if (this.EC != null) {
            TColors tColors = this.EC.getCursorColors();
            TFont tFont = this.EC.getCursorTFont();
            this.removeItemListeners();
            this.ch_type.setSelectedItem(tFont.getName());
            this.chb_bold.setSelected(tFont.isBold());
            this.chb_italic.setSelected(tFont.isItalic());
            this.chb_underline.setSelected(tFont.isUnderline());
            this.chb_overline.setSelected(tFont.isOverline());
            this.ch_size.setSelectedItem(Integer.toString(tFont.getSize()));
            this.colorButton.setColors(new mjaColor(tColors.getBackColor()), new mjaColor(tColors.getTextColor()));
            this.tf.setText(this.EC.getCharAtCursor());
            this.addItemListeners();
        }
    }

    TColors getColorsFromControls() {
        return new TColors(this.colorButton.getBackColor().getAdaptedColor(), this.colorButton.getTextColor().getAdaptedColor());
    }

    TFont getTFontFromControls() {
        int n = 12;
        try {
            n = Integer.parseInt((String)this.ch_size.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new TFont((String)this.ch_type.getSelectedItem(), this.chb_bold.isSelected(), this.chb_italic.isSelected(), this.chb_underline.isSelected(), this.chb_overline.isSelected(), n);
    }

    void insertTFont() {
        if (this.EC != null) {
            this.EC.saveText();
            this.EC.insertTFont(this.getTFontFromControls());
        }
    }

    private void openSymbolsDialog(Component component) {
        String string = UnicodeSelector.getUnicodeChar(this.pf, this.Tr);
        if (string != null && string.length() > 0) {
            this.EC.saveText();
            this.EC.insertText(string);
        }
        component.setEnabled(false);
        this.EC.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand()) {
            if (actionEvent.getSource() == this.EC && actionEvent.getActionCommand().equals("focus") && !this.useListeners) {
                this.addItemListeners(true);
            }
            if (actionEvent.getSource() == this.b_rtf) {
                mjaText.showPlainText(this.pf, "  RTF  ", " \n" + this.EC.toRTF(false));
            } else if (actionEvent.getSource() == this.b_help) {
                mjaText.msg(this.b_help, "s\u00edmbolo especial", Expl.get(Expl.Help, this.Tr.getActiveLanguage()), mjaFont.AWTMonoB);
            } else if (actionEvent.getSource() == this.EC) {
                if (actionEvent.getActionCommand().equals("UpdateSelectors")) {
                    this.updateSelectors();
                } else if (actionEvent.getActionCommand().equals("ActivateFormulaButtons") || actionEvent.getActionCommand().equals("ActivateTextButtons")) {
                    this.inFormula = actionEvent.getActionCommand().equals("ActivateFormulaButtons");
                    this.updateEnabling();
                }
            } else if (actionEvent.getSource() == this.tf) {
                String string = this.tf.getText();
                if (string.startsWith("0x")) {
                    string = string.substring(2);
                }
                try {
                    this.EC.saveText();
                    this.EC.insertChar((char)Integer.parseInt(string, 16));
                }
                catch (Exception exception) {
                    System.out.println("Invalid hexadecimal expresion");
                }
            }
        }
    }

    public void setEditing(boolean bl) {
        this.editable = bl;
        this.EC.setEditing(bl);
        this.removeItemListeners();
        this.addItemListeners();
        this.updateEnabling();
    }

    public String getExplLabel(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (this.extra_mch != null) {
            return "Controles del texto.";
        }
        if (component instanceof ColorButton) {
            return "Colores de texto y fondo.";
        }
        if (component instanceof mjaButton) {
            mjaButton mjaButton2 = (mjaButton)component;
            for (int i = 0; i < this.bFEC.length; ++i) {
                if (mjaButton2 != this.bFEC[i]) continue;
                return bFTit[i];
            }
            return mjaButton2.getLabel();
        }
        if (component instanceof mjaButton) {
            mjaButton mjaButton3 = (mjaButton)component;
            for (int i = 0; i < this.bSymb.length; ++i) {
                if (mjaButton3 != this.bSymb[i]) continue;
                if (i == this.ixOther) {
                    return "Otros caracteres";
                }
                return "S\u00edmbolo especial";
            }
            return mjaButton3.getLabel();
        }
        if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            if (jComboBox == this.ch_type) {
                return "tipo de letra";
            }
            if (jComboBox == this.ch_size) {
                return "tama\u00f1o de letra";
            }
        } else if (component instanceof Checkbox) {
            Checkbox checkbox = (Checkbox)component;
            return checkbox.getLabel();
        }
        return "";
    }

    public String getExplanation(MouseEvent mouseEvent) {
        String[] stringArray = null;
        Component component = (Component)mouseEvent.getSource();
        if (this.extra_mch != null) {
            stringArray = Expl.AlgebraTutor[10];
            this.extra_mch.setNull();
            this.extra_mch = null;
        } else if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            if (jComboBox == this.ch_type) {
                stringArray = Expl.EditText[0];
            } else if (jComboBox == this.ch_size) {
                stringArray = Expl.EditText[1];
            } else if (jComboBox == this.ch_symb) {
                stringArray = Expl.EditText[14];
            }
        } else if (component instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)component;
            if (jCheckBox == this.chb_bold) {
                stringArray = Expl.EditText[2];
            } else if (jCheckBox == this.chb_italic) {
                stringArray = Expl.EditText[3];
            } else if (jCheckBox == this.chb_underline) {
                stringArray = Expl.EditText[4];
            } else if (jCheckBox == this.chb_overline) {
                stringArray = Expl.EditText[5];
            }
        } else if (component instanceof mjaButton) {
            int n;
            mjaButton mjaButton2 = (mjaButton)component;
            if (mjaButton2 == this.colorButton) {
                stringArray = Expl.EditText[8];
            } else if (mjaButton2 == this.b_help) {
                stringArray = Expl.EditText[9];
            } else if (mjaButton2 == this.b_uc) {
                stringArray = Expl.EditText[10];
            } else if (mjaButton2 == this.b_for) {
                stringArray = Expl.EditText[11];
            } else if (mjaButton2 == this.b_rtf) {
                stringArray = Expl.EditText[12];
            } else if (mjaButton2 == this.b_hl) {
                stringArray = Expl.EditText[17];
            } else if (mjaButton2 == this.b_ctrl) {
                stringArray = Expl.EditText[18];
            } else if (mjaButton2 == this.b_text_) {
                stringArray = Expl.EditText[19];
            } else if (mjaButton2 == this.b_text__) {
                stringArray = Expl.EditText[20];
            } else if (mjaButton2 == this.b_text___) {
                stringArray = Expl.EditText[21];
            } else if (mjaButton2 == this.b_menu) {
                stringArray = Expl.EditText[22];
            } else if (mjaButton2 == this.b_barra) {
                stringArray = Expl.EditText[23];
            } else if (mjaButton2 == this.b_button) {
                stringArray = Expl.EditText[24];
            } else if (mjaButton2 == this.b_spR2) {
                stringArray = Expl.EditText[25];
            } else if (mjaButton2 == this.b_spR3) {
                stringArray = Expl.EditText[26];
            } else if (mjaButton2 == this.b_spTA) {
                stringArray = Expl.EditText[27];
            } else if (mjaButton2 == this.b_spGL) {
                stringArray = Expl.EditText[28];
            } else {
                for (n = 0; n < this.bFEC.length; ++n) {
                    if (mjaButton2 != this.bFEC[n]) continue;
                    stringArray = Expl.EditFormula[n];
                    break;
                }
            }
            for (n = 0; n < this.bSymb.length; ++n) {
                if (mjaButton2 != this.bSymb[n]) continue;
                stringArray = n == this.ixOther ? Expl.EditText[10] : Expl.EditText[13];
                break;
            }
        } else if (component instanceof ColorButton) {
            ColorButton colorButton = (ColorButton)component;
            if (colorButton == this.colorButton) {
                stringArray = Expl.EditText[7];
            }
        } else if (component instanceof TextField && component == this.tf) {
            stringArray = Expl.EditText[15];
        }
        return Expl.get(stringArray, this.Tr.getActiveLanguage());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (this.extra_mch != null) {
                this.updateSelectors();
                return;
            }
            if (!this.mch.isHand()) {
                if (itemEvent.getSource() == this.ch_type || itemEvent.getSource() == this.ch_size || itemEvent.getSource() == this.chb_bold || itemEvent.getSource() == this.chb_italic || itemEvent.getSource() == this.chb_underline || itemEvent.getSource() == this.chb_overline) {
                    this.insertTFont();
                    if (this.EC != null && !this.EC.segIsMarked()) {
                        this.EC.requestFocus();
                    }
                } else if (itemEvent.getSource() == this.ch_symb) {
                    this.updateChars();
                    for (int i = 0; i < this.bSymb.length; ++i) {
                        this.bSymb[i].invalidate();
                        this.bSymb[i].repaint();
                    }
                }
            }
        } else if (!(this.mch.isHand() || itemEvent.getSource() != this.chb_bold && itemEvent.getSource() != this.chb_italic && itemEvent.getSource() != this.chb_underline && itemEvent.getSource() != this.chb_overline)) {
            this.insertTFont();
            if (!this.EC.segIsMarked()) {
                this.EC.requestFocus();
            }
        }
        this.updateSelectors();
    }

    private void insertNewFormulaItem(int n) {
        switch (2 + n) {
            case 2: {
                this.EC.setEditing(true);
                this.EC.saveText();
                if (!this.inFormula) {
                    this.EC.insertFormula("");
                }
                this.EC.insertFraction("", "");
                break;
            }
            case 3: {
                this.EC.setEditing(true);
                this.EC.saveText();
                if (!this.inFormula) {
                    this.EC.insertFormula("");
                }
                this.EC.insertSuperIndex("");
                break;
            }
            case 4: {
                this.EC.setEditing(true);
                this.EC.saveText();
                if (!this.inFormula) {
                    this.EC.insertFormula("");
                }
                this.EC.insertRadical("", "");
                break;
            }
            case 5: {
                this.EC.setEditing(true);
                this.EC.saveText();
                if (!this.inFormula) {
                    this.EC.insertFormula("");
                }
                this.EC.insertSum("", "", "");
                break;
            }
            case 6: {
                this.EC.setEditing(true);
                this.EC.saveText();
                if (!this.inFormula) {
                    this.EC.insertFormula("");
                }
                this.EC.insertIntegral("", "", "");
                break;
            }
            case 7: {
                this.EC.setEditing(true);
                this.EC.saveText();
                if (!this.inFormula) {
                    this.EC.insertFormula("");
                }
                this.EC.insertLimit("", "", "");
                break;
            }
            case 8: {
                this.EC.saveText();
                if (!this.inFormula) {
                    this.EC.insertFormula("");
                }
                Frame frame = new Frame();
                editDialog editDialog2 = new editDialog(frame, "matriz mxn", true, "aceptar", "cancelar");
                Label label = new Label("m =");
                Label label2 = new Label("n =");
                TextField textField = new TextField("2");
                TextField textField2 = new TextField("2");
                Panel panel = new Panel();
                panel.setLayout(new GridLayout(2, 2, 8, 8));
                panel.add(label);
                panel.add(textField);
                panel.add(label2);
                panel.add(textField2);
                editDialog2.add("Center", panel);
                editDialog2.display(true, true);
                if (editDialog2.ok) {
                    int n2 = BasicStr.parseInteger(textField.getText(), 2, 2);
                    int n3 = BasicStr.parseInteger(textField2.getText(), 2, 2);
                    this.EC.setEditing(true);
                    String[][] stringArray = new String[n2][n3];
                    this.EC.insertMatrix(stringArray);
                }
                frame.dispose();
                editDialog2.dispose();
                break;
            }
            case 9: {
                this.EC.saveText();
                if (!this.inFormula) {
                    this.EC.insertFormula("");
                }
                Frame frame = new Frame();
                editDialog editDialog3 = new editDialog(frame, "Def. por partes", true, "aceptar", "cancelar");
                Label label = new Label("partes");
                label.setAlignment(1);
                TextField textField = new TextField("2");
                Panel panel = new Panel();
                panel.setLayout(new GridLayout(1, 2, 8, 8));
                panel.add(label);
                panel.add(textField);
                editDialog3.add("Center", panel);
                editDialog3.display(true, true);
                if (editDialog3.ok) {
                    int n4 = BasicStr.parseInteger(textField.getText(), 2, 2);
                    this.EC.setEditing(true);
                    String[] stringArray = new String[n4];
                    this.EC.insertDefParts(stringArray);
                }
                frame.dispose();
                editDialog3.dispose();
                break;
            }
            case 10: {
                this.EC.setEditing(true);
                this.EC.saveText();
                this.EC.insertExpr("0.00");
            }
        }
        this.EC.requestFocus();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand()) {
            int n;
            this.ifec = -1;
            this.isymb = -1;
            for (n = 0; n < this.bFEC.length; ++n) {
                if (mouseEvent.getSource() != this.bFEC[n]) continue;
                this.ifec = n;
                break;
            }
            for (n = 0; n < this.bSymb.length; ++n) {
                if (mouseEvent.getSource() != this.bSymb[n]) continue;
                this.isymb = n;
                break;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand()) {
            if (mouseEvent.getModifiers() != 4) {
                if (mouseEvent.getSource() == this.b_hl) {
                    this.EC.saveText();
                    this.EC.insertHyperlink();
                } else if (mouseEvent.getSource() == this.b_ctrl) {
                    this.EC.saveText();
                    this.EC.insertControl(0, this.inFormula);
                } else if (mouseEvent.getSource() == this.b_text_) {
                    this.EC.saveText();
                    this.EC.insertControl(1, this.inFormula);
                } else if (mouseEvent.getSource() == this.b_text__) {
                    this.EC.saveText();
                    this.EC.insertControl(2, this.inFormula);
                } else if (mouseEvent.getSource() == this.b_text___) {
                    this.EC.saveText();
                    this.EC.insertControl(3, this.inFormula);
                } else if (mouseEvent.getSource() == this.b_menu) {
                    this.EC.saveText();
                    this.EC.insertControl(4, this.inFormula);
                } else if (mouseEvent.getSource() == this.b_barra) {
                    this.EC.saveText();
                    this.EC.insertControl(5, this.inFormula);
                } else if (mouseEvent.getSource() == this.b_button) {
                    this.EC.saveText();
                    this.EC.insertControl(6, this.inFormula);
                } else if (mouseEvent.getSource() == this.b_spR2) {
                    this.EC.saveText();
                    this.EC.insertSpace(0);
                } else if (mouseEvent.getSource() == this.b_spR3) {
                    this.EC.saveText();
                    this.EC.insertSpace(1);
                } else if (mouseEvent.getSource() == this.b_spTA) {
                    this.EC.saveText();
                    this.EC.insertSpace(2);
                } else if (mouseEvent.getSource() == this.b_spGL) {
                    this.EC.saveText();
                    this.EC.insertSpace(3);
                } else {
                    if (mouseEvent.getSource() == this.b_for) {
                        this.EC.saveText();
                        this.EC.insertFormula("");
                        this.EC.activateButtons();
                        this.EC.requestFocus();
                        return;
                    }
                    if (mouseEvent.getSource() == this.b_uc) {
                        this.openSymbolsDialog(this.b_uc);
                        return;
                    }
                    if (mouseEvent.getSource() == this.colorButton && (mouseEvent.getModifiers() == 16 || mouseEvent.getModifiers() == 18)) {
                        if (this.ecd == null) {
                            this.ecd = new editColorDialog(this.pf, "", true, "", "");
                        }
                        this.ecd.setTitle(this.Tr.getTr(26));
                        this.ecd.setLabels(this.Tr.getTr(85), this.Tr.getTr(84));
                        this.ecd.setCopyLabels(this.Tr.getTr(125), this.Tr.getTr(126));
                        this.ecd.setColorNames(this.Tr);
                        if (mouseEvent.getModifiers() == 16) {
                            this.ecd.setMjaColor(this.colorButton.getTextColor());
                        } else {
                            this.ecd.setMjaColor(this.colorButton.getBackColor());
                        }
                        this.ecd.display();
                        if (this.ecd.ok) {
                            if (mouseEvent.getModifiers() == 16) {
                                this.colorButton.setTextColor(this.ecd.getMjaColor());
                            } else {
                                this.colorButton.setBackColor(this.ecd.getMjaColor());
                            }
                            this.EC.insertColors(this.getColorsFromControls());
                            if (!this.EC.segIsMarked()) {
                                this.colorButton.setEnabled(false);
                                this.EC.requestFocus();
                            }
                        }
                    }
                }
                if (this.isymb >= 0 || this.ifec >= 0) {
                    if (!this.dragged) {
                        int n;
                        for (n = 0; n < this.bFEC.length; ++n) {
                            if (mouseEvent.getSource() != this.bFEC[n]) continue;
                            this.insertNewFormulaItem(n);
                            return;
                        }
                        for (n = 0; n < this.bSymb.length; ++n) {
                            if (mouseEvent.getSource() != this.bSymb[n]) continue;
                            if (n == this.ixOther) {
                                this.openSymbolsDialog(this.bSymb[this.ixOther]);
                            } else {
                                this.EC.saveText();
                                this.EC.insertText(this.bSymb[n].getLabel());
                                this.EC.requestFocus();
                            }
                            return;
                        }
                    } else {
                        Point point = null;
                        if (this.isymb >= 0) {
                            point = this.bSymb[this.isymb].getLocationOnScreen();
                        } else if (this.ifec >= 0) {
                            point = this.bFEC[this.ifec].getLocationOnScreen();
                        }
                        Point point2 = this.EC.getLocationOnScreen();
                        int n = point.x + mouseEvent.getX() - point2.x;
                        int n2 = point.y + mouseEvent.getY() - point2.y;
                        if (0 <= n && n < this.EC.getSize().width && 0 <= n2 && n2 < this.EC.getSize().height) {
                            this.EC.doMousePressed(n, n2);
                            if (this.isymb >= 0) {
                                if (this.isymb != this.ixOther) {
                                    this.EC.saveText();
                                    this.EC.insertText(this.bSymb[this.isymb].getLabel());
                                    this.EC.requestFocus();
                                }
                            } else if (this.ifec >= 0) {
                                this.insertNewFormulaItem(this.ifec);
                            }
                        }
                    }
                    this.isymb = -1;
                    this.ifec = -1;
                }
            }
        }
        this.dragged = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand() && mouseEvent.getSource() == this.EC && !this.dragged) {
            this.updateEnabling();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.extra_mch != null) {
            return;
        }
        if (!this.mch.isHand() && (this.ifec >= 0 || this.isymb >= 0 && this.isymb != this.ixOther)) {
            this.setCursor(Cursor.getPredefinedCursor(13));
            this.dragged = true;
        }
    }
}

