document.addEventListener('DOMContentLoaded', () => {
  const problemElement = document.getElementById('problem');
  const answerInput = document.getElementById('answer');
  const submitButton = document.getElementById('submit');
  const messageElement = document.getElementById('message');
  const gameContainer = document.getElementById('game-container');
  const victoryScreen = document.getElementById('victory-screen');
  let currentProblem = generateProblem();
  let correctCount = 0;

  function generateProblem() {
    const base = Math.floor(Math.random() * 5) + 2;
    const exponent = Math.floor(Math.random() * 4) + 1;
    const correctAnswer = Math.pow(base, exponent);
    problemElement.textContent = `${base} ^ ${exponent} = ?`;
    return { base, exponent, correctAnswer };
  }

  function showVictoryScreen() {
    gameContainer.style.display = 'none';
    victoryScreen.style.display = 'block';
    createConfetti();
  }

  function resetGame() {
    correctCount = 0;
    currentProblem = generateProblem();
    answerInput.value = '';
    messageElement.textContent = '';
    gameContainer.style.display = 'block';
    victoryScreen.style.display = 'none';
  }

  submitButton.addEventListener('click', () => {
    const userAnswer = parseInt(answerInput.value);
    if (isNaN(userAnswer)) {
      messageElement.textContent = "Por favor, introduce un número.";
      return;
    }

    if (userAnswer === currentProblem.correctAnswer) {
      correctCount++;
      if (correctCount === 5) {
        showVictoryScreen();
        return;
      }
      messageElement.textContent = `¡Correcto! (${correctCount}/5)`;
      currentProblem = generateProblem();
      answerInput.value = '';
    } else {
      messageElement.textContent = `Incorrecto. La respuesta correcta es ${currentProblem.correctAnswer}`;
      correctCount = Math.max(0, correctCount - 1);
    }
  });

  answerInput.addEventListener('keypress', (e) => {
    if (e.key === 'Enter') {
      submitButton.click();
    }
  });

  setInterval(() => {
    if (Math.random() < 0.1) {
      document.body.style.filter = `brightness(${0.8 + Math.random() * 0.4})`;
    }
  }, 100);
});

function createConfetti() {
  const canvas = document.createElement('canvas');
  const ctx = canvas.getContext('2d');
  canvas.classList.add('confetti');
  document.body.appendChild(canvas);

  const particles = [];
  const particleCount = 100;
  
  canvas.width = window.innerWidth;
  canvas.height = window.innerHeight;

  for(let i = 0; i < particleCount; i++) {
    particles.push({
      x: canvas.width/2,
      y: canvas.height/2,
      radius: Math.random() * 5 + 2,
      color: `hsl(${Math.random() * 360}, 100%, 50%)`,
      velocity: {
        x: (Math.random() - 0.5) * 10,
        y: (Math.random() - 0.5) * 10
      },
      rotation: Math.random() * Math.PI * 2
    });
  }

  function animate() {
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    
    particles.forEach((particle, index) => {
      particle.x += particle.velocity.x;
      particle.y += particle.velocity.y;
      particle.velocity.y += 0.1;
      particle.rotation += 0.1;

      ctx.save();
      ctx.translate(particle.x, particle.y);
      ctx.rotate(particle.rotation);
      ctx.fillStyle = particle.color;
      ctx.fillRect(-particle.radius/2, -particle.radius/2, particle.radius, particle.radius);
      ctx.restore();

      if (particle.y > canvas.height) {
        particles.splice(index, 1);
      }
    });

    if (particles.length > 0) {
      requestAnimationFrame(animate);
    } else {
      canvas.remove();
    }
  }

  animate();
}