class Toroide extends GenericGeometry {
  /**
   */
  constructor(gl, major_radius=1, minor_radius=1, Nu=3, Nv=3, material=new FlatMaterial(gl), transform=identity()) {
    super(gl, material, transform);

    this.R = major_radius;
    this.r = minor_radius;
    this.Nu = Nu;
    this.Nv = Nv;

    this.init(gl);
  }

  /**
   */
  getVertices() {
    let vertices = [];

    for (let i=0; i<this.Nv; i++) {
      for (let j=0; j<this.Nu; j++) {
        vertices.push(
          -(this.R + this.r * Math.sin(2*Math.PI*j/this.Nu)) * Math.sin(2*Math.PI*i/this.Nv),
           this.r * Math.cos(2*Math.PI*j/this.Nu),
           (this.R + this.r * Math.sin(2*Math.PI*j/this.Nu)) * Math.cos(2*Math.PI*i/this.Nv),
        );
      }
    }

    return vertices;
  }

  /**
   */
  getFaces() {
    let faces = [];

    for (let i=0; i<this.Nv; i++) {
      for (let j=0; j<this.Nu; j++) {
        faces.push(
          j             +i*this.Nu,
          j             +((i+1)%this.Nv)*this.Nu,
          (j+1)%this.Nu +i*this.Nu,

          j             +((i+1)%this.Nv)*this.Nu,
          (j+1)%this.Nu +((i+1)%this.Nv)*this.Nu,
          (j+1)%this.Nu +i*this.Nu,
        );
      }
    }
  
    return faces;
  }
}
