window.addEventListener("load", async function(evt) {
  const gl = document.getElementById("the_canvas").getContext("webgl2");
  if (!gl) throw "WebGL no soportado";


  window.addEventListener("resize", resize);
  function resize() {
    let container = document.getElementById("contenedor");
    let scaleToFitX = window.innerWidth/container.offsetWidth;
    let scaleToFitY = window.innerHeight/container.offsetHeight;

    container.style.transformOrigin = "0 0";
    container.style.position = "absolute";
    container.style.margin = container.style.padding = 0;

    container.style.left = (scaleToFitX < scaleToFitY) ? "0" : "50%";
    container.style.top  = (scaleToFitX < scaleToFitY) ? "50%" : "0";
    container.style.transform = `translate3d(0px, 0px, 0px) scale(${Math.min(scaleToFitX, scaleToFitY)}) translate(-${container.style.left}, -${container.style.top})`;
  }

  resize();


  ////////////////////////////////////////////////////
  let geometry = [
    new OBJGeometry(
      gl, 
      await loadText("Geometry/jirafa.obj"), // se lee el archivo .obj con la información geométrica
      await loadText("Geometry/jirafa.mtl"), // se lee el archivo .mtl con los materiales
      new PhongWireframeMaterial(gl, [0.1, 0.1, 0.1], [1, 0, 0], [0, 0, 0], 0.1, [1,1,0,1] ), // se agrega un material para que sea el material de respaldo en caso de que no se lea el .mtl
      translate(0, -4, 0) // la transformación inicial del objeto
    ),
  ];


  let camera = new OrbitCamera(
    { x:-20, y:10, z:25 }, // posición
    { x:0, y:0, z:0 }, // centro de interés
    { x:0, y:1, z:0 }, // vector hacia arriba
  );
  let viewMatrix;

  let projectionMatrix = perspective(45*Math.PI/180, gl.canvas.width/gl.canvas.height, 0.1, 2000);;

  let light = new LuzPuntual(
    { x: 10, y: 10, z: 75 }, // posición
    [ 0.1, 0.1, 0.1 ],    // component ambiental
    [ 1, 1, 1 ],          // componente difuso
    [ 1, 1, 1 ]           // componente especular
  );

  gl.viewport(0, 0, gl.canvas.width, gl.canvas.height);
  gl.clearColor(0, 0, 0, 0);


  /**
   */
  function draw() {
    gl.enable(gl.DEPTH_TEST);

    gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

    viewMatrix = camera.getMatrix();

    // se actualiza la posición de la luz
    light.update(viewMatrix);

    for (let i=0; i<geometry.length; i++) {
      geometry[i].draw(
        gl, 
        projectionMatrix, 
        viewMatrix, 
        light
      );
    }
  }

  draw();

  // la cámara registra su manejador de eventos
  camera.registerMouseEvents(gl.canvas, draw);

});
