$(document).ready(function()
{
  initLoader();
})

function initLoader() {
	var maxSize = 400;
	var step = 20;
  var totalCircles = $("#circleLoader div").length;
  

	var mainTimeline = new TimelineMax({repeat:-1})

	$("#circleLoader div").each(function(ind, elem){
		(ind%2 === 0) ? $(this).addClass("black") : $(this).addClass("white");
		$(this).css({"width": maxSize-(ind*step)+"px", "height" : maxSize-(ind*step)+"px", "top" : -(maxSize-(ind*step))/2+"px", "left" : -(maxSize-(ind*step))/2+"px"});
			
		var timeline = new TimelineMax()
		timeline.append(new TweenMax.to($(this), 1, {css:{ left:-maxSize/2, top:-maxSize/2}}));
		timeline.append(new TweenMax.to($(this), 1, {css:{ left:-maxSize/2+(ind*step)}, ease:Quad.easeInOut}));
		timeline.append(new TweenMax.to($(this), 1, {css:{ left:-maxSize/2+(ind*step), top:-maxSize/2-(ind*step)}, ease:Power1.easeInOut}));
		timeline.append(new TweenMax.to($(this), 1, {css:{ left:-maxSize/2, top:-maxSize/2}, ease:Cubic.easeInOut}));
		timeline.append(new TweenMax.to($(this), 1, {css:{ left:-maxSize/2+(ind*step), top:-maxSize/2+(ind*step)}, ease:Sine.easeInOut}));
		timeline.append(new TweenMax.to($(this), 1, {css:{ left:-maxSize/2-(ind*step)}, ease:Power1.easeInOut}));
		timeline.append(new TweenMax.to($(this), 1, {css:{ left:-maxSize/2+(ind*step), top:-maxSize/2+(ind*step)}, ease:Cubic.easeInOut}));
		timeline.append(new TweenMax.to($(this), 1.5, {css:{ left:-maxSize/2}}));
		timeline.append(new TweenMax.to($(this), 1, {css:{ left:-maxSize/2, top:-maxSize/2}}));
		timeline.append(new TweenMax.to($(this), 1, {css:{ left:-(maxSize-(ind*step))/2, top:-(maxSize-(ind*step))/2}, ease:Quad.easeInOut}));

		mainTimeline.insert(timeline, ind*0.05);
	})
	
	mainTimeline.play();
}