  window.openImage = function(img, w, h) {
    let src;

    if (typeof(img) == "string") {
      src = img;
      w = w || screen.availWidth;
      h = h || screen.availHeight;
    }
    else if (typeof(img) == "object") {
      src = img.src || "about:blank";
      w = w || img.naturalWidth || screen.availWidth;
      h = h || img.naturalHeight || screen.availHeight;
    }
    
    window.open(src, "_blank", `scrollbars=yes,resizable=yes,location=0,titlebar=0,menubar=0,status=0,toolbar=0,left=${(screen.availWidth-w)/2},top=${(screen.availHeight-h)/2},width=${w},height=${h}`);
  }
  
  function addInteractive(pages_container, text_width, interactive_margin) {
  let interactives = pages_container.querySelectorAll(".interactive");
  let i_w;
  let i_h;
  let scale;
  let window_size;
  let new_iframe;
  let btn;
  let pdf_anchor;

  interactives.forEach((inte) => {
    let w = parseInt(inte.getAttribute("width") || 0);
    let h = parseInt(inte.getAttribute("height") || 0);
    let src = inte.getAttribute("src") || "";

    scale = parseInt( inte.getAttribute("scale") || 100 ) / 100;
    window_size = inte.getAttribute("window-size") || false;

    i_w = Math.ceil((text_width-interactive_margin*2)*scale);
    i_h = Math.ceil(i_w*(h/w));

    inte.style.width  = `${i_w + interactive_margin*2}px`;
    inte.style.height = `${i_h + interactive_margin*2}px`;

    if (! (((window.hasOwnProperty) && (window.hasOwnProperty("ontouchstart"))) || ("ontouchstart" in window))) {
      inte.style.overflow = "hidden";
    }

    new_iframe = document.createElement("iframe");
    // new_iframe.addEventListener("load", (evt) => {
    //   console.log("hola", this, evt);
    // });
    // new_iframe.setAttribute("width", i_w);
    // new_iframe.setAttribute("height", i_h);
    new_iframe.style.width  = "100%";
    new_iframe.style.height = "100%";
    new_iframe.setAttribute("data-src", src);
    new_iframe.setAttribute("src", "about:blank");
    if (inte.hasAttribute("poster")) {
      // new_iframe.setAttribute("style", `background-image: url("${inte.getAttribute("poster")}")`);
      new_iframe.style["background-image"] = `url("${inte.getAttribute("poster")}")`;
    }

    btn = document.createElement("button");
    if (window_size) {
      w = window.innerWidth;
      h = window.innerHeight;
    }

    btn.className = "btn_expand";
    // btn.onclick = new Function("", `openInteractive("${src}", ${w}, ${h+40});return 0;`);
    btn.addEventListener("click", function(evt) {
      if (book_config.open_interactives_fullscreen) {
        if(document.fullscreenElement) {
          document.exitFullscreen();
        } else if(document.webkitFullscreenElement) {
          document.webkitExitFullscreen();
        } else if(document.mozFullScreenElement ) {
          document.mozExitFullscreen();
        }
        else {
          if(inte.requestFullscreen) {
            inte.requestFullscreen();
          } else if(inte.mozRequestFullScreen) {
            inte.mozRequestFullScreen();
          } else if(inte.webkitRequestFullscreen) {
            inte.webkitRequestFullscreen();
          } else if(inte.msRequestFullscreen) {
            inte.msRequestFullscreen();
          }
          else {
            openInteractive(src, w, h+40);
          }
        }
      } else {
        openInteractive(src, w, h+40);
      }
    });

    pdf_anchor = document.createElement("a");
    pdf_anchor.setAttribute("class", "PDF_anchor");
    pdf_anchor.setAttribute("href", src);

    inte.appendChild(btn);
    inte.appendChild(new_iframe);
    inte.appendChild(pdf_anchor);
  });
}