var images = [
  {Url: "https://i.imgur.com/KDtWjoA.jpg", Text: "Zoomed frog"},
  {Url: "https://i.imgur.com/189tL2E.jpg", Text: "Two laughing frogs"},
  {Url: "https://i.imgur.com/UdV4xHj.jpg", Text: "Hippo frog"},
  {Url: "https://i.imgur.com/wwbZAeq.jpg", Text: "Blue happy frog"},
  {Url: "https://i.imgur.com/J67C9yD.jpg", Text: "Green moss frog"},
  {Url: "https://i.imgur.com/vMuTFYM.jpg", Text: "Yellow frog"},
  {Url: "https://i.imgur.com/OmKfJXr.jpg", Text: "Flying frog"},
  {Url: "https://i.imgur.com/i5VCBru.jpg", Text: "Mohawk frog"},
  {Url: "https://i.imgur.com/3mOGzxj.jpg", Text: "Leaping frog"},
  {Url: "https://i.imgur.com/w0hdhzY.jpg", Text: "Cave frog"},
  {Url: "https://i.imgur.com/bJacrby.jpg", Text: "Big breath frog"},
  {Url: "https://i.imgur.com/bPr0qKT.jpg", Text: "Nice frog"},
  {Url: "https://i.imgur.com/gRecyjf.jpg", Text: "Smart frog"},
  {Url: "https://i.imgur.com/EXA4lN9.jpg", Text: "Lazy frog"},
  {Url: "https://i.imgur.com/SX1Fm3J.jpg", Text: "Zebra frog"},
  {Url: "https://i.imgur.com/B7fszWY.jpg", Text: "Fat frog"},
  {Url: "https://i.imgur.com/tlKD7BB.jpg", Text: "Dragon frog"},
  {Url: "https://i.imgur.com/mWxZZ1m.jpg", Text: "Another moss frog"},
  {Url: "https://i.imgur.com/fHpX2U1.jpg", Text: "Rave frog"},
  {Url: "https://i.imgur.com/GjC1EIC.jpg", Text: "Many-color frog"},
  {Url: "https://i.imgur.com/zMZerdy.jpg", Text: "Big-head frog"},
  {Url: "https://i.imgur.com/b7vlV39.jpg", Text: "Snake companion frog"},
  {Url: "https://i.imgur.com/ovT9SQw.jpg", Text: "Underneath frog"},
  {Url: "https://i.imgur.com/tlKD7BB.jpg", Text: "Dragon frog"},
  {Url: "https://i.imgur.com/KDtWjoA.jpg", Text: "Zoomed frog"},
  {Url: "https://i.imgur.com/189tL2E.jpg", Text: "Two laughing frogs"},
  {Url: "https://i.imgur.com/UdV4xHj.jpg", Text: "Hippo frog"},
  {Url: "https://i.imgur.com/wwbZAeq.jpg", Text: "Blue happy frog"},
  {Url: "https://i.imgur.com/J67C9yD.jpg", Text: "Green moss frog"},
  {Url: "https://i.imgur.com/vMuTFYM.jpg", Text: "Yellow frog"},
  {Url: "https://i.imgur.com/OmKfJXr.jpg", Text: "Flying frog"},
  {Url: "https://i.imgur.com/i5VCBru.jpg", Text: "Mohawk frog"},
  {Url: "https://i.imgur.com/3mOGzxj.jpg", Text: "Leaping frog"},
  {Url: "https://i.imgur.com/w0hdhzY.jpg", Text: "Cave frog"},
  {Url: "https://i.imgur.com/bJacrby.jpg", Text: "Big breath frog"},
  {Url: "https://i.imgur.com/bPr0qKT.jpg", Text: "Nice frog"},
  {Url: "https://i.imgur.com/gRecyjf.jpg", Text: "Smart frog"},
  {Url: "https://i.imgur.com/EXA4lN9.jpg", Text: "Lazy frog"},
  {Url: "https://i.imgur.com/SX1Fm3J.jpg", Text: "Zebra frog"},
  {Url: "https://i.imgur.com/B7fszWY.jpg", Text: "Fat frog"},
  {Url: "https://i.imgur.com/tlKD7BB.jpg", Text: "Dragon frog"},
  {Url: "https://i.imgur.com/mWxZZ1m.jpg", Text: "Another moss frog"},
  {Url: "https://i.imgur.com/fHpX2U1.jpg", Text: "Rave frog"},
  {Url: "https://i.imgur.com/GjC1EIC.jpg", Text: "Many-color frog"},
  {Url: "https://i.imgur.com/zMZerdy.jpg", Text: "Big-head frog"},
  {Url: "https://i.imgur.com/b7vlV39.jpg", Text: "Snake companion frog"},
  {Url: "https://i.imgur.com/ovT9SQw.jpg", Text: "Underneath frog"},
  {Url: "https://i.imgur.com/tlKD7BB.jpg", Text: "Dragon frog"},
  {Url: "https://i.imgur.com/mWxZZ1m.jpg", Text: "Another moss frog"},
  {Url: "https://i.imgur.com/fHpX2U1.jpg", Text: "Rave frog"},
  {Url: "https://i.imgur.com/GjC1EIC.jpg", Text: "Many-color frog"},
  {Url: "https://i.imgur.com/zMZerdy.jpg", Text: "Big-head frog"},
  {Url: "https://i.imgur.com/b7vlV39.jpg", Text: "Snake companion frog"},
  {Url: "https://i.imgur.com/ovT9SQw.jpg", Text: "Underneath frog"},
  {Url: "https://i.imgur.com/tlKD7BB.jpg", Text: "Dragon frog"},
  {Url: "https://i.imgur.com/KDtWjoA.jpg", Text: "Zoomed frog"},
  {Url: "https://i.imgur.com/189tL2E.jpg", Text: "Two laughing frogs"},
  {Url: "https://i.imgur.com/UdV4xHj.jpg", Text: "Hippo frog"},
  {Url: "https://i.imgur.com/wwbZAeq.jpg", Text: "Blue happy frog"},
  {Url: "https://i.imgur.com/J67C9yD.jpg", Text: "Green moss frog"},
  {Url: "https://i.imgur.com/vMuTFYM.jpg", Text: "Yellow frog"},
  {Url: "https://i.imgur.com/OmKfJXr.jpg", Text: "Flying frog"},
  {Url: "https://i.imgur.com/i5VCBru.jpg", Text: "Mohawk frog"},
  {Url: "https://i.imgur.com/3mOGzxj.jpg", Text: "Leaping frog"},
  {Url: "https://i.imgur.com/w0hdhzY.jpg", Text: "Cave frog"},
  {Url: "https://i.imgur.com/bJacrby.jpg", Text: "Big breath frog"},
  {Url: "https://i.imgur.com/bPr0qKT.jpg", Text: "Nice frog"},
  {Url: "https://i.imgur.com/gRecyjf.jpg", Text: "Smart frog"},
  {Url: "https://i.imgur.com/EXA4lN9.jpg", Text: "Lazy frog"},
  {Url: "https://i.imgur.com/SX1Fm3J.jpg", Text: "Zebra frog"},
  {Url: "https://i.imgur.com/B7fszWY.jpg", Text: "Fat frog"},
  {Url: "https://i.imgur.com/tlKD7BB.jpg", Text: "Dragon frog"},
  {Url: "https://i.imgur.com/mWxZZ1m.jpg", Text: "Another moss frog"},
  {Url: "https://i.imgur.com/fHpX2U1.jpg", Text: "Rave frog"},
  {Url: "https://i.imgur.com/GjC1EIC.jpg", Text: "Many-color frog"},
  {Url: "https://i.imgur.com/zMZerdy.jpg", Text: "Big-head frog"},
  {Url: "https://i.imgur.com/b7vlV39.jpg", Text: "Snake companion frog"},
  {Url: "https://i.imgur.com/ovT9SQw.jpg", Text: "Underneath frog"},
  {Url: "https://i.imgur.com/tlKD7BB.jpg", Text: "Dragon frog"},
  {Url: "https://i.imgur.com/OmKfJXr.jpg", Text: "Flying frog"},
];

var imagesContainer = document.getElementById("images-container");
var footer = document.getElementById("footer");

var size = 23;
var start = 0;
var end = size;


$( document ).ready(function() {

    // Load content first time
    loadContent(start, end, size);
    var loadMoreBtn = document.createElement('button');
    loadMoreBtn.setAttribute("id", "loadMoreBtn");
    loadMoreBtn.textContent = "Load more";
    loadMoreBtn.setAttribute("OnClick","loadMoreButtonClick()");
    footer.appendChild(loadMoreBtn);
    
// Click event for Modal
/*$('a.thumbnailElem').click(function(e) {
    e.preventDefault();

    createImageModal('image-modal', $(this).prop('innerText'), $(this).attr('src'), 'hideModal()', 'Stäng');
});  */
  
$(document).on('click', 'a.thumbnailElem', function(e){
    e.preventDefault();

    createImageModal('image-modal', $(this).prop('innerText'), $(this).attr('src'), 'hideModal()', 'Stäng');
});
  

});



// Scroll Listener
var lastScrollTop = 0, delta = 5;
$(window).scroll(function() {
//console.log('loadContent:' + end + ' ' + images.length);
   if($(window).scrollTop() + $(window).height() > $(document).height() - 60) {
     
     // Load content if there is some
     if (end < images.length) {
       
            ShowHideFooter(false, false);
            start += size;
            end += size;
            loadContent(start, end, size);
     }
     else if (end == images.length) {
         if($(window).scrollTop() + $(window).height() > $(document).height()) {
           var noMoreContent = document.createElement('span')
           noMoreContent.setAttribute('id','noContentText');
           noMoreContent.innerText = "No more content";
           footer.appendChild(noMoreContent);
           ShowHideFooter(true,false);
        }
     }
   }
 
  // Detect scroll direction
  var st = $(this).scrollTop();

  if(Math.abs(lastScrollTop - st) <= delta)
    return;

  if (st > lastScrollTop){
    // downscroll code
    
  } else {
    // upscroll code
    var elem = document.getElementById('noContentText');
    if (elem != null){
      elem.parentNode.removeChild(elem);
      ShowHideFooter(false, false);
    }
  }
  lastScrollTop = st;
});

function loadContent(start, end, size){
        var rowSize = end - start;
        for (var i = start; i < end; i++) {
          var thumbnailWrapper = document.createElement("div");
          thumbnailWrapper.className = "thumbnail-wrapper row" + start;

          var thumbnail = document.createElement("a");
          thumbnail.className = "thumbnailElem";
          thumbnail.setAttribute('style', 'background-image:url(\"' +   images[i].Url + '\");');
          thumbnail.setAttribute('src', images[i].Url);

          var textContainer = document.createElement("div");
          textContainer.className = "text-wrapper";

          var imageText = document.createElement("span");
          imageText.className = "image-text";
          imageText.innerHTML = images[i].Text;

          thumbnailWrapper.appendChild(thumbnail);
          thumbnail.appendChild(textContainer);
          textContainer.appendChild(imageText);
          imagesContainer.appendChild(thumbnailWrapper);
            
  }
}

function createImageModal(placementId, heading, imagesSrc)
{
    var html =  '<div id="modalWindow" class="modal fade" tabindex="-1" role="dialog">';
    html += '<div class="modal-dialog modal-lg">';
    html += '<div class="modal-content">';
    html += '<div class="modal-header">';
    html += '<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">x</span></button>';
    if (heading === undefined){
      html += '<div id="modalTitle" class="modal-title">No title</div>'
    }
    else {
      html += '<div id="modalTitle" class="modal-title">'+heading+'</div>'
    }
    html += '</div>'; // header
    html += '<div class="modal-body">';
    html += '<img class="img-responsive center-block" src="'+imagesSrc+'" alt="">'
    html += '</div>';
    html += '<div class="modal-footer">';
    html += '<a class="imageLink" href="'+imagesSrc+'"target="_blank">'+imagesSrc+'</a>'
    html += '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>';
    html += '</div>';  // footer
    html += '</div>';  // content
    html += '</div>';  // dialog
    html += '</div>';  // modalWindow
    $("#"+placementId).html(html);
    $("#modalWindow").modal();
}


function hideModal()
{
    // Using a very general selector - this is because $('#modalDiv').hide
    // will remove the modal window but not the mask
    $('.modal.in').modal('hide');
}

function loadMoreButtonClick(){
    start += size;
    end += size;
    loadContent(start, end, size);
    ShowHideFooter(false,false);
}

function ShowHideFooter(fo ,btn){
  if (fo == true){
    $('#footer').fadeIn();
  }
  else{
    $('#footer').fadeOut(100);
  }
  if(btn == true){
        $('#loadMoreBtn').fadeIn();
     }
  else{
        $('#loadMoreBtn').fadeOut(200);
     }
}