/*
 * Decompiled with CFR 0.152.
 */
package com.mja.algebra;

import com.mja.algebra.mjaLabel;
import com.mja.gui.mjaLayout;
import com.mja.util.BasicStr;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.util.StringTokenizer;
import java.util.Vector;
import org.unam.matem.Attribute;

public class RandomNumber {
    private static final String[] dec_options = new String[]{"0", "1", "2", "3", "4", "5"};
    private String name;
    private double value;
    private int decimals;
    private double min;
    private double max;
    private boolean allowNegatives;
    private Panel editPanel;
    private TextField tf_name;
    private TextField tf_min;
    private TextField tf_max;
    private Choice ch_dec;
    private Checkbox cb_allowNegatives;

    public RandomNumber(String string, double d, double d2, int n, boolean bl) {
        this.name = string;
        this.min = d;
        this.max = d2;
        this.decimals = n;
        this.allowNegatives = bl;
        this.value = RandomNumber.random(this.min, this.max, this.decimals, this.allowNegatives);
    }

    public RandomNumber(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.min = BasicStr.parseDouble((String)string2, (double)0.0, (double)0.0);
        this.max = BasicStr.parseDouble((String)string3, (double)9.0, (double)9.0);
        this.decimals = BasicStr.parseInteger((String)string4, (int)0, (int)0);
        this.allowNegatives = false;
        if (string5 != null) {
            this.allowNegatives |= string5.startsWith("t");
            this.allowNegatives |= string5.startsWith("y");
            this.allowNegatives |= string5.startsWith("s");
        }
        this.recalculate();
    }

    public void recalculate() {
        this.value = RandomNumber.random(this.min, this.max, this.decimals, this.allowNegatives);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public boolean allowNegatives() {
        return this.allowNegatives;
    }

    public double getValue() {
        return this.value;
    }

    public String getStrValue(boolean bl) {
        return BasicStr.DoubleToString((double)this.value, (int)this.decimals, (boolean)bl);
    }

    public String getStrValue() {
        return this.getStrValue(false);
    }

    public String getName() {
        return this.name;
    }

    public static double random(double d, double d2, int n, boolean bl) {
        int n2 = (int)Math.round(Math.pow(10.0, Math.max(0, Math.min(8, n))));
        double d3 = (d2 - d) * Math.random() + d;
        d3 = (double)((int)Math.floor(d3 * (double)n2)) / (double)n2;
        if (bl && Math.random() < 0.5) {
            d3 = -d3;
        }
        return d3;
    }

    public Component getVisualComponent() {
        if (this.editPanel == null) {
            this.editPanel = new Panel(new FlowLayout(0, 0, 0));
            this.tf_name = new TextField(1);
            this.tf_min = new TextField(1);
            this.tf_max = new TextField(1);
            this.ch_dec = new Choice();
            for (int i = 0; i < dec_options.length; ++i) {
                this.ch_dec.addItem(dec_options[i]);
            }
            this.cb_allowNegatives = new Checkbox("");
            this.tf_name.setText(this.name);
            this.tf_min.setText(BasicStr.DoubleToString((double)this.min, (int)this.decimals, (boolean)false));
            this.tf_max.setText(BasicStr.DoubleToString((double)this.max, (int)this.decimals, (boolean)false));
            this.ch_dec.select(String.valueOf(this.decimals));
            this.cb_allowNegatives.setState(this.allowNegatives);
            this.editPanel.add(mjaLayout.pair((double)0.0, (double)1.0, (Component)((Object)new mjaLabel("nombre", 2, 2)), (Component)this.tf_name));
            this.editPanel.add(mjaLayout.pair((double)0.0, (double)1.0, (Component)((Object)new mjaLabel("m\u00ednimo", 2, 2)), (Component)this.tf_min));
            this.editPanel.add(mjaLayout.pair((double)0.0, (double)1.0, (Component)((Object)new mjaLabel("m\u00e1ximo", 2, 2)), (Component)this.tf_max));
            this.editPanel.add(mjaLayout.pair((double)0.0, (double)1.0, (Component)((Object)new mjaLabel("decimales", 2, 2)), (Component)this.ch_dec));
            this.editPanel.add(mjaLayout.pair((double)1.0, (double)0.0, (Component)((Object)new mjaLabel("permitir negativos", 2, 2)), (Component)this.cb_allowNegatives));
        }
        return this.editPanel;
    }

    public void updateFromControls() {
        this.name = this.tf_name.getText();
        this.min = BasicStr.parseDouble((String)this.tf_min.getText(), (double)0.0, (double)0.0);
        this.max = BasicStr.parseDouble((String)this.tf_max.getText(), (double)9.0, (double)9.0);
        this.decimals = BasicStr.parseInteger((String)this.ch_dec.getSelectedItem(), (int)0, (int)0);
        this.allowNegatives = this.cb_allowNegatives.getState();
        this.value = RandomNumber.random(this.min, this.max, this.decimals, this.allowNegatives);
    }

    public String toString() {
        String string = "no";
        if (this.allowNegatives) {
            string = "si";
        }
        String string2 = BasicStr.DoubleToString((double)this.min, (int)this.decimals, (boolean)false);
        String string3 = BasicStr.DoubleToString((double)this.max, (int)this.decimals, (boolean)false);
        String string4 = "(" + this.name + "," + string2 + "," + string3 + "," + this.decimals + "," + string + ")";
        return string4;
    }

    public String toString(boolean bl) {
        if (bl) {
            String string = "no";
            if (this.allowNegatives) {
                string = "si";
            }
            String string2 = BasicStr.DoubleToString((double)this.min, (int)this.decimals, (boolean)false);
            String string3 = BasicStr.DoubleToString((double)this.max, (int)this.decimals, (boolean)false);
            String string4 = "variable nombre=" + this.name + " rango=[" + string2 + "," + string3 + "]";
            if (this.decimals > 0) {
                string4 = string4 + " decimales=" + this.decimals;
            }
            if (this.allowNegatives) {
                string4 = string4 + " negativos=" + string;
            }
            return string4;
        }
        return this.toString();
    }

    public static RandomNumber[] parseRandomVariables(String string) {
        Object object;
        String[] stringArray = BasicStr.toStrArr((String)string);
        Vector<RandomNumber> vector = new Vector<RandomNumber>();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object2;
            if (!stringArray[i].startsWith("variable ")) continue;
            object = stringArray[i].substring(9);
            Attribute[] attributeArray = Attribute.parse((String)object);
            String string2 = Attribute.getValue((Attribute[])attributeArray, (String)"nombre");
            String string3 = Attribute.getValue((Attribute[])attributeArray, (String)"rango");
            String string4 = "1";
            String string5 = "9";
            if (BasicStr.hasContent((String)string3) && ((StringTokenizer)(object2 = new StringTokenizer(string3, "[,]"))).countTokens() == 2) {
                string4 = ((StringTokenizer)object2).nextToken();
                string5 = ((StringTokenizer)object2).nextToken();
            }
            object2 = Attribute.getValue((Attribute[])attributeArray, (String)"decimales");
            String string6 = Attribute.getValue((Attribute[])attributeArray, (String)"negativos");
            vector.addElement(new RandomNumber(string2, string4, string5, (String)object2, string6));
        }
        object = new RandomNumber[vector.size()];
        for (int i = 0; i < ((RandomNumber[])object).length; ++i) {
            object[i] = (RandomNumber)vector.elementAt(i);
        }
        return object;
    }
}

