/*
 * Decompiled with CFR 0.152.
 */
package com.mja.math;

import com.mja.math.R2;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.util.BasicStr;

public class R2Newton {
    static double delta = 1.0E-12;
    private Parser P;
    private Node F;
    private Node X;
    private Node Y;
    private double f0;
    private R2 normal;
    static final int igual = 0;
    static final int menor = -1;
    static final int mayor = 1;
    private int signo = 0;

    public R2Newton(Parser parser, Node node) throws Exception {
        this.P = parser;
        this.F = node;
        if (node.getStr() != null) {
            this.init("_Eval_(" + node.getStr() + ")");
        } else if (node.getSymbol().equals("=") || node.getSymbol().equals("<") || node.getSymbol().equals("<=") || node.getSymbol().equals(">=") || node.getSymbol().equals(">")) {
            this.signo = node.getSymbol().equals("<") || node.getSymbol().equals("<=") ? -1 : (node.getSymbol().equals(">") || node.getSymbol().equals(">=") ? 1 : 0);
            node.equalToMinus();
            this.X = parser.Var("x");
            this.Y = parser.Var("y");
        }
    }

    private void init(String string) throws Exception {
        boolean bl;
        block6: {
            bl = false;
            if (BasicStr.hasContent(string)) {
                try {
                    this.F = this.P.Analyse(string);
                    if (this.F.getSymbol().equals("=")) {
                        this.F.equalToMinus();
                        this.X = this.P.Var("x");
                        this.Y = this.P.Var("y");
                        break block6;
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            System.out.println("R2Newton(" + string + ")");
            Exception exception = new Exception("\"" + string + "\"" + " is not a formula");
            throw exception;
        }
    }

    public R2Newton(Parser parser, String string) throws Exception {
        this.P = parser;
        this.init(string);
    }

    public R2 getUnitNormal() {
        this.normal.normalize();
        return this.normal.copy();
    }

    public boolean rangeOK() {
        return this.F.rangeOK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R2 gradient(R2 r2) throws Exception {
        R2 r22 = new R2(0.0, 0.0);
        Node node = this.X;
        synchronized (node) {
            Node node2 = this.Y;
            synchronized (node2) {
                double d = this.X.getDouble();
                double d2 = this.Y.getDouble();
                this.X.setDouble(r2.x);
                this.Y.setDouble(r2.y);
                this.f0 = this.F.Evaluate(this.F, true);
                this.X.setDouble(this.X.getDouble() + delta);
                double d3 = this.F.Evaluate(this.F, true);
                r22.x = (d3 - this.f0) / delta;
                this.X.setDouble(this.X.getDouble() - delta);
                this.Y.setDouble(this.Y.getDouble() + delta);
                d3 = this.F.Evaluate(this.F, true);
                r22.y = (d3 - this.f0) / delta;
                this.X.setDouble(d);
                this.Y.setDouble(d2);
            }
        }
        return r22;
    }

    public R2 findZero(R2 r2, double d) throws Exception {
        R2 r22 = r2.copy();
        double d2 = this.X.getDouble();
        double d3 = this.Y.getDouble();
        this.X.setDouble(r2.x);
        this.Y.setDouble(r2.y);
        this.f0 = this.F.Evaluate(this.F, true);
        if (this.signo == -1 && this.f0 <= 0.0) {
            return r22;
        }
        if (this.signo == 1 && this.f0 >= 0.0) {
            return r22;
        }
        this.X.setDouble(d2);
        this.Y.setDouble(d3);
        for (int i = 0; i < 16; ++i) {
            double d4 = r22.x;
            double d5 = r22.y;
            this.normal = this.gradient(r22);
            this.normal.mul(-this.f0 / this.normal.norm2());
            r22.x = d4 + this.normal.x;
            r22.y = d5 + this.normal.y;
            if (!(this.normal.norm() < d)) continue;
            if (this.normal.x == 0.0 && this.normal.y == 0.0) {
                this.normal.x = r22.x - r2.x;
                this.normal.y = r22.y - r2.y;
            }
            return r22;
        }
        throw new Exception("Zero not found.");
    }
}

