/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Descartes;
import com.mja.descartes.Space;
import com.mja.descartes.SpaceR2;
import com.mja.descartes.graphR2Config;
import com.mja.descartes.imageThread;
import com.mja.descartes.parametrization;
import com.mja.descgui.mjaGui;
import com.mja.file.mjaFile;
import com.mja.file.mjaFont;
import com.mja.gui.mjaColor;
import com.mja.math.R2;
import com.mja.math.R2Newton;
import com.mja.parser.Node;
import com.mja.text.MathText;
import com.mja.util.BasicStr;
import com.mja.util.TFont;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextField;

public class mjaGraph {
    Descartes D;
    graphR2Config gc;
    int size = 2;
    parametrization sparz;
    JTextField TF;
    imageThread ith;
    Image image;
    private static final double dosPi = Math.PI * 2;
    private static final double Pim = 1.5707963267948966;
    private static final double MAX_INT = 32767.0;
    private static final double epsilon = 1.0E-4;
    private static final int segment = 0;
    private static final int equation = 1;
    private static final int curve = 2;
    private static final int sequence = 3;
    private static final int line = 4;
    private static final int conic = 5;
    private static final int funcOfX = 6;
    private static final int funcOfY = 7;
    private int eqType;
    private int width = -1;
    private int arrow_width = -1;
    private int spear = -1;
    private Node decimals;
    private Node cond;
    private Node N_width;
    private Node N_size;
    private Node N_rotini;
    private parametrization tparz;
    private MathText mthtxt = null;
    private static final String[] lineEq = new String[]{"y=m*x+b", "x=m*y+a", "A*x+B*y=C"};
    private static final String[] conicEq = new String[]{"e=sqrt((x-Fx)^2+(y-Fy)^2)/(d+(x-Fx)*cos(t)+(y-Fy)*sen(t))", "e=sqrt((x-Fx)^2+(y-Fy)^2)/(d-((x-Fx)*(Dx-Fx)+(y-Fy)*(Dy-Fy))/d)"};
    private Node F;
    private Node fx;
    private Node fy;
    private int caso;
    private int w;
    private int h;
    private int Fx;
    private int Fy;
    private int x;
    private int y;
    private int z;
    private int dx;
    private int zx;
    private int zxx;
    private int dy;
    private int zy;
    private int zyy;
    private int zxy;
    private Node x1;
    private Node y1;
    private Node x2;
    private Node y2;
    private Node r;
    private Node aN;
    private Node daN;
    private Node Si;
    private Node Sf;
    private Node iniX;
    private Node iniY;
    private Node iniRot;
    private Node fileN;
    private Node[] xNa;
    private Node[] yNa;
    private boolean directedAngle = false;
    private boolean useVectors = false;
    private boolean inited = false;
    private String[] text_sa;
    SpaceR2 cs;
    private double X0;
    private double Y0;
    private double X1;
    private double Y1;
    private double XR;
    private double YR;
    private double X1R;
    private double Y1R;
    private double A;
    private double Xini;
    private double Yini;
    private double Cini;
    private double Sini;
    static double vez = 0.0;
    static double c1;
    static double c2;
    static double c3;
    static double c4;

    public mjaGraph(Descartes descartes, int n) {
        Object object;
        this.D = descartes;
        this.gc = descartes.cfg.allgR2c[n];
        if (this.gc.type != 61 && this.gc.type != 62 && this.gc.type != 28 && this.gc.type != 66) {
            this.eqType = 0;
            if (BasicStr.hasContent(this.gc.file)) {
                object = this.gc.file.toLowerCase();
                if (((String)object).endsWith(".gif") || ((String)object).endsWith(".jpg") || ((String)object).endsWith(".png") || ((String)object).endsWith(".bmp") || ((String)object).endsWith(".jpeg")) {
                    this.image = mjaFile.loadImage(descartes.imagesHT, descartes, this.gc.file);
                }
                if (this.image == null) {
                    try {
                        this.fileN = descartes.p.Analyse(this.gc.file);
                    }
                    catch (Exception exception) {
                        this.fileN = new Node(descartes.p, this.gc.file);
                    }
                }
            }
        }
        if ((object = descartes.scene.getSpace(0, this.gc.getSpace())) instanceof SpaceR2) {
            this.cs = (SpaceR2)object;
        }
    }

    void initialize() {
        this.gc.analyseColors(this.D.p);
        if (this.cs != null) {
            this.cond = this.D.p.Analyse(this.gc.getCondition(), "1");
            this.decimals = this.D.p.Analyse(this.gc.s_decimals, 2.0);
            this.N_size = this.D.p.Analyse(this.gc.s_size);
            this.size = (int)Math.round(this.N_size.Evaluate(2.0));
            this.N_width = this.D.p.Analyse(this.gc.s_width);
            this.width = (int)Math.round(this.N_width.Evaluate(1.0));
            if (BasicStr.hasContent(this.gc.text)) {
                boolean bl;
                boolean bl2 = bl = this.gc.text.indexOf("{\\rtf") >= 0;
                if (this.gc.type == 63 && !bl || this.width >= 20) {
                    this.text_sa = new String[1];
                    this.text_sa[0] = this.gc.text;
                } else {
                    this.mthtxt = new MathText(this.D.p, this.D.Tr, this.gc.text, this.decimals, this.gc.fixed, this.gc.font, this.gc.gcolor.getAdaptedColor());
                }
            }
            this.N_rotini = this.D.p.Analyse(this.gc.getRotation());
            this.arrow_width = BasicStr.parseInteger(this.gc.s_arrow_w, 1, 1);
            this.spear = BasicStr.parseInteger(this.gc.s_spear, 5, this.spear);
            if (this.gc.isFamily) {
                this.sparz = new parametrization(this.D.p, this.gc.fparam, this.gc.f_interval, this.gc.f_steps);
            }
            if (BasicStr.hasContent(this.gc.parameter)) {
                this.tparz = new parametrization(this.D.p, this.gc.parameter, this.gc.p_interval, this.gc.p_steps);
            }
            if (this.gc.type == 61 || this.gc.type == 62 || this.gc.type == 28) {
                this.analyse();
            } else if (this.gc.type == 66) {
                Object object;
                this.eqType = 0;
                this.xNa = new Node[1];
                this.yNa = new Node[1];
                try {
                    object = BasicStr.getTokens(this.gc.s_center);
                    this.xNa[0] = this.D.p.Analyse(object[0]);
                    this.yNa[0] = this.D.p.Analyse(object[1]);
                }
                catch (Exception exception) {
                    System.out.println("bad expression " + this.gc.s_center);
                }
                this.r = this.D.p.Analyse(this.gc.s_radius);
                object = this.gc.s_ini;
                if (((String)object).startsWith("_(") || ((String)object).startsWith("_[")) {
                    this.directedAngle = true;
                    object = ((String)object).substring(1);
                }
                if (((String)object).startsWith("[") || ((String)object).startsWith("(")) {
                    try {
                        String[] stringArray = BasicStr.getTokens((String)object);
                        this.x1 = this.D.p.Analyse(stringArray[0]);
                        this.y1 = this.D.p.Analyse(stringArray[1]);
                        stringArray = BasicStr.getTokens(this.gc.s_end);
                        this.x2 = this.D.p.Analyse(stringArray[0]);
                        this.y2 = this.D.p.Analyse(stringArray[1]);
                    }
                    catch (Exception exception) {
                        System.out.println("bad expression " + this.gc.s_center);
                    }
                } else {
                    this.aN = this.D.p.Analyse((String)object);
                    this.daN = this.D.p.Analyse("(" + this.gc.s_end + ")-(" + (String)object + ")");
                }
            } else {
                this.eqType = 0;
                try {
                    String[] stringArray = BasicStr.getTokens(this.gc.formula);
                    int n = stringArray.length / 2;
                    int n2 = 0;
                    this.xNa = new Node[n];
                    this.yNa = new Node[n];
                    for (int i = 0; i < n; ++i) {
                        this.xNa[i] = this.D.p.Analyse(stringArray[n2++]);
                        this.yNa[i] = this.D.p.Analyse(stringArray[n2++]);
                    }
                }
                catch (Exception exception) {
                    System.out.println("bad expression " + this.gc.formula);
                }
            }
            try {
                String[] stringArray = BasicStr.getTokens(this.gc.s_location);
                if (stringArray.length == 2) {
                    this.iniX = this.D.p.Analyse(stringArray[0]);
                    this.iniY = this.D.p.Analyse(stringArray[1]);
                }
                this.iniRot = this.D.p.Analyse(this.gc.s_rotation);
            }
            catch (Exception exception) {
                System.out.println("bad expression " + this.gc.s_location);
            }
        }
        this.inited = true;
    }

    void analyse() {
        block15: {
            if (this.cs != null) {
                if (this.gc.type != 61) {
                    try {
                        String[] stringArray = BasicStr.getTokens(this.gc.formula);
                        int n = 0;
                        if (stringArray.length <= 1) break block15;
                        if (this.gc.type == 28) {
                            this.eqType = 3;
                            this.Si = this.D.p.Analyse("1");
                            this.Sf = this.D.p.Analyse("100");
                            try {
                                String[] stringArray2 = BasicStr.getTokens(this.gc.seqRange);
                                int n2 = 0;
                                if (stringArray2.length > 1) {
                                    this.Si = this.D.p.Analyse(stringArray2[n2++].trim());
                                    this.Sf = this.D.p.Analyse(stringArray2[n2++].trim());
                                }
                            }
                            catch (Exception exception) {}
                        } else {
                            this.eqType = 2;
                        }
                        this.fx = this.D.p.Analyse(stringArray[n++]);
                        this.fy = this.D.p.Analyse(stringArray[n++]);
                        return;
                    }
                    catch (Exception exception) {}
                } else {
                    String string;
                    int n;
                    for (n = 0; n < lineEq.length; ++n) {
                        if (!this.gc.formula.equals(lineEq[n])) continue;
                        this.eqType = 4;
                        return;
                    }
                    for (n = 0; n < conicEq.length; ++n) {
                        if (!this.gc.formula.equals(conicEq[n])) continue;
                        this.eqType = 5;
                        return;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(this.gc.formula, "=");
                    if (stringTokenizer.hasMoreTokens() && ((string = stringTokenizer.nextToken()).equals("y") || string.equals("x"))) {
                        this.F = this.D.p.Analyse(this.gc.formula.substring(this.gc.formula.indexOf(61) + 1, this.gc.formula.length()).trim());
                        if (string.equals("y") && !this.F.contains("y")) {
                            this.eqType = 6;
                            return;
                        }
                        if (string.equals("x") && !this.F.contains("x")) {
                            this.eqType = 7;
                            return;
                        }
                    }
                    this.eqType = 1;
                }
            }
        }
    }

    private R2 TR(R2 r2) {
        return new R2(this.Xini + this.Cini * r2.x - this.Sini * r2.y, this.Yini + this.Sini * r2.x + this.Cini * r2.y);
    }

    void draw(Image image, Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        if (this.inited) {
            this.width = (int)Math.round(this.N_width.Evaluate(1.0));
            this.size = (int)Math.round(this.N_size.Evaluate(2.0));
            if (this.cs != null) {
                double d = this.cond.Evaluate(1.0);
                if (d < 1.0 && this.ith != null) {
                    this.ith.pleaseStop();
                    this.ith = null;
                }
                if (d > 0.0 || this.eqType == 6 || this.eqType == 7) {
                    int n;
                    int n2;
                    for (n2 = 0; n2 < graphicsArray.length; ++n2) {
                        graphicsArray[n2].setColor(mjaColorArray[n2].getAdaptedColor());
                    }
                    if (this.iniX != null && this.iniY != null) {
                        this.Xini = this.iniX.Evaluate(0.0);
                        this.Yini = this.iniY.Evaluate(0.0);
                    } else {
                        this.Xini = 0.0;
                        this.Yini = 0.0;
                    }
                    if (this.iniRot != null) {
                        this.A = this.iniRot.Evaluate(0.0);
                        this.Cini = Math.cos(Math.PI * this.A / 180.0);
                        this.Sini = Math.sin(Math.PI * this.A / 180.0);
                    } else {
                        this.A = 0.0;
                        this.Cini = 1.0;
                        this.Sini = 0.0;
                    }
                    if (this.xNa != null && this.xNa.length > 0 && this.xNa[0] != null && this.yNa[0] != null) {
                        this.X0 = this.xNa[0].Evaluate(0.0);
                        this.Y0 = this.yNa[0].Evaluate(0.0);
                    } else {
                        this.X0 = 0.0;
                        this.Y0 = 0.0;
                    }
                    if (this.xNa != null && this.xNa.length > 1 && this.xNa[1] != null && this.yNa[1] != null) {
                        this.X1 = this.xNa[1].Evaluate(0.0);
                        this.Y1 = this.yNa[1].Evaluate(0.0);
                    } else {
                        this.X1 = 0.0;
                        this.Y1 = 0.0;
                    }
                    this.XR = this.Xini + this.Cini * this.X0 - this.Sini * this.Y0;
                    this.YR = this.Yini + this.Sini * this.X0 + this.Cini * this.Y0;
                    this.X1R = this.Xini + this.Cini * this.X1 - this.Sini * this.Y1;
                    this.Y1R = this.Yini + this.Sini * this.X1 + this.Cini * this.Y1;
                    if (BasicStr.antialias) {
                        for (n2 = 0; n2 < graphicsArray.length; ++n2) {
                            BasicStroke basicStroke = new BasicStroke(this.width, 1, 1);
                            ((Graphics2D)graphicsArray[n2]).setStroke(basicStroke);
                            ((Graphics2D)graphicsArray[n2]).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                            ((Graphics2D)graphicsArray[n2]).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                            ((Graphics2D)graphicsArray[n2]).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            ((Graphics2D)graphicsArray[n2]).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                            ((Graphics2D)graphicsArray[n2]).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                            ((Graphics2D)graphicsArray[n2]).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                            ((Graphics2D)graphicsArray[n2]).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                        }
                    } else if (this.width > 1) {
                        for (n2 = 0; n2 < graphicsArray.length; ++n2) {
                            ((Graphics2D)graphicsArray[n2]).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        }
                    } else {
                        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 1);
                        for (int i = 0; i < graphicsArray.length; ++i) {
                            ((Graphics2D)graphicsArray[i]).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                            ((Graphics2D)graphicsArray[i]).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                            ((Graphics2D)graphicsArray[i]).setStroke(basicStroke);
                        }
                    }
                    for (n = 0; n < graphicsArray.length; ++n) {
                        Graphics2D graphics2D = (Graphics2D)graphicsArray[n];
                        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1);
                        graphics2D.setStroke(basicStroke);
                    }
                    switch (this.eqType) {
                        case 0: {
                            this.drawSegment(image, graphicsArray, mjaColorArray);
                            break;
                        }
                        case 2: {
                            this.drawCurve(graphicsArray, mjaColorArray);
                            break;
                        }
                        case 3: {
                            this.drawSequence(graphicsArray, mjaColorArray);
                            break;
                        }
                        case 4: {
                            this.drawLine(graphicsArray);
                            break;
                        }
                        case 5: {
                            this.drawConic(graphicsArray);
                            break;
                        }
                        case 6: {
                            this.drawFunction(graphicsArray, mjaColorArray, false);
                            break;
                        }
                        case 7: {
                            this.drawFunction(graphicsArray, mjaColorArray, true);
                            break;
                        }
                        case 1: {
                            this.drawEquation(graphicsArray, mjaColorArray);
                        }
                    }
                    if (this.width > 1 && !BasicStr.antialias) {
                        for (n = 0; n < graphicsArray.length; ++n) {
                            ((Graphics2D)graphicsArray[n]).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        }
                    }
                }
            }
        }
    }

    static void Arc(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 < 0) {
            n5 += n6;
            n6 = -n6;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        BasicStroke basicStroke = new BasicStroke(n, 1, 1);
        graphics2D.setStroke(basicStroke);
        graphics2D.drawArc(n2 - n4, n3 - n4, 2 * n4, 2 * n4, n5, n6);
        basicStroke = new BasicStroke(1.0f);
        graphics2D.setStroke(basicStroke);
    }

    static void circle(Graphics graphics, int n, int n2, double d) {
        if (d > 0.0) {
            if (d > 1.4) {
                graphics.fillOval(n - (int)Math.round(d), n2 - (int)Math.round(d), (int)Math.round(2.0 * d), (int)Math.round(2.0 * d));
            } else {
                graphics.drawLine(n, n2, n, n2);
            }
        }
    }

    static void drawPolygon(Graphics[] graphicsArray, int n, Polygon polygon, boolean bl, Color color) {
        Object object;
        int n2;
        if (bl) {
            for (n2 = 0; n2 < graphicsArray.length; ++n2) {
                object = graphicsArray[n2].getColor();
                graphicsArray[n2].setColor(color);
                graphicsArray[n2].fillPolygon(polygon);
                graphicsArray[n2].setColor((Color)object);
            }
        }
        if (n > 0) {
            for (n2 = 0; n2 < graphicsArray.length; ++n2) {
                object = (Graphics2D)graphicsArray[n2];
                BasicStroke basicStroke = new BasicStroke(n, 1, 1);
                ((Graphics2D)object).setStroke(basicStroke);
                ((Graphics)object).drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
                basicStroke = new BasicStroke(1.0f);
                ((Graphics2D)object).setStroke(basicStroke);
            }
        }
    }

    private void Line(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.Line(graphics, n, n2, n3, n4, n5, false);
    }

    private void Line(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (n > 0) {
            int n6 = this.cs.getSize().height;
            Graphics2D graphics2D = (Graphics2D)graphics;
            BasicStroke basicStroke = new BasicStroke(n, 1, 1);
            graphics2D.setStroke(basicStroke);
            if (bl) {
                graphics2D.drawLine(n3, n6 - n2, n5, n6 - n4);
            } else {
                graphics2D.drawLine(n2, n3, n4, n5);
            }
            basicStroke = new BasicStroke(1.0f);
            graphics2D.setStroke(basicStroke);
        }
    }

    void drawSegment(Image image, Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        block43: {
            block44: {
                int n;
                Cloneable cloneable;
                R2 r2;
                int n2;
                R2 r22;
                block45: {
                    block42: {
                        if (this.gc.type != 66) break block42;
                        this.drawArc(graphicsArray);
                        break block43;
                    }
                    if (this.xNa.length > 2) break block44;
                    r22 = new R2(0.0, 0.0);
                    n2 = 0;
                    this.D.p.Var("_Text_H_").setDouble(n2);
                    try {
                        int n3;
                        R2 r23 = r2 = new R2(this.XR, this.YR);
                        if (this.gc.type == 65 || this.gc.type == 46) {
                            r23 = new R2(this.X1R, this.Y1R);
                        }
                        r2 = this.cs.projection(r2, this.gc.absCoor);
                        r23 = this.cs.projection(r23, this.gc.absCoor);
                        if (this.gc.type == 68) {
                            if (this.fileN != null) {
                                try {
                                    boolean bl = false;
                                    Space space = this.D.scene.getSpaceByPrefix(this.gc.file);
                                    if (space != null) {
                                        if (this.gc.file.endsWith(".back")) {
                                            this.image = space.getBackImage();
                                            bl = true;
                                        } else if (this.gc.file.endsWith(".image")) {
                                            this.image = space.main;
                                            bl = true;
                                        }
                                    }
                                    if (!bl) {
                                        this.fileN.Evaluate();
                                        if (this.fileN.getStr() != null) {
                                            this.image = mjaFile.loadImage(this.D.imagesHT, this.D, this.fileN.getStr());
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (this.gc.isAnimated(this.D.Tr)) {
                                if (this.ith == null) {
                                    this.ith = new imageThread(this.image, this.cs, this.gc.getAnimFreq());
                                }
                                this.ith.setPos(r2.ix(), r2.iy());
                            } else {
                                for (int i = 0; i < graphicsArray.length; ++i) {
                                    if (BasicStr.isJava2()) {
                                        double d = 1.0;
                                        double d2 = 1.0;
                                        n3 = 0;
                                        if (this.X1 != 0.0) {
                                            d = this.X1;
                                            n3 = 1;
                                        }
                                        if (this.Y1 != 0.0) {
                                            d2 = this.Y1;
                                            n3 = 1;
                                        }
                                        cloneable = new AffineTransform();
                                        if (n3 == 0) {
                                            ((AffineTransform)cloneable).translate((double)this.image.getWidth(this.cs) / 2.0, (double)this.image.getHeight(this.cs) / 2.0);
                                        }
                                        ((AffineTransform)cloneable).translate(r2.ix(), r2.iy());
                                        double d3 = -this.N_rotini.Evaluate(0.0);
                                        ((AffineTransform)cloneable).rotate(d3 * (Math.PI / 180));
                                        ((AffineTransform)cloneable).translate((double)(-this.image.getWidth(this.cs)) * d / 2.0, (double)(-this.image.getHeight(this.cs)) * d2 / 2.0);
                                        ((AffineTransform)cloneable).scale(d, d2);
                                        ((Graphics2D)graphicsArray[i]).drawImage(this.image, (AffineTransform)cloneable, this.cs);
                                        continue;
                                    }
                                    graphicsArray[i].drawImage(this.image, r2.ix(), r2.iy(), this.cs);
                                }
                            }
                        } else if (this.gc.type != 46 && (r2.ix() != r23.ix() || r2.iy() != r23.iy())) {
                            for (int i = 0; i < graphicsArray.length; ++i) {
                                this.Line(graphicsArray[i], this.width, r2.ix(), r2.iy(), r23.ix(), r23.iy());
                            }
                        }
                        if (this.gc.type != 63 && this.size > 0) {
                            if (this.gc.type == 46) {
                                for (int i = 0; i < graphicsArray.length; ++i) {
                                    this.drawArrow(graphicsArray[i], this.gc.arrowColor.getAdaptedColor(), this.gc.gcolor.getAdaptedColor(), r2.ix(), r2.iy(), r23.ix(), r23.iy(), this.arrow_width, this.spear);
                                }
                            } else if (this.gc.type == 43) {
                                int n4 = r2.ix();
                                int n5 = r2.iy();
                                n = this.cs.getSize().width;
                                int n6 = this.cs.getSize().height;
                                if (0 <= n4 && 0 <= n5 && n4 < n && n5 < n6) {
                                    BasicStroke basicStroke = new BasicStroke(1.0f, 0, 1);
                                    for (n3 = 0; n3 < graphicsArray.length; ++n3) {
                                        ((Graphics2D)graphicsArray[n3]).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                                        ((Graphics2D)graphicsArray[n3]).setStroke(basicStroke);
                                    }
                                    int[] nArray = mjaGui.grabPixelsFromImage(n, n6, image);
                                    mjaGui.fillShape(graphicsArray, nArray, n, n6, n4, n5);
                                }
                            } else if (this.gc.type != 68) {
                                for (int i = 0; i < graphicsArray.length; ++i) {
                                    if (this.cs.inside(r2)) {
                                        mjaGraph.circle(graphicsArray[i], r2.ix(), r2.iy(), this.size);
                                    }
                                    if (r2.ix() == r23.ix() && r2.iy() == r23.iy() || !this.cs.inside(r23)) continue;
                                    mjaGraph.circle(graphicsArray[i], r23.ix(), r23.iy(), this.size);
                                }
                            }
                        }
                        r22 = this.text_sa != null ? new R2((2 * r2.ix() + r23.ix()) / 3 + 2 + 1, (2 * r2.iy() + r23.iy()) / 3 - 2 - 1) : new R2((2 * r2.ix() + r23.ix()) / 3 + this.width + 1, (2 * r2.iy() + r23.iy()) / 3 - this.width - 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mthtxt == null) break block45;
                    r2 = this.getTextPos(graphicsArray[0], r22, this.gc.type == 63);
                    this.mthtxt.draw((Component)this.cs, r2.ix(), r2.iy(), graphicsArray);
                    break block43;
                }
                if (this.text_sa == null) break block43;
                r2 = this.getTextPos(graphicsArray[0], r22, this.gc.type == 63);
                this.text_sa = this.makeStringArray(this.gc.text, this.width, this.gc.font, graphicsArray[0]);
                for (int i = 0; i < graphicsArray.length; ++i) {
                    graphicsArray[i].setColor(this.gc.gcolor.getAdaptedColor());
                    graphicsArray[i].setFont(this.gc.font);
                    FontMetrics fontMetrics = graphicsArray[i].getFontMetrics();
                    int n7 = fontMetrics.getAscent();
                    n = fontMetrics.getHeight();
                    for (int j = 0; j < this.text_sa.length; ++j) {
                        int n8 = (int)r22.x;
                        int n9 = (int)r22.y + n7 + n2;
                        cloneable = new Point(n8, n9 + this.dy);
                        if (this.gc.hasTextBorder) {
                            mjaFont.drawTextBorder((Graphics2D)graphicsArray[i], this.text_sa[j], (Point)cloneable, this.gc.colorTextBorder.getFullColor());
                            graphicsArray[i].drawString(this.text_sa[j], ((Point)cloneable).x, ((Point)cloneable).y);
                        } else {
                            graphicsArray[i].drawString(this.text_sa[j], ((Point)cloneable).x, ((Point)cloneable).y);
                        }
                        this.D.p.Var("_Text_H_").setDouble(n2 += n);
                    }
                }
                break block43;
            }
            Polygon polygon = new Polygon();
            try {
                for (int i = 0; i < this.xNa.length; ++i) {
                    double d = this.xNa[i].Evaluate();
                    double d4 = this.yNa[i].Evaluate();
                    R2 r2 = this.cs.projection(this.TR(new R2(d, d4)), this.gc.absCoor);
                    polygon.addPoint(r2.ix(), r2.iy());
                }
                mjaGraph.drawPolygon(graphicsArray, this.width, polygon, this.gc.hasFill, this.gc.fillColor.getAdaptedColor());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String[] makeStringArray(String string, int n, Font font, Graphics graphics) {
        n = n < 20 ? 1000000 : n;
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Vector<String> vector = new Vector<String>();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n2 = 0;
        string = BasicStr.replace(string, "\\n", "\n");
        String string5 = this.D.p.evaluateString(string, (int)Math.round(this.decimals.Evaluate(2.0)), this.gc.fixed);
        while (n2 < string5.length()) {
            char c = string5.charAt(n2);
            if (c != '\n' && (c == ' ' || fontMetrics.stringWidth(string2 + c) < n)) {
                string2 = string2 + c;
                if (c == ' ') {
                    string4 = string2;
                    string3 = "";
                } else {
                    string3 = string3 + c;
                }
                ++n2;
                continue;
            }
            if (c == '\n') {
                ++n2;
            }
            if (string4.length() == 0 || c == '\n') {
                string4 = string2;
                string3 = "";
            }
            vector.add(string4);
            string2 = string3;
            string4 = "";
        }
        if (string2.length() > 0) {
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    void drawArc(Graphics[] graphicsArray) {
        R2 r2;
        R2 r22 = new R2(0.0, 0.0);
        try {
            Object object;
            r2 = this.cs.projection(new R2(this.XR, this.YR), this.gc.absCoor);
            int n = (int)Math.round(this.cs.Nesc.getDouble() * this.r.Evaluate());
            if (this.gc.absCoor) {
                n = (int)Math.round(this.r.Evaluate());
            }
            int n2 = 0;
            int n3 = 360;
            if (this.aN != null && this.daN != null) {
                n2 = (int)Math.round(this.A + this.aN.Evaluate());
                n3 = (int)Math.round(this.daN.Evaluate());
                if (this.gc.absCoor) {
                    n2 = -n2;
                    n3 = -n3;
                }
            } else {
                R2 r23 = new R2(1.0, 0.0);
                object = new R2(0.0, 1.0);
                if (this.gc.useVectors) {
                    r23 = this.cs.projection(this.TR(new R2(this.x1.Evaluate() + this.XR, this.y1.Evaluate() + this.YR)), this.gc.absCoor);
                    object = this.cs.projection(this.TR(new R2(this.x2.Evaluate() + this.XR, this.y2.Evaluate() + this.YR)), this.gc.absCoor);
                } else {
                    r23 = this.cs.projection(this.TR(new R2(this.x1.Evaluate(), this.y1.Evaluate())), this.gc.absCoor);
                    object = this.cs.projection(this.TR(new R2(this.x2.Evaluate(), this.y2.Evaluate())), this.gc.absCoor);
                }
                r23.sub(r2);
                ((R2)object).sub(r2);
                r23.normalize();
                ((R2)object).normalize();
                n2 = (int)Math.round(180.0 * Math.asin(-r23.y) / Math.PI);
                double d = r23.dot((R2)object);
                n3 = (int)Math.round(180.0 * Math.acos(d) / Math.PI);
                if (r23.x < 0.0) {
                    n2 = 180 - n2;
                }
                while (n2 < 0) {
                    n2 += 360;
                }
                while (n2 > 360) {
                    n2 -= 360;
                }
                double d2 = r23.det((R2)object);
                if (d2 > 0.0) {
                    n3 = this.directedAngle ? 360 - n3 : -n3;
                }
            }
            if (Math.abs((double)n * (double)n3 * Math.PI / 180.0) >= 1.0 && Math.abs((double)n - r2.norm()) < 4096.0) {
                if (n3 < 0) {
                    n2 += n3;
                    n3 = -n3;
                }
                if (this.gc.hasFill) {
                    for (int i = 0; i < graphicsArray.length; ++i) {
                        object = graphicsArray[i].getColor();
                        graphicsArray[i].setColor(this.gc.fillColor.getAdaptedColor());
                        graphicsArray[i].fillArc(r2.ix() - n, r2.iy() - n, 2 * n, 2 * n, n2, n3);
                        graphicsArray[i].setColor((Color)object);
                    }
                }
                for (int i = 0; i < graphicsArray.length; ++i) {
                    mjaGraph.Arc(graphicsArray[i], this.width, r2.ix(), r2.iy(), n, n2, n3);
                }
            }
            r22 = r2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.mthtxt != null) {
            r2 = this.getTextPos(graphicsArray[0], r22, this.gc.type == 63);
            this.mthtxt.draw((Component)this.cs, r2.ix(), r2.iy(), graphicsArray);
        }
    }

    private R2 getTextPos(Graphics graphics, R2 r2, boolean bl) {
        int n = 0;
        TFont tFont = new TFont(this.gc.font);
        n = -tFont.getAscent();
        if (bl) {
            n = 4;
        }
        return new R2(r2.ix() + this.size, n + r2.iy() - this.size);
    }

    private void drawArrow(Graphics graphics, Color color, Color color2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0) {
            n5 = 6;
        }
        n5 = 2 * ((n5 + 1) / 2);
        if (n6 < 0) {
            n6 = n5;
        }
        n6 = 2 * ((n6 + 1) / 2);
        int n7 = n3 - n;
        int n8 = n4 - n2;
        double d = Math.sqrt(n7 * n7 + n8 * n8);
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = Math.acos((double)n7 / d);
        }
        if (n8 < 0) {
            d2 = Math.PI * 2 - d2;
        }
        graphics.setColor(color);
        graphics.fillPolygon(mjaGraph.flecha(n, n2, n5, n6, d, d2));
        graphics.setColor(color2);
        graphics.drawPolygon(mjaGraph.flecha(n, n2, n5, n6, d, d2));
    }

    private static Polygon flecha(int n, int n2, double d, double d2, double d3, double d4) {
        R2[] r2Array = new R2[]{new R2(-d / 2.0, d / 2.0), new R2(d3 - d - d2, d / 2.0), new R2(d3 - 2.0 * d2, d2 + d / 2.0), new R2(d3, 0.0), new R2(d3 - 2.0 * d2, -d2 - d / 2.0), new R2(d3 - d - d2, -d / 2.0), new R2(-d / 2.0, -d / 2.0)};
        int[] nArray = new int[r2Array.length];
        int[] nArray2 = new int[r2Array.length];
        for (int i = 0; i < r2Array.length; ++i) {
            r2Array[i].rot(-d4);
            nArray[i] = n + (int)Math.round(r2Array[i].x);
            nArray2[i] = n2 - (int)Math.round(r2Array[i].y);
        }
        return new Polygon(nArray, nArray2, r2Array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawCurve(Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        if (this.tparz != null) {
            Node node;
            Node node2 = node = this.D.p.Var(this.tparz.name);
            synchronized (node2) {
                double d = node.getDouble();
                R2 r2 = new R2(0.0, 0.0);
                boolean bl = true;
                int n = (int)Math.round(this.tparz.NN.Evaluate(32.0));
                double d2 = this.tparz.Ni.Evaluate(0.0);
                double d3 = this.tparz.Nf.Evaluate(1.0);
                Polygon polygon = new Polygon();
                double d4 = 0.0;
                double d5 = 0.0;
                boolean bl2 = false;
                for (int i = 0; i <= n; ++i) {
                    boolean bl3 = true;
                    node.setDouble(d2 + (d3 - d2) * (double)i / (double)n);
                    double d6 = 0.0;
                    double d7 = 0.0;
                    try {
                        d6 = this.fx.Evaluate();
                        d7 = this.fy.Evaluate();
                        d4 = d6;
                        d5 = d7;
                    }
                    catch (Exception exception) {
                        bl3 = false;
                    }
                    if (bl3) {
                        R2 r22 = this.cs.projection(this.TR(new R2(d6, d7)), this.gc.absCoor);
                        polygon.addPoint(r22.ix(), r22.iy());
                        bl2 = true;
                        continue;
                    }
                    if (bl2) {
                        mjaGraph.drawPolygon(graphicsArray, this.width, polygon, false, null);
                        if (this.gc.hasFill || !BasicStr.hasContent(this.gc.cond) || this.cond.Evaluate(1.0) > 0.0) {
                            mjaGraph.drawPolygon(graphicsArray, this.width, polygon, this.gc.hasFill, this.gc.fillColor.getAdaptedColor());
                        }
                    }
                    polygon = new Polygon();
                    bl2 = false;
                }
                if (bl2) {
                    mjaGraph.drawPolygon(graphicsArray, this.width, polygon, false, null);
                    if (this.gc.hasFill || !BasicStr.hasContent(this.gc.cond) || this.cond.Evaluate(1.0) > 0.0) {
                        mjaGraph.drawPolygon(graphicsArray, this.width, polygon, this.gc.hasFill, this.gc.fillColor.getAdaptedColor());
                    }
                }
                node.setDouble(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawSequence(Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        Node node;
        int n = (int)Math.round(this.Si.Evaluate(1.0));
        int n2 = (int)Math.round(this.Sf.Evaluate(1.0));
        Node node2 = node = this.D.p.Var("n");
        synchronized (node2) {
            double d = node.getDouble();
            for (int i = n; i <= n2; ++i) {
                node.setDouble(i);
                if (!(this.cond.Evaluate(1.0) > 0.0)) continue;
                try {
                    double d2 = this.fx.Evaluate();
                    double d3 = this.fy.Evaluate();
                    R2 r2 = this.cs.projection(this.TR(new R2(d2, d3)), this.gc.absCoor);
                    for (int j = 0; j < graphicsArray.length; ++j) {
                        graphicsArray[j].setColor(mjaColorArray[j].getAdaptedColor());
                        mjaGraph.circle(graphicsArray[j], r2.ix(), r2.iy(), this.size);
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
            node.setDouble(d);
        }
    }

    private void drawLine(Graphics[] graphicsArray) {
        double d;
        double d2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.gc.formula.equals(lineEq[0])) {
            d2 = this.D.p.rvalue("m");
            d = this.cs.Nesc.getDouble() * this.D.p.rvalue("b");
            n = 0;
            n2 = this.cs.Oy - (int)Math.round(d + d2 * (double)(n - this.cs.Ox));
            n3 = this.cs.getSize().width;
            n4 = this.cs.Oy - (int)Math.round(d + d2 * (double)(n3 - this.cs.Ox));
        }
        if (this.gc.formula.equals(lineEq[1])) {
            d2 = this.D.p.rvalue("m");
            d = this.cs.Nesc.getDouble() * this.D.p.rvalue("a");
            n2 = 0;
            n = this.cs.Ox + (int)Math.round(d2 * (double)(n2 - this.cs.Oy) + d);
            n4 = this.cs.getSize().height;
            n3 = this.cs.Ox + (int)Math.round(d2 * (double)(n4 - this.cs.Oy) + d);
        } else if (this.gc.formula.equals(lineEq[2])) {
            double d3;
            double d4;
            d2 = this.D.p.rvalue("A");
            d = this.D.p.rvalue("B");
            double d5 = this.D.p.rvalue("C");
            if (Math.abs(d) > Math.abs(d2)) {
                d4 = -d2 / d;
                d3 = d5 / d * this.cs.Nesc.getDouble();
                n = 0;
                n2 = this.cs.Oy - (int)Math.round(d3 + d4 * (double)(n - this.cs.Ox));
                n3 = this.cs.getSize().width;
                n4 = this.cs.Oy - (int)Math.round(d3 + d4 * (double)(n3 - this.cs.Ox));
            } else if (Math.abs(d2) > 0.01) {
                d4 = -d / d2;
                d3 = -(d5 / d2) * this.cs.Nesc.getDouble();
                n2 = 0;
                n = this.cs.Ox - (int)Math.round(d3 + d4 * (double)(n2 - this.cs.Oy));
                n4 = this.cs.getSize().height;
                n3 = this.cs.Ox - (int)Math.round(d3 + d4 * (double)(n4 - this.cs.Oy));
            } else {
                return;
            }
        }
        for (int i = 0; i < graphicsArray.length; ++i) {
            this.Line(graphicsArray[i], this.width, n, n2, n3, n4);
        }
    }

    private void drawConic(Graphics[] graphicsArray) {
        double d;
        double d2;
        boolean bl = false;
        this.w = this.cs.getSize().width;
        this.h = this.cs.getSize().height;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 0.0;
        R2 r2 = this.cs.projection(new R2(this.D.p.rvalue("Fx"), this.D.p.rvalue("Fy")), this.gc.absCoor);
        if (this.gc.formula.equals(conicEq[0])) {
            d4 = this.D.p.rvalue("e");
            if (d4 > 20.0) {
                return;
            }
            d3 = this.cs.Nesc.getDouble() * this.D.p.rvalue("d");
            d5 = this.D.p.rvalue("t");
            bl = false;
        } else if (this.gc.formula.equals(conicEq[1])) {
            R2 r22 = this.cs.projection(new R2(this.D.p.rvalue("Dx"), this.D.p.rvalue("Dy")), this.gc.absCoor);
            R2 r23 = this.cs.projection(new R2(this.D.p.rvalue("Px"), this.D.p.rvalue("Py")), this.gc.absCoor);
            d3 = r22.distance(r2);
            d2 = r23.distance(r2);
            d = r23.distance(r22);
            if (d < 0.1 || d2 < 0.1 || d3 < 0.1) {
                return;
            }
            double d6 = r2.y - r22.y;
            double d7 = r2.x - r22.x;
            if (d7 == 0.0) {
                d5 = d6 >= 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            } else {
                d5 = Math.atan(-d6 / d7);
                if (d7 < 0.0) {
                    d5 += Math.PI;
                }
            }
            r23.sub(r2);
            r22.sub(r2);
            d4 = (d3 - r22.dot(r23) / d3) / d2;
            if (d4 < 0.05) {
                return;
            }
            d4 = 1.0 / d4;
            bl = false;
        }
        this.Fx = r2.ix();
        this.Fy = r2.iy();
        this.doDrawConic(graphicsArray, d3, d4, d5);
        if (bl && d4 > 1.0) {
            double d8 = d4 * d4;
            d2 = d3 + d3;
            d = 1.0E16 / d8;
            if ((d8 - 1.0) / d2 > 1.0E-16) {
                d = d8 * d2 / (d8 - 1.0);
            }
            r2.x -= d * Math.cos(d5);
            r2.y += d * Math.sin(d5);
            this.Fx = r2.ix();
            this.Fy = r2.iy();
            this.doDrawConic(graphicsArray, d3, d4, d5 + Math.PI);
        }
    }

    private void Plot(Graphics[] graphicsArray, int n, int n2) {
        for (int i = 0; i < graphicsArray.length; ++i) {
            this.Line(graphicsArray[i], this.width, n, n2, n, n2);
        }
    }

    private void Pon(Graphics[] graphicsArray) {
        switch (this.caso) {
            case 0: {
                this.Plot(graphicsArray, this.Fx + this.x, this.Fy + this.y);
                break;
            }
            case 1: {
                this.Plot(graphicsArray, this.Fx + this.y, this.Fy - this.x);
                break;
            }
            case 2: {
                this.Plot(graphicsArray, this.Fx - this.x, this.Fy - this.y);
                break;
            }
            case 3: {
                this.Plot(graphicsArray, this.Fx - this.y, this.Fy + this.x);
            }
        }
    }

    private void Dx() {
        this.x += this.dx;
        this.z += this.zx;
        this.zx += this.zxx;
        this.zy += this.zxy;
    }

    private void Dy() {
        this.y += this.dy;
        this.z += this.zy;
        this.zy += this.zyy;
        this.zx += this.zxy;
    }

    private void loop(Graphics[] graphicsArray) {
        if (Math.abs(this.z + this.zy) < Math.abs(this.z + this.zx)) {
            this.Dy();
            if (Math.abs(this.z) >= Math.abs(this.z + this.zx)) {
                this.Dx();
            }
        } else {
            this.Dx();
            if (Math.abs(this.z) >= Math.abs(this.z + this.zy)) {
                this.Dy();
            }
        }
        this.Pon(graphicsArray);
    }

    private void doDrawConic(Graphics[] graphicsArray, double d, double d2, double d3) {
        double d4;
        boolean bl = d2 < 1.0;
        boolean bl2 = d2 > 1.0;
        for (d4 = d3; d4 < 0.0; d4 += Math.PI * 2) {
        }
        while (d4 >= Math.PI * 2) {
            d4 -= Math.PI * 2;
        }
        this.caso = 0;
        while (d4 >= 1.5707963267948966) {
            d4 -= 1.5707963267948966;
            ++this.caso;
        }
        if (d4 > 1.5706963267948966) {
            d4 = 0.0;
            this.caso = (this.caso + 1) % 4;
        }
        if (d4 < 1.0E-4) {
            d4 = 0.0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.w;
        int n4 = this.h;
        switch (this.caso) {
            case 0: {
                n = -this.Fx;
                n2 = -this.Fy;
                n3 = this.w - this.Fx;
                n4 = this.h - this.Fy;
                break;
            }
            case 1: {
                n = this.Fy - this.h;
                n2 = -this.Fx;
                n3 = this.Fy;
                n4 = this.w - this.Fx;
                break;
            }
            case 2: {
                n = this.Fx - this.w;
                n2 = this.Fy - this.h;
                n3 = this.Fx;
                n4 = this.Fy;
                break;
            }
            case 3: {
                n = -this.Fy;
                n2 = this.Fx - this.w;
                n3 = this.h - this.Fy;
                n4 = this.Fx;
            }
        }
        double d5 = Math.cos(d4);
        double d6 = -Math.sin(d4);
        double d7 = d * d2 / (1.0 + d2);
        double d8 = d2 * d2 * 32767.0;
        this.x = -((int)Math.round(d7 * d5));
        this.y = -((int)Math.round(d7 * d6));
        int n5 = (int)Math.round(32767.0 - d8 * d5 * d5);
        int n6 = (int)Math.round(32767.0 - d8 * d6 * d6);
        int n7 = -((int)Math.round((d8 *= 2.0) * d5 * d6));
        int n8 = n5 * (this.x + this.x + 1) + n7 * this.y - (int)Math.round((d8 *= d) * d5);
        int n9 = n6 * (this.y + this.y + 1) + n7 * this.x - (int)Math.round(d8 * d6);
        this.zxx = 2 * n5;
        this.zyy = 2 * n6;
        int n10 = this.x;
        int n11 = this.y;
        this.Pon(graphicsArray);
        this.z = 0;
        this.dx = 1;
        this.zx = n8;
        this.dy = 1;
        this.zy = n9;
        this.zxy = n7;
        do {
            this.loop(graphicsArray);
        } while (this.zx <= 0 && this.x <= n3 && (!bl2 || this.y <= n4));
        if (this.zx > 0) {
            this.dy = -1;
            this.zy = this.zyy - this.zy;
            this.zxy = -n7;
            do {
                this.loop(graphicsArray);
            } while (this.x <= n3 && (bl || this.y >= n2) && (!bl || this.zy <= 0));
        }
        this.x = n10;
        this.y = n11;
        this.dx = -1;
        this.zx = this.zxx - n8;
        this.dy = -1;
        this.zy = this.zyy - n9;
        this.zxy = n7;
        this.z = 0;
        do {
            this.loop(graphicsArray);
        } while (this.zy <= 0 && this.y >= n2 && (!bl2 || this.x >= n));
        if (this.zy > 0) {
            this.dx = 1;
            this.zx = this.zxx - this.zx;
            this.zxy = -n7;
            do {
                this.loop(graphicsArray);
            } while (this.x <= n3 && (bl || this.y >= n2) && (!bl || this.zx <= 0));
        }
        if (bl && this.x < n3) {
            this.dx = 1;
            this.dy = 1;
            this.zy = this.zyy - this.zy;
            this.zxy = n7;
            do {
                this.loop(graphicsArray);
            } while (this.zy <= 0 && this.x <= n3 && this.y <= n4);
        }
    }

    static R2 extrapolate(Node node, Node node2, Node node3, Node node4, double d, double d2) {
        double d3 = node2.getDouble();
        double d4 = d2 / 2.0;
        double d5 = 0.0;
        double d6 = d;
        while (Math.abs(d4) > 1.0E-15) {
            double d7 = node2.getDouble();
            double d8 = node2.getDouble() + d4;
            node2.setDouble(d8);
            boolean bl = true;
            try {
                double d9 = d6;
                d6 = node4.Evaluate();
                node3.setDouble(d6);
                if (node.Evaluate(1.0) > 0.0) {
                    R2 r2 = new R2(Math.min(d9, d6), Math.max(d9, d6));
                    int n = 0;
                    n = d2 > 0.0 ? mjaGraph.Singularity(Math.abs(d4), node2, node4, d7, d9, d8, d6, r2) : mjaGraph.Singularity(Math.abs(d4), node2, node4, d8, d6, d7, d9, r2);
                    if (n > 0) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            if (bl) {
                d5 += d4;
            } else {
                node2.setDouble(d7);
            }
            d4 /= 2.0;
        }
        node2.setDouble(d3);
        return new R2(d5 / Math.abs(d2), d6);
    }

    static R2 extrapolateOnSingularity(Node node, Node node2, Node node3, Node node4, double d, double d2) {
        boolean bl;
        double d3 = node2.getDouble();
        double d4 = d2 / 2.0;
        double d5 = 0.0;
        double d6 = d;
        while (Math.abs(d4) > 1.0E-15) {
            node2.setDouble(node2.getDouble() + d4);
            bl = true;
            if (node.Evaluate(1.0) > 0.0) {
                try {
                    double d7 = d6;
                    d6 = node4.Evaluate();
                    node3.setDouble(d6);
                    if (node.Evaluate(1.0) <= 0.0) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (bl) {
                d5 += d4;
            } else {
                node2.setDouble(node2.getDouble() - d4);
            }
            d4 /= 2.0;
        }
        if (d5 == 0.0) {
            d4 = d2 / 2.0;
            d5 = d2;
            d6 = d;
            while (Math.abs(d4) > 1.0E-15) {
                node2.setDouble(node2.getDouble() - d4);
                bl = true;
                if (node.Evaluate(1.0) > 0.0) {
                    try {
                        d6 = node4.Evaluate();
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
                if (bl) {
                    d5 += -d4;
                } else {
                    node2.setDouble(node2.getDouble() + d4);
                }
                d4 /= 2.0;
            }
        }
        node2.setDouble(d3);
        return new R2(d5 / Math.abs(d2), d6);
    }

    static int Singularity(double d, Node node, Node node2, double d2, double d3, double d4, double d5, R2 r2) {
        if (Double.isNaN(d5) || Double.isNaN(d3) || Double.isNaN(r2.y) || Double.isNaN(r2.x)) {
            return 2;
        }
        if (d2 >= d4) {
            return 2;
        }
        double d6 = node.getDouble();
        int n = 0;
        try {
            if (Math.abs(d4 - d2) < 1.0E-15 || Math.abs(d4 - d2) < 1.0E-12 && Math.abs(d5 - d3) > Math.abs(d)) {
                node.setDouble(d6);
                return 1;
            }
            double d7 = (d2 + d4) / 2.0;
            node.setDouble(d7);
            double d8 = Double.NaN;
            try {
                d8 = node2.Evaluate();
            }
            catch (Exception exception) {
                return 2;
            }
            if (Double.isNaN(d8)) {
                return 2;
            }
            if (Math.abs(d5 - d3) > d) {
                double d9 = 1.0E-12;
                node.setDouble(d2 - d9);
                double d10 = node2.Evaluate();
                double d11 = (d3 - d10) / d9;
                node.setDouble(d4 + d9);
                double d12 = node2.Evaluate();
                double d13 = (d12 - d5) / d9;
                double d14 = (d5 - d3) / (d4 - d2);
                if ((Math.abs(d13) < 10.0 || Math.abs(d11) < 10.0) && (d13 >= 0.0 && d11 >= 0.0 || d13 <= 0.0 && d11 <= 0.0) && 4.0 * Math.abs(d13) < Math.abs(d14)) {
                    node.setDouble(d6);
                    return 2;
                }
            }
            if (Double.isNaN(r2.x) || Double.isNaN(r2.y) || Double.isNaN(d8)) {
                return 2;
            }
            if (!(r2.x <= d8) || !(d8 <= r2.y)) {
                node.setDouble(d7);
                r2.x = Math.min(d3, d8);
                r2.y = Math.max(d3, d8);
                int n2 = mjaGraph.Singularity(d / 2.0, node, node2, d2, d3, d7, d8, r2);
                node.setDouble(d4);
                r2.x = Math.min(d5, d8);
                r2.y = Math.max(d5, d8);
                int n3 = mjaGraph.Singularity(d / 2.0, node, node2, d7, d8, d4, d5, r2);
                n = Math.max(n2, n3);
            }
        }
        catch (Exception exception) {
            n = 1;
        }
        node.setDouble(d6);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawFunction(Graphics[] graphicsArray, mjaColor[] mjaColorArray, boolean bl) {
        Node node = this.D.p.Var("x");
        Node node2 = this.D.p.Var("y");
        if (bl) {
            node2 = node;
            node = this.D.p.Var("y");
        }
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                double d = node.getDouble();
                double d2 = node2.getDouble();
                if (this.F.isSequence()) {
                    int n = 0;
                    int n2 = this.cs.getSize().width;
                    if (bl) {
                        n2 = this.cs.getSize().height;
                    }
                    if (this.gc.absCoor) {
                        while (n < n2) {
                            node.setDouble(n);
                            try {
                                double d3 = this.F.Evaluate();
                                if (this.cond.Evaluate(1.0) > 0.0) {
                                    int n3 = Math.round(n);
                                    int n4 = (int)Math.round(d3);
                                    for (int i = 0; i < graphicsArray.length; ++i) {
                                        this.Line(graphicsArray[i], this.width, n3, n4, n3, n4, bl);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n;
                        }
                    } else {
                        if (bl) {
                            n = (int)Math.round(-1.0 - (double)(this.cs.getSize().height - this.cs.Oy) / this.cs.Nesc.getDouble());
                            n2 = (int)Math.round(1.0 + (double)this.cs.Oy / this.cs.Nesc.getDouble());
                        } else {
                            n = (int)Math.round(-1.0 - (double)this.cs.Ox / this.cs.Nesc.getDouble());
                            n2 = (int)Math.round(1.0 + (double)(this.cs.getSize().width - this.cs.Ox) / this.cs.Nesc.getDouble());
                        }
                        while (n < n2) {
                            node.setDouble(n);
                            try {
                                double d4 = this.F.Evaluate();
                                node2.setDouble(d4);
                                if (this.cond.Evaluate(1.0) > 0.0) {
                                    int n5 = bl ? this.cs.getSize().height - this.cs.YY(this.width, n, this.gc.absCoor) : this.cs.XX(this.width, n, this.gc.absCoor);
                                    int n6 = bl ? this.cs.XX(this.width, d4, this.gc.absCoor) : this.cs.YY(this.width, d4, this.gc.absCoor);
                                    for (int i = 0; i < graphicsArray.length; ++i) {
                                        this.Line(graphicsArray[i], this.width, n5, n6, n5, n6, bl);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n;
                        }
                    }
                } else {
                    boolean bl2 = false;
                    int n = 0;
                    R2 r2 = new R2(this.cs.Ox, this.cs.Oy);
                    int n7 = bl ? r2.ix() : r2.iy();
                    int n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    int n11 = 0;
                    double d5 = 1.0 / this.cs.Nesc.getDouble();
                    double d6 = d5 * (double)(bl ? -this.cs.getSize().height + this.cs.Oy : -this.cs.Ox);
                    double d7 = 0.0;
                    if (this.gc.absCoor) {
                        d6 = 0.0;
                        d5 = 1.0;
                    }
                    while (n10 < (bl ? this.cs.getSize().height + 2 : this.cs.getSize().width + 2)) {
                        int n12;
                        boolean bl3;
                        block48: {
                            bl3 = true;
                            n12 = 0;
                            node.setDouble(d6);
                            try {
                                double d8 = this.F.Evaluate();
                                node2.setDouble(d8);
                                if (this.cond.Evaluate(1.0) > 0.0) {
                                    if (bl2) {
                                        int n13;
                                        int n14;
                                        double d9;
                                        double d10 = Math.min(d7, d8);
                                        R2 r22 = new R2(d10, d9 = Math.max(d7, d8));
                                        n12 = mjaGraph.Singularity(d5, node, this.F, d6 - d5, d7, d6, d8, r22);
                                        if (n12 == 0) {
                                            if (d7 <= d8) {
                                                d7 = r22.x;
                                                d8 = r22.y;
                                            } else {
                                                d8 = r22.x;
                                                d7 = r22.y;
                                            }
                                            int n15 = n14 = bl ? this.cs.XX(this.width, d7, this.gc.absCoor) : this.cs.YY(this.width, d7, this.gc.absCoor);
                                            n8 = this.gc.absCoor ? (int)Math.round(d8) : (bl ? this.cs.XX(this.width, d8, this.gc.absCoor) : this.cs.YY(this.width, d8, this.gc.absCoor));
                                            for (n13 = 0; n13 < graphicsArray.length; ++n13) {
                                                if (this.gc.hasFillminus && n8 > n7) {
                                                    graphicsArray[n13].setColor(this.gc.fillminusColor.getAdaptedColor());
                                                    this.Line(graphicsArray[n13], this.width, n10, n7 + 1, n10, n8, bl);
                                                }
                                                if (this.gc.hasFillplus && n8 < n7) {
                                                    graphicsArray[n13].setColor(this.gc.fillplusColor.getAdaptedColor());
                                                    this.Line(graphicsArray[n13], this.width, n10, n7 - 1, n10, n8, bl);
                                                }
                                                graphicsArray[n13].setColor(mjaColorArray[n13].getAdaptedColor());
                                                if (n9 != n14) {
                                                    this.Line(graphicsArray[n13], this.width, n11, n9, n11, n14, bl);
                                                }
                                                this.Line(graphicsArray[n13], this.width, n11, n14, n10, n8, bl);
                                            }
                                        } else if (n12 == 1) {
                                            node.setDouble(d6 - d5);
                                            R2 r23 = mjaGraph.extrapolate(this.cond, node, node2, this.F, d7, d5);
                                            n8 = bl ? this.cs.XX(this.width, r23.y, this.gc.absCoor) : this.cs.YY(this.width, r23.y, this.gc.absCoor);
                                            for (n13 = 0; n13 < graphicsArray.length; ++n13) {
                                                graphicsArray[n13].setColor(mjaColorArray[n13].getAdaptedColor());
                                                this.Line(graphicsArray[n13], this.width, n11, n9, n11 + (int)Math.round(r23.x), n8, bl);
                                            }
                                            node.setDouble(d6);
                                            R2 r24 = mjaGraph.extrapolate(this.cond, node, node2, this.F, d8, -d5);
                                            n9 = bl ? this.cs.XX(this.width, r24.y, this.gc.absCoor) : this.cs.YY(this.width, r24.y, this.gc.absCoor);
                                            n8 = bl ? this.cs.XX(this.width, d8, this.gc.absCoor) : this.cs.YY(this.width, d8, this.gc.absCoor);
                                            for (int i = 0; i < graphicsArray.length; ++i) {
                                                graphicsArray[i].setColor(mjaColorArray[i].getAdaptedColor());
                                                this.Line(graphicsArray[i], this.width, n10 + (int)Math.round(r24.x), n9, n10, n8, bl);
                                            }
                                        } else if (n12 == 2) {
                                            n8 = bl ? this.cs.XX(this.width, d8, this.gc.absCoor) : this.cs.YY(this.width, d8, this.gc.absCoor);
                                            for (n14 = 0; n14 < graphicsArray.length; ++n14) {
                                                graphicsArray[n14].setColor(mjaColorArray[n14].getAdaptedColor());
                                                this.Line(graphicsArray[n14], this.width, n10, n8, n10, n8, bl);
                                            }
                                        }
                                    } else {
                                        R2 r25 = mjaGraph.extrapolateOnSingularity(this.cond, node, node2, this.F, d8, -d5);
                                        n9 = bl ? this.cs.XX(this.width, r25.y, this.gc.absCoor) : this.cs.YY(this.width, r25.y, this.gc.absCoor);
                                        n8 = bl ? this.cs.XX(this.width, d8, this.gc.absCoor) : this.cs.YY(this.width, d8, this.gc.absCoor);
                                        for (int i = 0; i < graphicsArray.length; ++i) {
                                            graphicsArray[i].setColor(mjaColorArray[i].getAdaptedColor());
                                            this.Line(graphicsArray[i], this.width, n10 + (int)Math.round(r25.x), n9, n10, n8, bl);
                                        }
                                    }
                                    d7 = d8;
                                    break block48;
                                }
                                bl3 = false;
                            }
                            catch (Exception exception) {
                                bl3 = false;
                            }
                        }
                        if (bl2 && !bl3) {
                            node.setDouble(d6 - d5);
                            node2.setDouble(d7);
                            R2 r26 = mjaGraph.extrapolate(this.cond, node, node2, this.F, d7, d5);
                            n8 = bl ? this.cs.XX(this.width, r26.y, this.gc.absCoor) : this.cs.YY(this.width, r26.y, this.gc.absCoor);
                            for (int i = 0; i < graphicsArray.length; ++i) {
                                graphicsArray[i].setColor(mjaColorArray[i].getAdaptedColor());
                                this.Line(graphicsArray[i], this.width, n11, n9, n11 + (int)Math.round(r26.x), n8, bl);
                            }
                            node.setDouble(d6);
                        }
                        bl2 = bl3;
                        n = n12;
                        d6 += d5;
                        n9 = n8;
                        n11 = n10++;
                    }
                }
                node.setDouble(d);
                node2.setDouble(d2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawEquation(Graphics[] graphicsArray, mjaColor[] mjaColorArray) {
        vez += 1.0;
        c1 = 0.0;
        c2 = 0.0;
        c3 = 0.0;
        c4 = 0.0;
        String string = this.gc.formula;
        if (this.D.p.isVar(string) && this.D.p.Var(string).getStr() != null) {
            string = this.D.p.Var(string).getStr();
        }
        if (BasicStr.hasContent(string)) {
            Node node = this.D.p.Var("x");
            Node node2 = this.D.p.Var("y");
            Node node3 = node;
            synchronized (node3) {
                Node node4 = node2;
                synchronized (node4) {
                    double d = node.getDouble();
                    double d2 = node2.getDouble();
                    try {
                        int n;
                        R2Newton r2Newton = new R2Newton(this.D.p, string);
                        int n2 = this.cs.getSize().width;
                        int n3 = this.cs.getSize().height;
                        int n4 = n2 / 9;
                        if (n4 < 3) {
                            n4 = 3;
                        }
                        if ((n = n3 / 7) < 3) {
                            n = 3;
                        }
                        boolean[][] blArray = new boolean[n2 + 24][n3 + 24];
                        R2 r2 = new R2();
                        R2 r22 = new R2();
                        R2 r23 = new R2();
                        int n5 = 8;
                        double d3 = 0.25;
                        double d4 = n5;
                        if (!this.gc.absCoor) {
                            double d5 = this.cs.Nesc.getDouble();
                            d3 /= d5;
                            d4 /= d5;
                        }
                        for (int i = n / 2; i < n3; i += n) {
                            block13: for (int j = n4 / 2; j < n2; j += n4) {
                                boolean bl;
                                R2 r24;
                                try {
                                    r24 = r2Newton.findZero(this.cs.injection(j, i, this.gc.absCoor), d3);
                                }
                                catch (Exception exception) {
                                    continue;
                                }
                                node.setDouble(r24.x);
                                node2.setDouble(r24.y);
                                R2 r25 = this.cs.projection(r24, this.gc.absCoor);
                                int n6 = r25.ix();
                                int n7 = r25.iy();
                                boolean bl2 = bl = n6 >= -12 && n6 < n2 + 12 && n7 >= -12 && n7 + 12 < n3;
                                if (bl) {
                                    if (blArray[n6 + 12][n7 + 12]) {
                                        c1 += 1.0;
                                        continue;
                                    }
                                    blArray[n6 + 12][n7 + 12] = true;
                                }
                                if (r2Newton.rangeOK()) {
                                    for (int k = 0; k < graphicsArray.length; ++k) {
                                        graphicsArray[k].setColor(mjaColorArray[k].getAdaptedColor());
                                        this.Line(graphicsArray[k], this.width, n6, n7, n6, n7);
                                    }
                                }
                                r2.x = r24.x;
                                r2.y = r24.y;
                                r22.x = r24.x;
                                r22.y = r24.y;
                                R2 r26 = r2Newton.getUnitNormal();
                                if (r26.x == 0.0 && r26.y == 0.0) continue;
                                r26.rotL90();
                                r23.x = r26.x;
                                r23.y = r26.y;
                                int n8 = 0;
                                int n9 = 0;
                                boolean bl3 = false;
                                while (n9 < 2) {
                                    if (bl3) {
                                        r23.x = -r26.x;
                                        r23.y = -r26.y;
                                        r24.x = r2.x;
                                        r24.y = r2.y;
                                        r22.x = r24.x;
                                        r22.y = r24.y;
                                        r25 = this.cs.projection(r24, this.gc.absCoor);
                                        n6 = r25.ix();
                                        n7 = r25.iy();
                                        bl3 = false;
                                        n8 = 0;
                                    }
                                    r24.x += d4 * r23.x;
                                    r24.y += d4 * r23.y;
                                    try {
                                        r24 = r2Newton.findZero(r24, d3);
                                    }
                                    catch (Exception exception) {
                                        continue;
                                    }
                                    node.setDouble(r24.x);
                                    node2.setDouble(r24.y);
                                    r23.x = r24.x - r22.x;
                                    r23.y = r24.y - r22.y;
                                    r23.normalize();
                                    if (r23.x == 0.0 && r23.y == 0.0) continue block13;
                                    r22.x = r24.x;
                                    r22.y = r24.y;
                                    r25 = this.cs.projection(r24, this.gc.absCoor);
                                    int n10 = r25.ix();
                                    int n11 = r25.iy();
                                    if (n10 != n6 || n11 != n7) {
                                        int n12 = n6;
                                        int n13 = n7;
                                        n6 = n10;
                                        n7 = n11;
                                        boolean bl4 = bl = n6 >= -12 && n6 < n2 + 12 && n7 >= -12 && n7 < n3 + 12;
                                        if (bl) {
                                            int n14;
                                            n8 = 0;
                                            boolean bl5 = blArray[n6 + 12][n7 + 12];
                                            blArray[n6 + 12][n7 + 12] = true;
                                            for (n14 = 1; n14 < n5; ++n14) {
                                                int n15 = n12 + Math.round((n6 - n12) * n14 / n5);
                                                int n16 = n13 + Math.round((n7 - n13) * n14 / n5);
                                                if (0 > n15 || n15 >= n2 || 0 > n16 || n16 >= n3) continue;
                                                blArray[n15 + 12][n16 + 12] = true;
                                            }
                                            for (n14 = 0; n14 < graphicsArray.length; ++n14) {
                                                graphicsArray[n14].setColor(mjaColorArray[n14].getAdaptedColor());
                                                if (!r2Newton.rangeOK()) continue;
                                                this.Line(graphicsArray[n14], this.width, n12, n13, n6, n7);
                                            }
                                            if (!bl5) continue;
                                            c2 += 1.0;
                                            continue block13;
                                        }
                                        c3 += 1.0;
                                        bl3 = true;
                                        ++n9;
                                        continue;
                                    }
                                    if (++n8 <= 4) continue;
                                    c4 += 1.0;
                                    bl3 = true;
                                    ++n9;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    node.setDouble(d);
                    node2.setDouble(d2);
                }
            }
        }
    }

    public void flush() {
        this.image.flush();
        if (this.ith != null) {
            this.ith.pleaseStop();
            this.ith = null;
        }
        this.image = null;
    }
}

