/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Scene;
import com.mja.file.mjaFile;
import com.mja.file.mjaFont;
import com.mja.gui.editDialog;
import com.mja.lang.translator;
import com.mja.util.BasicStr;
import com.mja.util.TFont;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextField;
import org.unam.matem.Attribute;

public class TitleCanvas
extends Canvas
implements MouseListener {
    private Color bgcolor = new Color(5466257);
    private Color fgcolor = new Color(0xFFFFFF);
    private String s_bgcolor = "0x536891";
    private String s_fgcolor = "0xffffff";
    private Scene sc;
    private String tit = "T\u00edtulo";
    private String subtit = "Subt\u00edtulo.";
    private String s_titima = "";
    private String s_titfont = "SansSerif,BOLD,20";
    private String s_subtitfont = "SansSerif,ITALIC,18";
    private String s_align = "left";
    private int LEFT = 0;
    private int CENTER = 1;
    private int RIGHT = 2;
    private int align = this.LEFT;
    private int subtitlines = 0;
    private Vector subtit_vector;
    private Font subtit_font0;
    private Font subtit_font = this.subtit_font0 = new Font("SansSerif", 0, 18);
    private Font tit_font = new Font("SansSerif", 1, 20);
    private Image bima;
    private Image titima;
    private Frame PF;
    private int fsz = 18;
    private int titsz = 0;
    private int subtitsz = 0;
    private int width = 790;
    public int height = 0;
    private boolean firstTime = true;
    private editDialog inputDialog;
    private JTextField tf_tit;
    private JTextField tf_subtit;

    TitleCanvas(translator translator2, Frame frame, Applet applet, Hashtable hashtable, Scene scene, String string) {
        this.PF = frame;
        this.sc = scene;
        if (BasicStr.hasContent(string)) {
            this.tit = Attribute.getValue(string, "title");
            this.subtit = Attribute.getValue(string, "subtitle");
            String string2 = Attribute.getValue(string, "subtitlines");
            this.s_align = Attribute.getValue(string, "align");
            if (BasicStr.hasContent(this.s_align)) {
                this.s_align = this.s_align.toLowerCase();
                this.align = this.s_align.equals("center") ? this.CENTER : (this.s_align.equals("right") ? this.RIGHT : this.LEFT);
            } else {
                this.align = this.LEFT;
            }
            this.s_bgcolor = Attribute.getValue(string, "bgcolor");
            if (this.s_bgcolor.startsWith("0x")) {
                this.s_bgcolor = this.s_bgcolor.substring(2);
            }
            this.s_fgcolor = Attribute.getValue(string, "fgcolor");
            if (this.s_fgcolor.startsWith("0x")) {
                this.s_fgcolor = this.s_fgcolor.substring(2);
            }
            this.subtitlines = BasicStr.parseInteger(string2, 0, 0);
            this.s_titima = Attribute.getValue(string, "titleimage");
            if (BasicStr.hasContent(this.s_titima)) {
                this.titima = mjaFile.loadImage(hashtable, applet, this.s_titima);
            }
            this.s_titfont = Attribute.getValue(string, "titlefont");
            this.tit_font = BasicStr.parseFont(this.s_titfont, this.tit_font);
            this.s_subtitfont = Attribute.getValue(string, "subtitlefont");
            this.subtit_font0 = BasicStr.parseFont(this.s_subtitfont, this.subtit_font0);
            this.fsz = this.subtit_font0.getSize();
            this.bgcolor = translator2.ParseColor(this.s_bgcolor, this.bgcolor, this.bgcolor);
            this.fgcolor = translator2.ParseColor(this.s_fgcolor, this.fgcolor, this.fgcolor);
        }
        this.setBackground(this.bgcolor);
        if (frame != null) {
            this.addMouseListener(this);
        }
        this.makeSubtitVector();
    }

    String getConfig() {
        return "title='" + this.tit + "' subtitle='" + this.subtit + "' " + "subtitlines='" + this.subtitlines + "' bgcolor='" + this.s_bgcolor + "' fgcolor='" + this.s_fgcolor + "' " + "align='" + this.s_align + "' titleimage='" + this.s_titima + "' " + "titlefont='" + this.s_titfont + "' subtitlefont='" + this.s_subtitfont + "' ";
    }

    void makeSubtitVector() {
        this.subtit_font = this.subtit_font0;
        FontMetrics fontMetrics = this.getFontMetrics(this.subtit_font);
        this.subtit_vector = new Vector();
        if (BasicStr.hasContent(this.subtit)) {
            if (this.subtitlines == 1) {
                while (fontMetrics.stringWidth(this.subtit) > 765 && this.fsz > 8) {
                    --this.fsz;
                    this.subtit_font = new Font(this.subtit_font.getName(), this.subtit_font.getStyle(), this.fsz);
                    fontMetrics = this.getFontMetrics(this.subtit_font);
                }
                this.subtit_vector.addElement(this.subtit);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.subtit, " ");
                String string = "";
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (fontMetrics.stringWidth(string + " " + string2) < 765) {
                        if (string.length() > 0) {
                            string = string + " ";
                        }
                        string = string + string2;
                        continue;
                    }
                    if (BasicStr.hasContent(string)) {
                        this.subtit_vector.addElement(string);
                    }
                    string = string2;
                }
                if (BasicStr.hasContent(string)) {
                    this.subtit_vector.addElement(string);
                }
            }
        }
        this.subtit_font = mjaFont.makeFont(this.subtit_font0.getName(), this.subtit_font0.getStyle(), this.fsz);
        this.tit_font = mjaFont.makeFont(this.tit_font.getName(), this.tit_font.getStyle(), this.tit_font.getSize());
        fontMetrics = this.getFontMetrics(this.tit_font);
        this.titsz = 0;
        if (BasicStr.hasContent(this.tit)) {
            this.titsz += fontMetrics.getAscent() + fontMetrics.getDescent();
        }
        fontMetrics = this.getFontMetrics(this.subtit_font);
        this.subtitsz = 0;
        if (this.subtit_vector.size() > 0) {
            this.subtitsz += this.subtit_vector.size() * (fontMetrics.getAscent() + fontMetrics.getDescent() - 2);
        }
        if (this.titima != null) {
            this.height = this.titima.getHeight(this);
        } else if (this.titsz + this.subtitsz > 0) {
            this.height = this.titsz + this.subtitsz + 6 + 11;
        }
        this.setSize(this.width, this.height);
    }

    void updateBGImage() {
        if (BasicStr.hasContent(this.tit) || this.subtit_vector.size() > 0) {
            Graphics2D graphics2D;
            this.width = this.getSize().width;
            if (this.titima != null) {
                this.height = this.titima.getHeight(this);
            } else if (this.titsz + this.subtitsz > 0) {
                this.height = this.titsz + this.subtitsz + 6 + 11;
            }
            this.setSize(this.width, this.height);
            this.bima = this.createImage(this.width, this.height);
            if (this.bima != null && (graphics2D = (Graphics2D)this.bima.getGraphics()) != null) {
                int n;
                int n2;
                graphics2D.setColor(this.bgcolor);
                graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
                if (this.titima != null) {
                    graphics2D.drawImage(this.titima, 0, 0, this.getSize().width, this.getSize().height, this);
                }
                TFont.setAntialias(graphics2D, true);
                graphics2D.setColor(this.fgcolor);
                graphics2D.setFont(this.tit_font);
                FontMetrics fontMetrics = this.getFontMetrics(this.tit_font);
                int n3 = fontMetrics.stringWidth(this.tit);
                int n4 = n2 = 16;
                if (this.align == this.CENTER) {
                    n4 = (this.width - n3) / 2;
                } else if (this.align == this.RIGHT) {
                    n4 = this.width - n3 - 16;
                }
                graphics2D.drawString(this.tit, n4, 1 + fontMetrics.getAscent() + 6);
                graphics2D.setFont(this.subtit_font);
                fontMetrics = this.getFontMetrics(this.subtit_font);
                for (n = 0; n < this.subtit_vector.size(); ++n) {
                    String string = (String)this.subtit_vector.elementAt(n);
                    n3 = fontMetrics.stringWidth(string);
                    n4 = n2;
                    if (this.align == this.CENTER) {
                        n4 = (this.width - n3) / 2;
                    } else if (this.align == this.RIGHT) {
                        n4 = this.width - n3 - 16;
                    }
                    graphics2D.drawString(string, n4, this.titsz + 6 + fontMetrics.getAscent() + n * (fontMetrics.getAscent() + fontMetrics.getDescent() - 2));
                }
                TFont.setAntialias(graphics2D, false);
                if (this.titima == null) {
                    n = 5;
                    for (int i = 0; i < n; ++i) {
                        graphics2D.setColor(new Color(0, 0, 0, 3 * (n - i) * (n - i) / 2));
                        graphics2D.drawRect(i, i, this.getSize().width - 2 * i, this.getSize().height - 2 * i);
                        graphics2D.drawLine(i - 1, i - 1, i, i);
                    }
                }
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.bima == null) {
            this.updateBGImage();
        }
        if (this.bima != null) {
            graphics.drawImage(this.bima, 0, 0, this);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            if (this.inputDialog == null) {
                this.makeInputDialog();
            }
            this.tf_tit.setText(this.tit);
            this.tf_subtit.setText(this.subtit);
            this.inputDialog.display(true, true);
            if (this.inputDialog.ok) {
                this.tit = this.tf_tit.getText();
                this.subtit = this.tf_subtit.getText();
                this.makeSubtitVector();
                this.updateBGImage();
                this.repaint();
                this.sc.paintAll(this.sc.getGraphics());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    void makeInputDialog() {
        this.inputDialog = new editDialog(this.PF, "T\u00edtulo y subt\u00edtulo", true, "Aceptar", "Cancelar");
        this.tf_tit = new JTextField(30);
        this.tf_subtit = new JTextField(50);
        this.tf_tit.setText(this.tit);
        this.tf_subtit.setText(this.subtit);
        Panel panel = new Panel();
        panel.setBackground(this.bgcolor);
        this.tf_tit.setBackground(this.bgcolor);
        this.tf_tit.setForeground(this.fgcolor);
        this.tf_tit.setFont(this.tit_font);
        this.tf_subtit.setBackground(this.bgcolor);
        this.tf_subtit.setFont(this.subtit_font0);
        this.tf_subtit.setForeground(this.fgcolor);
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(12, 16, 0, 16);
        panel.add((Component)this.tf_tit, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        panel.add((Component)this.tf_subtit, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 6;
        Canvas canvas = new Canvas();
        canvas.setBackground(this.bgcolor);
        canvas.setSize(this.width - 32, 6);
        panel.add((Component)canvas, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.inputDialog.add("Center", panel);
    }
}

