/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.cmp.mjaButton;
import com.mja.descartes.Action;
import com.mja.descartes.Arquimedes;
import com.mja.descartes.Descartes;
import com.mja.descartes.Item;
import com.mja.descartes.Space;
import com.mja.descartes.TitleCanvas;
import com.mja.descartes.auxConfig;
import com.mja.descartes.controlConfig;
import com.mja.descartes.doed;
import com.mja.descartes.mjaGraph;
import com.mja.descartes.spaceConfig;
import com.mja.descgui.NumericControl;
import com.mja.descgui.edit.editObject;
import com.mja.file.mjaFile;
import com.mja.file.mjaFont;
import com.mja.gui.mjaLabelAndText;
import com.mja.img.imageCanvas;
import com.mja.parser.Algorithm;
import com.mja.parser.Node;
import com.mja.text.RTF;
import com.mja.text.Text;
import com.mja.text.TextCanvas;
import com.mja.util.BasicStr;
import com.mja.util.TFont;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.Scrollbar;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTextField;

public class Scene
extends Panel
implements ActionListener,
MouseListener,
KeyListener,
Runnable,
AdjustmentListener {
    private imageCanvas IC;
    mjaGraph[] graph = new mjaGraph[0];
    Space[] spa = new Space[0];
    private Descartes D;
    private Thread thr;
    private Panel animCtrl;
    private mjaButton[] b;
    private Algorithm animAlg;
    private volatile boolean pleaseStop;
    private volatile boolean running;
    private volatile boolean pause;
    private volatile boolean onestep;
    private volatile boolean stay;
    private Vector numCtrl;
    private Vector SceneNumCtrl;
    private TitleCanvas titcan;
    private Panel view;
    TextCanvas EC;
    private Scrollbar jsb;
    private Panel jp;
    private static Frame pf = new Frame();
    private static TFont TF;
    private doed dd;
    private Panel mainPanel;
    public static Color sceneBackColor;
    private static final String licenseA = "{\\f0\\fs34 __________________________________________________________________________________ \\par \\fs22                                        Los contenidos de esta unidad did\u00e1ctica interactiva est\u00e1n bajo una  {\\*\\hyperlink licencia Creative Commons|http://creativecommons.org/licenses/by-nc-sa/2.5/es/}, si no se indica lo contrario.\\par                                        La unidad did\u00e1ctica fue creada con Descartes, que es un producto de c\u00f3digo abierto del  {\\*\\hyperlink Ministerio de Educaci\u00f3n de Espa\u00f1a|http://www.ite.educacion.es/} y\\par                                        el {\\*\\hyperlink Instituto de Matem\u00e1ticas|http://arquimedes.matem.unam.mx/}  de la Universidad Nacional Aut\u00f3noma de M\u00e9xico, cedido bajo licencia {\\*\\hyperlink EUPL v 1.1|http://joinup.ec.europa.eu/software/page/eupl/licence-eupl}, con {\\*\\hyperlink c\u00f3digo en Java|http://arquimedes.matem.unam.mx/Descartes5/source/}.";
    private int EC_width;
    private int EC_height;
    private mjaGraph[] sceneGraphs;
    private volatile boolean updatingScene;
    private boolean firstTime = true;
    private volatile boolean stopping = false;

    public Scene(Descartes descartes, doed doed2) {
        this.D = descartes;
        this.dd = doed2;
        this.setBackground(sceneBackColor);
        this.setLayout(new BorderLayout());
        this.b = new mjaButton[6];
        this.animCtrl = new Panel();
        this.animCtrl.setLayout(new GridLayout(1, this.b.length));
        this.animCtrl.setVisible(false);
        for (int i = 0; i < this.b.length; ++i) {
            this.b[i] = new mjaButton(i);
            this.animCtrl.add(this.b[i]);
            this.b[i].addActionListener(this);
        }
        String string = descartes.getParameter("pleca");
        if (BasicStr.hasContent(string)) {
            Frame frame = pf;
            if (descartes.parentFrame != null) {
                frame = descartes.parentFrame;
            }
            this.titcan = new TitleCanvas(descartes.Tr, frame, descartes, descartes.imagesHT, this, string);
            if (!(descartes instanceof Item)) {
                this.add("North", this.titcan);
            }
        }
        if (descartes instanceof Arquimedes) {
            this.constructArquimedesScene();
        } else {
            this.mainPanel = new Panel();
            this.mainPanel.setLayout(null);
            this.mainPanel.setBackground(sceneBackColor);
            this.add("Center", this.mainPanel);
            this.mainPanel.add(this.animCtrl);
            this.addMouseListener(this);
            this.addKeyListener(this);
        }
    }

    public Space getSpaceByPrefix(String string) {
        int n = string.indexOf(".");
        if (n > 0) {
            String string2 = string.substring(0, n);
            for (int i = 0; i < this.spa.length; ++i) {
                if (!string2.equals(this.spa[i].getSpaceName())) continue;
                return this.spa[i];
            }
        }
        return null;
    }

    public int getTitleHeight() {
        if (this.titcan != null) {
            return this.titcan.height;
        }
        return 0;
    }

    private void constructArquimedesScene() {
        String string = licenseA;
        if (!this.D.cfg.useCC) {
            string = "";
        }
        Frame frame = pf;
        if (this.D.parentFrame != null) {
            frame = this.D.parentFrame;
        }
        if (this.D instanceof Arquimedes && this.D.inWeb()) {
            frame = null;
        }
        TF = new TFont(mjaFont.makeFont("SansSerif", 0, 17));
        this.EC = this.dd != null && this.dd.getEditorCanvas() != null ? this.dd.getEditorCanvas() : new TextCanvas(this.D, frame, this.D.Tr, this.D.p, TF, Color.black, true, false);
        this.EC.setExprDefaults(2, true, this.D.cfg.language);
        this.EC.setBackground(sceneBackColor);
        this.EC.setForeground(Color.darkGray);
        Text text = new Text(this.D.p, TF);
        text.setTFont(new TFont(new Font("SansSerif", 0, 17)));
        String string2 = this.D.getParameter("rtf");
        if (BasicStr.hasContent(string2)) {
            if (this.D.inWeb() && !(this.D instanceof Item) && BasicStr.hasContent(string)) {
                string2 = string2.substring(0, string2.lastIndexOf("}")) + string.substring(string.indexOf("{") + 1);
                Image image = this.D.getImage(this.getClass().getResource("/resources/logos/cc_by_nc_sa.png"));
                try {
                    MediaTracker mediaTracker = new MediaTracker(this);
                    mediaTracker.addImage(image, 0);
                    mediaTracker.waitForID(0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.IC = new imageCanvas(image, this.EC);
                this.IC.setHyperlink(this.D, "http://creativecommons.org/licenses/by-nc-sa/2.5/es/");
            }
            RTF.parseRTF(string2, text);
        } else {
            text.insertString("Escribir aqu\u00ed");
        }
        text.setTopAndBottomMargin(20);
        this.EC.setText(text);
        this.jp = new Panel();
        this.jp.setBackground(sceneBackColor);
        this.jp.setLayout(null);
        this.add("Center", this.jp);
        this.jp.add(this.EC);
        this.jsb = new Scrollbar(1);
        this.jsb.setBackground(Descartes.basicBlue);
        if (!(this.D instanceof Item)) {
            this.add("East", this.jsb);
            this.jsb.addAdjustmentListener(this);
            this.EC.jsb = this.jsb;
        }
        this.EC.addMouseListener(this);
        this.EC.addKeyListener(this);
        this.EC.addActionListener(this);
    }

    public Object getEC() {
        return this.EC;
    }

    public String getText() {
        if (this.EC != null) {
            Text text = this.EC.getText();
            RTF rTF = new RTF(text);
            return rTF.toRTF(false);
        }
        return "";
    }

    public int getTextHeight() {
        if (this.EC != null) {
            return this.EC.getTextHeight();
        }
        return 0;
    }

    public String getPleca() {
        if (this.titcan != null) {
            return this.titcan.getConfig();
        }
        return "";
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.EC != null) {
            this.EC_width = n3 - 20;
            this.EC_height = n4;
            if (this.EC.getSize().width != this.EC_width || this.EC.getSize().height != this.EC_height) {
                this.EC.setBounds(0, 0, this.EC_width, this.EC_height);
                this.EC.setEnabled(true);
                this.EC.start();
                if (this.D.inWeb() && this.IC != null) {
                    this.IC.setBounds(27, this.EC.getCanvasHeight() - 58, 88, 31);
                }
            }
        }
    }

    public void saveScene(String string, String string2) {
        Object object;
        Object object2;
        int n;
        Object object3;
        Cursor cursor = new Cursor(3);
        this.D.setCursor(cursor);
        this.setCursor(cursor);
        boolean bl = false;
        BufferedImage bufferedImage = null;
        Image image = null;
        if (this.D instanceof Arquimedes) {
            bl = this.EC.isEditing();
            this.EC.compactCanvas(true);
            this.EC.updateScreen();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bufferedImage = this.EC.getBufferedImage();
            image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/images/pieDescartes.png"));
            try {
                object3 = new MediaTracker(this);
                ((MediaTracker)object3).addImage(image, 0);
                ((MediaTracker)object3).waitForID(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            bufferedImage = new BufferedImage(this.D.getSize().width, this.D.getSize().height, 6);
        }
        object3 = bufferedImage.getGraphics();
        int n2 = bufferedImage.getWidth(this);
        n2 = this.D instanceof Arquimedes ? n2 + 20 : n2;
        int n3 = bufferedImage.getHeight(this);
        double d = 1.0;
        int n4 = (int)Math.round((double)n2 * d);
        int n5 = (int)Math.round((double)n3 * d);
        int n6 = (int)Math.round((double)n2 * (1.0 - d) / 2.0);
        int n7 = 0;
        if (this.D instanceof Arquimedes) {
            n7 = this.titcan.getSize().height;
        }
        if (this.D instanceof Arquimedes) {
            for (n = 0; n < this.SceneNumCtrl.size(); ++n) {
                NumericControl numericControl = (NumericControl)this.SceneNumCtrl.elementAt(n);
                Image image2 = this.createImage(numericControl.getSize().width, numericControl.getSize().height);
                Graphics graphics = image2.getGraphics();
                numericControl.paintAll(graphics);
                ((Graphics)object3).drawImage(image2, numericControl.getLocation().x, numericControl.getLocation().y, this);
            }
            for (n = 0; n < this.spa.length; ++n) {
                int n8;
                if (!this.spa[n].isVisible()) continue;
                int n9 = this.spa[n].getLocation().x;
                int n10 = this.spa[n].getLocation().y;
                ((Graphics)object3).drawImage(this.spa[n].main, n9, n10, this);
                for (n8 = 0; n8 < this.numCtrl.size(); ++n8) {
                    object2 = (NumericControl)this.numCtrl.elementAt(n8);
                    if (!((Component)object2).isVisible() || this.getSpace(((NumericControl)object2).getSpace()) != this.spa[n]) continue;
                    object = this.createImage(((Component)object2).getSize().width, ((Component)object2).getSize().height);
                    Graphics graphics = ((Image)object).getGraphics();
                    ((Container)object2).paint(graphics);
                    ((Graphics)object3).drawImage((Image)object, n9 + ((Component)object2).getLocation().x, n10 + ((Component)object2).getLocation().y, this);
                }
                for (n8 = 0; n8 < this.spa[n].TAC.length; ++n8) {
                    object2 = this.createImage(this.spa[n].TAC[n8].getSize().width, this.spa[n].TAC[n8].getSize().height);
                    object = ((Image)object2).getGraphics();
                    this.spa[n].TAC[n8].paint((Graphics)object);
                    ((Graphics)object3).drawImage((Image)object2, n9 + this.spa[n].TAC[n8].getLocation().x, n10 + this.spa[n].TAC[n8].getLocation().y, this);
                }
            }
        } else {
            this.D.paintAll((Graphics)object3);
        }
        n = this.D.cfg.useCC ? 1 : 0;
        int n11 = n != 0 ? 60 : 0;
        BufferedImage bufferedImage2 = string2.equals("png") ? new BufferedImage(n4, n7 + n5 + n11, 6) : new BufferedImage(n4, n7 + n5 + n11, 5);
        Graphics graphics = bufferedImage2.getGraphics();
        object2 = (Graphics2D)graphics;
        object = new BasicStroke(1.0f, 1, 1);
        ((Graphics2D)object2).setStroke((Stroke)object);
        ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        ((Graphics)object2).setColor(Color.white);
        ((Graphics)object2).fillRect(0, 0, n2 + 20, n7 + n5 + n11);
        if (this.D instanceof Arquimedes) {
            this.titcan.paint((Graphics)object2);
        }
        ((Graphics)object2).drawImage(bufferedImage, n6, n7, n4, n5, this);
        if (n != 0) {
            ((Graphics)object2).drawImage(image, n6 + (n4 - 775) / 2, n7 + n5, this);
        }
        mjaFile.save(string, bufferedImage2, string2);
        bufferedImage2.flush();
        bufferedImage2 = null;
        this.D.setCursor(null);
        this.setCursor(null);
    }

    public boolean hayAnim() {
        return this.thr != null;
    }

    protected void prepareSpace() {
        if (this.D instanceof Arquimedes) {
            this.EC.removeAll();
            this.EC.add(this.animCtrl);
            if (this.IC != null) {
                this.EC.add(this.IC);
            }
        } else {
            this.mainPanel.removeAll();
            this.mainPanel.add(this.animCtrl);
        }
    }

    public String getNewSpaceName() {
        String string;
        int n = 0;
        String string2 = string = "E" + Integer.toString(n++);
        do {
            string2 = string;
            for (int i = 0; i < this.D.cfg.sc.length; ++i) {
                if (!string.equals(this.D.cfg.sc[i].s_value[1])) continue;
                string = "E" + Integer.toString(n++);
            }
        } while (!string.equals(string2));
        return string;
    }

    public String getNewControlName() {
        String string;
        int n = 0;
        String string2 = string = "n" + Integer.toString(n++);
        do {
            string2 = string;
            for (int i = 0; i < this.D.cfg.cc.length; ++i) {
                if (!string.equals(this.D.cfg.cc[i].s_value[controlConfig.ixid])) continue;
                string = "n" + Integer.toString(n++);
            }
        } while (!string.equals(string2));
        return string;
    }

    public void addEditObjectToText(editObject editObject2, String string) {
        if (editObject2 instanceof spaceConfig) {
            this.D.cfg.addSpace((spaceConfig)editObject2);
            this.D.cfg.sc[this.D.cfg.sc.length - 1].s_value[1] = this.getNewSpaceName();
            this.D.cfg.sc[this.D.cfg.sc.length - 1].s_value[38] = string;
            this.D.renewEditorConfig();
        } else if (editObject2 instanceof controlConfig) {
            this.D.cfg.addControl((controlConfig)editObject2);
            this.D.cfg.cc[this.D.cfg.cc.length - 1].s_value[controlConfig.ixcontrolID] = string;
            this.D.renewEditorConfig();
        }
    }

    void addSpaces() {
        int n;
        this.prepareSpace();
        this.spa = new Space[this.D.cfg.sc.length];
        for (n = this.spa.length - 1; n >= 0; --n) {
            this.D.cfg.sc[n].updateInfo(this.D.Tr);
            this.spa[n] = this.D.cfg.sc[n].makeSpace(this.D);
            this.spa[n].scene = this;
            if (!(this.D instanceof Arquimedes)) continue;
            this.spa[n].TextBound = this.EC.updateTextComponent(this.spa[n], this.spa[n].getSpaceID());
        }
        if (this.D instanceof Arquimedes) {
            for (n = this.spa.length - 1; n >= 0; --n) {
                if (this.spa[n].TextBound) {
                    this.spa[n].setLocation(-4000, -4000);
                }
                this.EC.add(this.spa[n]);
            }
        } else {
            for (n = this.spa.length - 1; n >= 0; --n) {
                this.mainPanel.add(this.spa[n]);
            }
        }
    }

    void addGraphs() {
        int n;
        Vector<mjaGraph> vector = new Vector<mjaGraph>();
        this.graph = new mjaGraph[this.D.cfg.allgR2c.length];
        for (n = 0; n < this.graph.length; ++n) {
            if (this.D.cfg.allgR2c[n].type < 0) {
                this.graph[n] = null;
                continue;
            }
            this.graph[n] = new mjaGraph(this.D, n);
            boolean bl = true;
            for (int i = 0; i < this.spa.length; ++i) {
                if (this.graph[n].cs != this.spa[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            vector.add(this.graph[n]);
        }
        this.sceneGraphs = new mjaGraph[vector.size()];
        for (n = 0; n < this.sceneGraphs.length; ++n) {
            this.sceneGraphs[n] = (mjaGraph)vector.elementAt(n);
        }
    }

    void defineNumericControls(NumericControl[] numericControlArray) {
        boolean bl = false;
        this.numCtrl = new Vector();
        this.SceneNumCtrl = new Vector();
        if (numericControlArray != null) {
            for (int i = 0; i < numericControlArray.length; ++i) {
                Space space;
                if (numericControlArray[i] == null || !numericControlArray[i].isInterior() && !numericControlArray[i].inScenario()) continue;
                if (numericControlArray[i].inScenario()) {
                    this.SceneNumCtrl.addElement(numericControlArray[i]);
                } else {
                    space = this.getSpace(numericControlArray[i].getSpace());
                    if (space != null) {
                        this.numCtrl.addElement(numericControlArray[i]);
                    }
                }
                if (this.D instanceof Arquimedes) {
                    if (numericControlArray[i] != null && (numericControlArray[i].isInterior() || numericControlArray[i].inScenario())) {
                        if (numericControlArray[i].inScenario()) {
                            this.EC.updateTextComponent(numericControlArray[i], numericControlArray[i].getControlID());
                        } else {
                            space = this.getSpace(numericControlArray[i].getSpace());
                            if (space != null) {
                                space.add(numericControlArray[i]);
                            }
                        }
                        numericControlArray[i].locate();
                    }
                } else if (numericControlArray[i] != null && numericControlArray[i].isInterior()) {
                    space = this.getSpace(0, numericControlArray[i].getSpace());
                    if (space == null) {
                        space = this.getSpace(1, numericControlArray[i].getSpace());
                    }
                    if (space != null) {
                        space.add(numericControlArray[i]);
                        numericControlArray[i].locate();
                    }
                }
                numericControlArray[i].updateFromNode();
                numericControlArray[i].updateFont();
            }
        }
    }

    void initAnimation() {
        this.animAlg.initialize();
    }

    void toggleAnimation() {
        if (this.running) {
            this.pause = !this.pause;
        } else {
            this.startAnimation();
        }
        this.updateAnimationButtons();
    }

    boolean hasEquationsPanel() {
        return this.countEqPanelElements() > 0;
    }

    private boolean R2SpaceExists(String string) {
        for (int i = 0; i < this.spa.length; ++i) {
            if (this.spa[i] == null || this.spa[i].spcfg.type != 0 || !"".equals(string) && !this.spa[i].spcfg.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private int countEqPanelElements() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.D.cfg.auxiliar.length; ++n) {
            if (this.D.cfg.auxiliar[n].type != 104 || !this.D.cfg.auxiliar[n].isEditable) continue;
            ++n2;
        }
        for (n = 0; n < this.D.cfg.allgR2c.length; ++n) {
            if (this.D.cfg.allgR2c[n].type < 0 || !this.D.cfg.allgR2c[n].isVisible() || !this.R2SpaceExists(this.D.cfg.allgR2c[n].getSpace())) continue;
            ++n2;
        }
        return n2;
    }

    Panel getVisibleEquationsPanel() {
        Panel panel = null;
        int n = this.countEqPanelElements();
        if (n > 0) {
            int n2;
            panel = new Panel();
            panel.setLayout(new GridLayout(1, n, 0, 0));
            int n3 = 0;
            for (n2 = 0; n2 < this.graph.length; ++n2) {
                if (this.graph[n2].cs == null || !this.graph[n2].gc.isVisible()) continue;
                this.graph[n2].TF = new JTextField(this.graph[n2].gc.formula);
                this.graph[n2].TF.setForeground(this.graph[n2].gc.gcolor.getAdaptedColor());
                this.graph[n2].TF.setFont(mjaFont.makeFont("Monospaced", 0, BasicStr.fontSizeForHeight(this.D.cfg.rows_height)));
                if (this.graph[n2].gc.isEditable) {
                    this.graph[n2].TF.setEditable(true);
                    this.graph[n2].TF.addActionListener(this);
                } else {
                    this.graph[n2].TF.setEditable(false);
                }
                this.graph[n2].TF.setBackground(this.graph[n2].cs.backColor.getAdaptedColor());
                panel.add(this.graph[n2].TF);
                ++n3;
            }
            for (n2 = 0; n2 < this.D.cfg.auxiliar.length; ++n2) {
                if (this.D.cfg.auxiliar[n2].type != 104 || !this.D.cfg.auxiliar[n2].isEditable) continue;
                this.D.cfg.auxiliar[n2].exprEd = new mjaLabelAndText(this, 0.1, 0.9);
                this.D.cfg.auxiliar[n2].exprEd.addActionListener(this);
                this.D.cfg.auxiliar[n2].exprEd.setInfo(this.D.cfg.auxiliar[n2].getName() + " =", this.D.cfg.auxiliar[n2].s_value[auxConfig.ixexpr]);
                this.D.cfg.auxiliar[n2].exprEd.updateFonts(this.D.cfg.rows_height);
                panel.add(this.D.cfg.auxiliar[n2].exprEd);
            }
        }
        return panel;
    }

    void preSizeSpaces() {
        for (int i = this.spa.length - 1; i >= 0; --i) {
            this.spa[i].preSize();
        }
    }

    void start(boolean bl) {
        int n;
        this.setCursor(new Cursor(3));
        for (n = 0; n < this.graph.length; ++n) {
            if (this.graph[n] == null) continue;
            this.graph[n].initialize();
        }
        this.running = false;
        this.animCtrl.setLocation((this.getSize().width - 120) / 2, this.getSize().height - 22);
        this.animCtrl.setSize(120, 20);
        if (this.D.cfg.animC.active) {
            this.animAlg = new Algorithm("Scene.Animation", this.D.p, false, this.D.cfg.animC.s_value[5], this.D.cfg.animC.s_value[4], this.D.cfg.animC.s_value[6]);
        }
        this.doAlgorithms(false);
        this.doEventsReturnRestarted();
        for (n = this.spa.length - 1; n >= 0; --n) {
            this.spa[n].start();
        }
        this.updateScene(true);
        this.startAnimation(bl);
        this.setCursor(new Cursor(0));
    }

    private boolean updatingScene() {
        return this.updatingScene;
    }

    void showSolutions() {
        for (int i = 0; i < this.spa.length; ++i) {
            this.spa[i].showSolutions();
        }
    }

    void showUserTexts() {
        for (int i = 0; i < this.spa.length; ++i) {
            this.spa[i].showUserTexts();
        }
    }

    void updateScene(boolean bl) {
        if (!this.updatingScene()) {
            int n;
            this.updatingScene = true;
            if (bl && this.EC != null) {
                this.EC.updateScreen();
            }
            this.D.updateTextFieldsFromNodes(!this.isRunning());
            for (n = 0; n < this.spa.length; ++n) {
                this.spa[n].locate();
                this.spa[n].updateSpace(bl, true);
                if (this.spa[n].isMoving() && !this.spa[n].isDragging()) continue;
                this.spa[n].paintSpace();
            }
            for (n = 0; n < this.numCtrl.size(); ++n) {
                NumericControl numericControl = (NumericControl)this.numCtrl.elementAt(n);
                numericControl.locate();
            }
            this.updatingScene = false;
            this.firstTime = false;
        }
    }

    void paintSceneSpaces() {
        for (int i = 0; i < this.spa.length; ++i) {
            if (this.spa[i].isMoving() && !this.spa[i].isDragging()) continue;
            this.spa[i].paint(this.spa[i].getGraphics());
        }
    }

    void paintSceneControls() {
        for (int i = 0; i < this.SceneNumCtrl.size(); ++i) {
            NumericControl numericControl = (NumericControl)this.SceneNumCtrl.elementAt(i);
            numericControl.paint(numericControl.getGraphics());
        }
    }

    void paintControls() {
        for (int i = 0; i < this.numCtrl.size(); ++i) {
            NumericControl numericControl = (NumericControl)this.numCtrl.elementAt(i);
            numericControl.paint(numericControl.getGraphics());
        }
    }

    void refreshScene(boolean bl) {
        if (bl) {
            this.D.updateNodesFromControls();
        }
        this.doAlgorithms(false);
        if (!this.doEventsReturnRestarted()) {
            this.updateScene(this.firstTime);
        }
    }

    void updateNodesFromTexts() {
        NumericControl numericControl;
        Object e;
        int n;
        for (n = 0; n < this.numCtrl.size(); ++n) {
            e = this.numCtrl.elementAt(n);
            if (e == null) continue;
            numericControl = (NumericControl)e;
            numericControl.updateFromText();
        }
        for (n = 0; n < this.SceneNumCtrl.size(); ++n) {
            e = this.SceneNumCtrl.elementAt(n);
            if (e == null) continue;
            numericControl = (NumericControl)e;
            numericControl.updateFromText();
        }
    }

    void updateTextsFromNodes(boolean bl) {
        NumericControl numericControl;
        int n;
        for (n = 0; n < this.numCtrl.size(); ++n) {
            if (this.numCtrl.elementAt(n) == null || (numericControl = (NumericControl)this.numCtrl.elementAt(n)).isBeingEdited()) continue;
            numericControl.updateFromNode();
        }
        for (n = 0; n < this.SceneNumCtrl.size(); ++n) {
            if (this.SceneNumCtrl.elementAt(n) == null) continue;
            numericControl = (NumericControl)this.SceneNumCtrl.elementAt(n);
            if (!bl && numericControl.isBeingEdited()) continue;
            numericControl.updateFromNode();
        }
    }

    void showTextSolutions() {
        for (int i = 0; i < this.spa.length; ++i) {
            this.spa[i].showSolutions();
        }
    }

    void doAlgorithms(boolean bl) {
        try {
            this.D.p.doAlgorithms(bl);
            this.D.sendChanges();
        }
        catch (Exception exception) {
            Scene.limitExceeded(exception);
        }
    }

    private boolean doEventsReturnRestarted() {
        boolean bl = false;
        Enumeration enumeration = this.D.eventActions.elements();
        while (enumeration.hasMoreElements()) {
            Action action = (Action)enumeration.nextElement();
            if (!action.checkCondition()) continue;
            this.D.informLMS("evento", action.getName());
            action.execute();
            bl |= action.getAction() == 100;
        }
        return bl;
    }

    static void limitExceeded(Exception exception) {
        System.out.println(" \u00a1Se ha excedido el l\u00edmite de 100000 repeticiones en un algoritmo!");
        exception.printStackTrace();
    }

    boolean animationIsRunning() {
        return this.running && !this.pause;
    }

    void startAnimation(boolean bl) {
        if (bl && this.D.cfg.animC.active && this.D.cfg.animC.autorun) {
            this.startAnimation();
        }
    }

    private void startAnimation() {
        if (this.D.cfg.animC.controls) {
            this.b[0].type = -1;
            this.animCtrl.setVisible(true);
        }
        if (this.thr != null) {
            this.pleaseStop = true;
            try {
                for (int i = 0; this.thr != null && this.pleaseStop() && i < 20; ++i) {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.thr != null) {
                System.out.println("thread forced to stop");
                this.thr.stop();
                this.thr = null;
            }
        }
        this.thr = new Thread(this);
        this.thr.start();
    }

    Space getSpace(int n, String string) {
        int n2;
        for (n2 = 0; n2 < this.D.cfg.sc.length; ++n2) {
            if (this.D.cfg.sc[n2] == null || !this.D.cfg.sc[n2].getName().equals(string)) continue;
            return this.spa[n2];
        }
        for (n2 = 0; n2 < this.D.cfg.sc.length; ++n2) {
            if (this.D.cfg.sc[n2] == null || this.D.cfg.sc[n2].type != n) continue;
            return this.spa[n2];
        }
        if (this.spa.length > 0) {
            return this.spa[0];
        }
        return null;
    }

    Space getSpace(String string) {
        for (int i = 0; i < this.D.cfg.sc.length; ++i) {
            if (!this.D.cfg.sc[i].getName().equals(string)) continue;
            return this.spa[i];
        }
        return null;
    }

    Space getSpace(int n) {
        for (int i = 0; i < this.D.cfg.sc.length; ++i) {
            if (this.D.cfg.sc[i].type != n) continue;
            return this.spa[i];
        }
        return null;
    }

    void stopAnimation() {
        this.pleaseStop = true;
        while (this.isRunning()) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
    }

    void stopAnimations() {
        this.stopAnimation();
        if (this.spa != null) {
            for (int i = this.spa.length - 1; i >= 0; --i) {
                this.spa[i].stopMoving();
            }
        }
    }

    private boolean pleaseStop() {
        return this.pleaseStop;
    }

    private boolean isStopping() {
        return this.stopping;
    }

    public void registerTextsInParser() {
        if (this.spa != null) {
            for (int i = 0; i < this.spa.length; ++i) {
                this.spa[i].registerTextsInParser();
            }
        }
    }

    public void updateTextsFromNodes() {
        if (this.spa != null) {
            for (int i = 0; i < this.spa.length; ++i) {
                this.spa[i].updateTextsFromNodes();
            }
        }
    }

    void stop() {
        int n;
        this.stopping = true;
        this.stopAnimations();
        if (this.D instanceof Arquimedes && this.EC != null) {
            this.EC.stop();
        }
        if (this.spa != null) {
            for (n = this.spa.length - 1; n >= 0; --n) {
                this.spa[n].stop();
            }
        }
        if (this.numCtrl != null) {
            for (n = this.numCtrl.size() - 1; n >= 0; --n) {
                ((NumericControl)this.numCtrl.elementAt(n)).stop();
            }
        }
        if (this.SceneNumCtrl != null) {
            for (n = this.SceneNumCtrl.size() - 1; n >= 0; --n) {
                ((NumericControl)this.SceneNumCtrl.elementAt(n)).stop();
            }
        }
        this.stopping = false;
    }

    boolean isRunning() {
        return this.running;
    }

    public void run() {
        this.pleaseStop = false;
        this.running = true;
        this.onestep = false;
        this.stay = false;
        this.pause = false;
        this.updateAnimationButtons();
        Node node = this.D.p.Analyse(this.D.cfg.animC.s_value[0], "60");
        try {
            this.animAlg.initialize();
            boolean bl = false;
            while (!this.pleaseStop()) {
                Thread.sleep(20L);
                do {
                    Thread.sleep(Math.max(20L, Math.round(node.Evaluate(50.0))));
                    if (this.pause && !this.onestep) continue;
                    this.stay = false;
                    this.animAlg.step();
                    this.onestep = false;
                    if (this.isStopping()) continue;
                    this.doAlgorithms(false);
                    if (this.doEventsReturnRestarted()) continue;
                    this.updateScene(false);
                } while (!this.pleaseStop() && this.animAlg.repeat());
                if (this.stay || this.D.cfg.animC.loop) continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.running = false;
        if (!this.isStopping()) {
            this.animCtrl.setVisible(false);
            this.updateAnimationButtons();
            this.updateScene(false);
        }
        this.thr = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.b[0]) {
            this.toggleAnimation();
        } else if (actionEvent.getSource() == this.b[2]) {
            this.animAlg.initialize();
            if (this.pause) {
                this.refreshScene(true);
            }
        } else if (actionEvent.getSource() == this.b[3]) {
            this.pause = true;
            this.backStep();
        } else if (actionEvent.getSource() == this.b[4]) {
            this.pause = true;
            this.onestep = true;
        } else if (actionEvent.getSource() == this.b[5]) {
            this.pause = true;
            this.toEnd();
        } else if (actionEvent.getSource() == this.b[1]) {
            this.stopAnimation();
        } else if (actionEvent.getSource() instanceof mjaLabelAndText) {
            for (int i = 0; i < this.D.cfg.auxiliar.length; ++i) {
                if (this.D.cfg.auxiliar[i].type != 104 || !this.D.cfg.auxiliar[i].isEditable) continue;
                this.D.p.defineExpr(this.D.cfg.auxiliar[i].getName(), this.D.cfg.auxiliar[i].exprEd.getInfo());
            }
            this.D.clear(false);
            this.refreshScene(false);
        } else if (actionEvent.getSource() instanceof JTextField) {
            for (int i = 0; i < this.graph.length; ++i) {
                if (!this.graph[i].gc.isEditable) continue;
                this.graph[i].gc.formula = this.graph[i].TF.getText();
                this.graph[i].analyse();
                if (!this.graph[i].gc.isInBack) continue;
                this.graph[i].cs.doBack(false);
            }
            this.refreshScene(true);
        } else if (actionEvent.getSource() == this.EC && this.EC.isEditing()) {
            int n = this.EC.getText().getY(this, this.EC.getText().getCursorPos());
            if (n - 50 < this.jsb.getValue()) {
                this.jsb.setValue(n - 50);
            } else if (this.jsb.getValue() < n - (this.jp.getSize().height - 25)) {
                this.jsb.setValue(n - (this.jp.getSize().height - 25));
            }
            this.jsb.setMaximum(Math.max(this.EC.getCanvasHeight() - this.jp.getSize().height + 240, 0));
            this.jsb.setVisibleAmount(250);
            if (this.EC.getLocation().y != -this.jsb.getValue()) {
                this.EC.setLocation(0, -this.jsb.getValue());
                this.EC.repaint();
            }
        }
    }

    private void updateAnimationButtons() {
        this.b[0].type = !this.animationIsRunning() ? 0 : -1;
        this.b[0].paintAll(this.b[0].getGraphics());
        this.D.updateAnimationButtons();
    }

    private void backStep() {
        try {
            this.animAlg.backstep();
            this.refreshScene(true);
        }
        catch (Exception exception) {
            Scene.limitExceeded(exception);
        }
    }

    private void toEnd() {
        try {
            this.animAlg.toEnd();
            this.refreshScene(true);
            this.stay = true;
        }
        catch (Exception exception) {
            Scene.limitExceeded(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * Unable to fully structure code
     */
    public void mouseClicked(MouseEvent var1_1) {
        block6: {
            block5: {
                if (var1_1.getModifiers() != 4 && (!BasicStr.ShiftOn || !BasicStr.CtrlOn)) break block5;
                this.D.showExternalSpinners();
                break block6;
            }
            if (var1_1.getClickCount() != 2) ** GOTO lbl-1000
            v0 = this;
            if (v0.D.inNippeEditor() && var1_1.getSource() == this.EC) {
                this.D.edit(var1_1.getSource());
            } else if (var1_1.getClickCount() == 2 && !BasicStr.osIsWindows() && var1_1.getSource() == this.EC) {
                this.D.edit(var1_1.getSource());
            } else if (var1_1.getClickCount() == 1 && BasicStr.CtrlOn && !BasicStr.ShiftOn && this.D.canEdit()) {
                this.D.edit(var1_1.getSource());
            }
        }
        BasicStr.CtrlOn = false;
        BasicStr.ShiftOn = false;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        BasicStr.CtrlOn = keyEvent.isControlDown();
        BasicStr.ShiftOn = keyEvent.isShiftDown();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        BasicStr.CtrlOn = false;
        BasicStr.ShiftOn = false;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.EC.containerSize = this.jp.getSize().height;
        this.jsb.setMaximum(Math.max(this.EC.getCanvasHeight() - this.EC.containerSize + 250, 0));
        this.jsb.setUnitIncrement(20);
        if (!adjustmentEvent.getValueIsAdjusting() || this.EC.getCanvasHeight() < 5000) {
            this.jsb.setVisibleAmount(250);
            this.EC.setLocation(0, -this.jsb.getValue());
            this.EC.paint(this.EC.getGraphics());
            this.paintSceneControls();
            this.paintSceneSpaces();
            this.paintControls();
        }
    }

    static {
        sceneBackColor = new Color(0xFFFFFF);
    }
}

