/*
 * Decompiled with CFR 0.152.
 */
package org.cnice.rad.client.learner;

import com.mja.parser.Parser;
import com.mja.text.BasicText;
import com.mja.text.RTF;
import com.mja.text.Text;
import com.mja.util.BasicStr;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.cnice.rad.client.Client;
import org.cnice.rad.client.ClientDialog;
import org.cnice.rad.client.learner.Actividad;
import org.cnice.rad.common.ExceptionResponse;
import org.cnice.rad.common.Message;
import org.cnice.rad.common.SqlMetadata;
import org.cnice.rad.learner.CloseActivityRequest;
import org.cnice.rad.learner.CloseSesionEquipoRequest;
import org.cnice.rad.learner.InsertActivityRequest;
import org.cnice.rad.learner.InsertActivityResponse;
import org.cnice.rad.learner.UpdateActivityRequest;

public class LearnerClient
extends Client {
    private static volatile LearnerClient cl;
    private static volatile ClientDialog cd;
    public static boolean tiempoReal;
    private String[] alumnos;
    private PrintStream logps;
    private StringBuffer loginfo;
    private String infoind = "";
    private String infoest = "";

    public static LearnerClient client() {
        return cl;
    }

    public static synchronized void initRAD(String string, String string2) {
        int n = 8082;
        int n2 = 8082;
        if (cl == null) {
            try {
                LearnerClient.tracePrint("Connecting " + string + " to server " + string2 + " at port " + n);
                cl = new LearnerClient(string, string2, n, n2);
                cl.connect();
                if (cl.isConnected()) {
                    if (cd == null) {
                        cd = new ClientDialog(cl);
                        LearnerClient.tracePrint("conectado al RAD");
                    } else {
                        cd.setClient(cl);
                    }
                    boolean bl = cd.getSesionEquipo();
                    if (bl) {
                        cl.setLog(System.out);
                        LearnerClient.cl.alumnos = cd.getAlumnos();
                    } else {
                        cl = null;
                    }
                    String string3 = "";
                    if (BasicStr.hasContent((String)string)) {
                        string3 = string + " ";
                    }
                    System.out.println(string3 + "conectado al servidor RAD " + string2);
                } else {
                    LearnerClient.tracePrint("connexion to RAD failed");
                    cl = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                cl = null;
            }
        }
    }

    public String[] getAlumnos() {
        return this.alumnos;
    }

    public LearnerClient(String string, String string2, int n, int n2) {
        super(string, string2, n, n2);
    }

    public void setUser(String string, String string2) {
        super.setUser(string, string2);
        if (string != null && string.length() > 0) {
            this.loginfo = new StringBuffer();
        }
    }

    public void setLog(String string) {
        if (string != null) {
            try {
                String string2 = string = string.replace('/', File.separatorChar);
                int n = string2.lastIndexOf(File.separatorChar);
                if (n >= 0) {
                    string2 = string2.substring(0, n + 1);
                }
                File file = new File(string2);
                file.mkdirs();
                this.logps = new PrintStream(new BufferedOutputStream(new FileOutputStream(string, true)));
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void setLog(PrintStream printStream) {
        this.logps = printStream;
    }

    private void logprintln(String string, String string2) {
        if (this.loginfo != null) {
            this.loginfo.append(string2 + "\n");
        }
    }

    public void ProgramFinish() {
        if (this.logps != null) {
            try {
                if (this.isConnected()) {
                    try {
                        boolean bl = this.executeCloseSesionEquipo(LearnerClient.cd.id_sesion_equipo);
                    }
                    catch (Exception exception) {
                        LearnerClient.tracePrint(exception);
                    }
                }
                this.logps.close();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public Actividad RADInitialize(String string, String string2, String string3, String string4, String string5, String string6) {
        String[] stringArray = null;
        Actividad actividad = null;
        if (this.isConnected()) {
            try {
                String string7 = SqlMetadata.getDateTimeString();
                stringArray = this.executeInsertActividad(LearnerClient.cd.id_sesion_equipo, string7, string, string2, string3, string4, string5, string6);
                this.infoind = string5;
                this.infoest = string6;
            }
            catch (Exception exception) {
                LearnerClient.tracePrint(exception);
            }
        }
        if (stringArray != null) {
            actividad = new Actividad((String)stringArray[0]);
        }
        return actividad;
    }

    private String[] executeInsertActividad(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws Exception {
        InsertActivityRequest insertActivityRequest = new InsertActivityRequest(this.user_login, this.user_password, string, string2, string3, string4, string5, string6, string7, string8);
        Message message = this.sendRequest(insertActivityRequest);
        if (message == null) {
            throw new Exception("Unreachable destination");
        }
        if (message.getType() == 16) {
            return ((InsertActivityResponse)message).getInfo();
        }
        if (message.getType() == 0) {
            throw new Exception(((ExceptionResponse)message).getExceptionMessage());
        }
        LearnerClient.tracePrint("Unexpected Response Type");
        return null;
    }

    public void RADFinish(Actividad actividad, Parser parser, int n, int n2, int n3) {
        if (this.isConnected() && actividad.getID() != null) {
            try {
                Parser parser2 = new Parser(0);
                Text text = new Text(parser2);
                RTF.parseRTF((String)this.infoind, (BasicText)text);
                RTF.parseRTF((String)this.infoest, (BasicText)text);
                String[][] stringArray = parser2.getVariables();
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i][1] = Double.toString(parser.Var(stringArray[i][0]).getDouble());
                }
                long l = actividad.getInitialMillis();
                long l2 = System.currentTimeMillis();
                long l3 = (l2 - l) / 1000L;
                long l4 = (l2 - l) / 10L - l3 * 100L;
                this.executeUpdateActivity(actividad.getID(), "auto", "final", l3, l4, stringArray);
                String string = SqlMetadata.getDateTimeString();
                this.executeCloseActivity(actividad.getID(), string, n, n2, n3);
            }
            catch (Exception exception) {
                LearnerClient.tracePrint(exception);
            }
        }
    }

    private void executeCloseActivity(String string, String string2, int n, int n2, int n3) throws Exception {
        CloseActivityRequest closeActivityRequest = new CloseActivityRequest(this.user_login, this.user_password, string, string2, n, n2, n3);
        if (tiempoReal) {
            this.sendRequest(closeActivityRequest);
        } else {
            this.queueRequest(closeActivityRequest);
            this.sendQueue();
        }
    }

    public void RADAddAction(Actividad actividad, String string, String string2, String[][] stringArray) {
        if (this.isConnected() && actividad != null && actividad.getID() != null) {
            try {
                long l = actividad.getInitialMillis();
                long l2 = System.currentTimeMillis();
                long l3 = (l2 - l) / 1000L;
                long l4 = (l2 - l) / 10L - l3 * 100L;
                this.executeUpdateActivity(actividad.getID(), string, string2, l3, l4, stringArray);
            }
            catch (Exception exception) {
                LearnerClient.tracePrint(exception);
            }
        }
    }

    private void executeUpdateActivity(String string, String string2, String string3, long l, long l2, String[][] stringArray) throws Exception {
        UpdateActivityRequest updateActivityRequest = new UpdateActivityRequest(this.user_login, this.user_password, string, string2, string3, Long.toString(l), Long.toString(l2), stringArray);
        if (tiempoReal) {
            this.sendRequest(updateActivityRequest);
        } else {
            this.queueRequest(updateActivityRequest);
        }
    }

    private boolean executeCloseSesionEquipo(String string) throws Exception {
        CloseSesionEquipoRequest closeSesionEquipoRequest = new CloseSesionEquipoRequest(this.user_login, this.user_password, string);
        Message message = this.sendRequest(closeSesionEquipoRequest);
        if (message == null) {
            throw new Exception("Unreachable destination");
        }
        if (message.getType() == 22) {
            return true;
        }
        if (message.getType() == 0) {
            throw new Exception(((ExceptionResponse)message).getExceptionMessage());
        }
        LearnerClient.tracePrint("Unexpected Response Type");
        return false;
    }

    static {
        tiempoReal = false;
    }
}

