/*
 * Decompiled with CFR 0.152.
 */
package com.mja.poly;

import com.mja.gui.mjaColor;
import com.mja.math3D.R3;
import com.mja.poly.Face;
import java.awt.Color;

public class viewModel {
    public static final int COLOR = 0;
    public static final int LIGHT = 1;
    public static final int METAL = 2;
    public static final int WIRE = 3;
    private int model = 0;
    private float dim = 1.0f;
    private float uI2 = 0.0f;
    private static final float maxI = 0.00390625f;
    private static final R3[] Light = new R3[]{new R3(50.0, 50.0, 70.0), new R3(50.0, -50.0, 30.0), new R3(20.0, 0.0, -80.0), new R3(0.0, 0.0, 0.0)};
    private static R3[] light;
    private static final float[] Int0;
    private static float[] Int;

    public viewModel() {
        if (light == null) {
            light = new R3[Int.length];
            for (int i = 0; i < Int.length; ++i) {
                viewModel.light[i] = Light[i].ScalarProduct(1.0 / Light[i].Norm());
            }
        }
        this.setModel(0);
    }

    public void setModel(int n) {
        this.model = n;
    }

    public int getModel() {
        return this.model;
    }

    public void setUserIllumination(double d, double d2) {
        this.dim = (float)d;
        this.uI2 = (float)d2 * (float)d2;
        viewModel.Int[0] = Int0[0] * this.dim;
        viewModel.Int[1] = Int0[1] * this.dim;
        viewModel.Int[2] = Int0[2] * this.dim;
        viewModel.Int[3] = (float)d2;
    }

    public void setUserLightPos(int n, int n2, int n3) {
        viewModel.Light[3].x = n;
        viewModel.Light[3].y = n2;
        viewModel.Light[3].z = n3;
    }

    Color getFaceColor(Face face) {
        float f;
        Color color = face.getFrontColor();
        if (this.model == 3) {
            return color;
        }
        if (!face.pointsOut) {
            color = face.getBackColor();
        }
        if (this.model == 0) {
            return color;
        }
        R3 r3 = face.unitNormal;
        if (!face.pointsOut) {
            r3 = r3.ScalarProduct(-1.0);
        }
        int n = 0;
        int n2 = 2;
        if (this.dim == 0.0f) {
            n = 3;
        }
        if (this.uI2 > 0.0f) {
            viewModel.light[3] = Light[3].cloneR3();
            light[3].subtract(face.average);
            f = (float)light[3].Norm();
            viewModel.Int[3] = this.uI2 / f;
            n2 = 3;
        }
        f = this.model == 1 ? this.dim / 4.0f : this.dim / 2.0f;
        float f2 = 0.0f;
        for (int i = n; i <= n2; ++i) {
            if (this.model == 1) {
                f2 = Math.max(0.0f, (float)light[i].DotProduct(r3));
            } else {
                f2 = Math.max(0.0f, (float)R3.reflectedRay(light[i], r3).DotProduct(face.unitToEye));
                f2 = f2 * f2 * f2;
            }
            f += Int[i] * f2;
        }
        f = Math.min(f / 256.0f, 0.00390625f);
        return mjaColor.scaleColor(f, color);
    }

    static {
        Int0 = new float[]{0.4f, 0.5f, 0.3f, 0.0f};
        Int = new float[]{Int0[0], Int0[1], Int0[2], Int0[3]};
    }
}

